/***************************************************************************
 *   Copyright (C) 2005 by M. Mar Abad Grau 				   *
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef __MLComparison_cpp__
#define __MLComparison_cpp__



#include "MLComparison.h"//



namespace BIOS
{

 
 
  

MLComparison::MLComparison(int argc, char *argv[])
{

inputTUI=new InputTUI(argc, argv, "MLComparison");
char fileSample[256], fileTestSample[256], completeFileSample[256], completeFileTestSample[256], path[256], outputFile[256];
strcpy(path, GetFilePath(inputTUI->filename));
ClassificationResults* tasaAciertos=new ClassificationFinalResults(), *currentTasaAciertos;
ClassifierTest *classifierTest=NULL;
strcpy(fileSample, inputTUI->filename);
int classPosition;
LossFunction* lossFunction;
floatMLSample* sample=NULL, *testSample=NULL; 
int totalClasses, currentClass;
char filePos[256];
ChangeExtension(fileSample, filePos, "pos");
ListOfAttributes* listOfAttributes=NULL;
ClassificationResults* val;
if (inputTUI->verbosity.verbosityR.configuration)
cout << "\n";
//while (!InputFile.eof())
//{
strcpy(completeFileSample, path);
strcat(completeFileSample, fileSample);
if (inputTUI->testMode==tHoldout)
{
ChangeExtension(fileSample, fileTestSample, "test");
strcpy(completeFileTestSample, path);
strcat(completeFileTestSample, fileTestSample);
}


if (inputTUI->verbosity.verbosityR.configuration)
cout << fileSample << "\n" ;

if (existFile(filePos)) listOfAttributes=new ListOfOrderedAttributes(completeFileSample, inputTUI->verbosity.verbosityR.attributeDescription);
else listOfAttributes=new ListOfAttributes(completeFileSample, inputTUI->verbosity.verbosityR.attributeDescription);


//  if (inputTUI->selectedClassPosition==-2) classPosition=listOfAttributes->GetSize()-1; else
classPosition=inputTUI->selectedClassPosition;
if (classPosition==-2) classPosition=listOfAttributes->GetSize()-1;
if (classPosition>=listOfAttributes->GetSize())
{
cout <<"Error in selected class " << classPosition <<", out of range";
end();
}

sample=new floatMLSample(completeFileSample, inputTUI->verbosity);
if (inputTUI->testMode==tHoldout)
testSample=new floatMLSample(completeFileTestSample, inputTUI->verbosity);
CompleteMissing* completeMissing=NULL;
floatSample* completeSample=NULL;

if (inputTUI->verbosity.verbosityR.completeSample)
{
strcpy(outputFile, completeFileSample);
ofstream OutputFile;
strcat(outputFile, "Completed");
OpenOutput(outputFile, &OutputFile);


completeMissing=new CompleteMissing(sample->sample);
OutputFile << completeMissing->completedSample;
zap(completeMissing);
OutputFile.close();
}

totalClasses=0;
currentClass=classPosition;
bool noSelection=true;
if (inputTUI->selMode==manual && inputTUI->selection->GetSize()==0) noSelection=true;
for (int i=0;i<listOfAttributes->GetSize();i++)
if (classPosition==-1 || classPosition==i || (classPosition==-3 && i<(listOfAttributes->GetSize()-1)))
{  
totalClasses++;
if (classPosition<0) currentClass=i; 
if (inputTUI->selMode==manual && noSelection) 
inputTUI->selection->insertElement(currentClass);

lossFunction=new LossFunction(inputTUI->useFileForLossFunction, listOfAttributes->GetElement(currentClass)->GetTotalModalidades(), completeFileSample);

if (inputTUI->testMode!=tHoldout)
classifierTest=new ClassifierTest(sample, NULL, NULL, inputTUI->testMode, inputTUI->numberOfFolds, inputTUI->verbosity, currentClass, lossFunction);
else
classifierTest=new ClassifierTest(NULL, sample, testSample, inputTUI->testMode, inputTUI->numberOfFolds, inputTUI->verbosity, currentClass, lossFunction);


currentTasaAciertos=classifierTest->getAveragedAccuracy(inputTUI->algType, inputTUI->discMode, inputTUI->algorithmParameters, inputTUI->discretization, inputTUI->selMode, inputTUI->selection, inputTUI->selSubmodeClass.selectionFile, inputTUI->stochastic);

if (inputTUI->verbosity.verbosityR.accuracy)
{
tasaAciertos->set.averageAccuracy=tasaAciertos->set.averageAccuracy+currentTasaAciertos->set.averageAccuracy;
tasaAciertos->set.sd=tasaAciertos->set.sd+currentTasaAciertos->set.sd;
cout   << "\n" <<  currentTasaAciertos->set.averageAccuracy;
}

if (inputTUI->verbosity.verbosityR.euclideanDistance)
tasaAciertos->set.euclideanDistance=tasaAciertos->set.euclideanDistance+currentTasaAciertos->set.euclideanDistance;


if (lossFunction->decisionThreshold>0) cout  << "\t" << currentTasaAciertos->set.averageUncovered << "\n";



if (inputTUI->verbosity.verbosityR.true_predictedValues && currentTasaAciertos->set.true_PredictedTable!=NULL)
cout   << *currentTasaAciertos->set.true_PredictedTable << "\n";


if (inputTUI->verbosity.verbosityR.selection && classifierTest->selectedAttributes!=NULL) // && selMode!=todos && numberOfFolds!=2) 
cout  << *classifierTest->selectedAttributes << "\n";//->print();
zap(classifierTest);
zap(lossFunction);

if (inputTUI->selMode==manual && noSelection) inputTUI->selection->Pop();
}//end for

if (inputTUI->verbosity.verbosityR.accuracy)
{
tasaAciertos->set.averageAccuracy=tasaAciertos->set.averageAccuracy/totalClasses;
tasaAciertos->set.sd=tasaAciertos->set.sd/totalClasses;
}

if (inputTUI->verbosity.verbosityR.euclideanDistance)
tasaAciertos->set.euclideanDistance=tasaAciertos->set.euclideanDistance/totalClasses;

zap(listOfAttributes);
zap(sample);
if (inputTUI->testMode==tHoldout) zap(testSample);
//c++;
//InputFile >> fileSample;
//};// fin for each muestra

//InputFile.close();
//acc->GetMean(tasaAciertos, totalSamples);
if (inputTUI->verbosity.verbosityR.accuracy)
{
cout <<"\n\nTotal prueba medio: " << tasaAciertos->set.averageAccuracy  <<"+-" <<tasaAciertos->set.sd;
cout <<"\n";
}
if (inputTUI->verbosity.verbosityR.euclideanDistance)
{
cout <<"\n\nTotal Euclidean distance: " << tasaAciertos->set.euclideanDistance;
cout <<"\n";
}

};
}


using namespace BIOS;

int main(int argc, char *argv[])
{

  MLComparison *mLComparison;

  mLComparison=new MLComparison(argc, argv);

};



#endif




