/***************************************************************************
 *   Copyright (C) 2005 by M. Mar Abad Grau 				   *
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/* File: MissingImputation.h */





//#include "discretization/DiscModeClass.h"
//#include "selection/SelMode.h"
//#include "AlgTypeClass.h"
#include "FachadeML.h"

using namespace std;

namespace BIOS {

class MissingImputation {


bool hasClass;
InputTUI* inputTUI;
int totalAttributes;
floatMLSample* sample;
ListOfAttributes *listOfAttributes;

public:

MissingImputation(int argc, char *argv[]);
~MissingImputation();

bool isAModifier(char* c);
void runSamples (int i);
void runSelected (int i, SelMode selMode, floatList *selection2=NULL);
int getExtremeInChromosome (int i, bool first=true);
int getFirstInChromosome (int i) {return getExtremeInChromosome(i, true);};
int getLastInChromosome (int i) {return getExtremeInChromosome(i, false);};
void runSample (int i, bool includeClass, floatList* otherValues);
int getPositionInOtherChromosome (int i, int j);
floatList*  filterKernelSelection(int i);
floatList*  blockSelection(int i);

};

/*_________________________________________________________________________*/
/*
void MissingImputation::runSamples (int i, int totalAttributes)
{
SelMode selMode=manual;
intList *selection2=new intList();
selection2->insertElement(i);
int lr=i+1;
int ll=i-1;
int s;
//cout <<"\n\n" << i <<"\ntotatt" << totalAttributes<<"\n";
for (int i2=0;i2<totalAttributes;i2++)
{
//cout <<"\natt " << i2 << ":\n"; 
if (i2==1 && isClass)
selection2->insertElement(totalAttributes-1);// phenotype
if ((i2>1 && i2<totalAttributes && isClass) || (i2>0 && i2<totalAttributes && !isClass))
{
if (isClass)
if (i2%2==0)  { s=lr%(totalAttributes-1);lr=lr+1;}
else {if (ll<0) ll=totalAttributes-1+ll; s=ll%(totalAttributes-1); ll=ll-1;}
else //noClass
if (i2%2==0)  { s=lr%(totalAttributes);lr=lr+1;}
else {if (ll<0) ll=totalAttributes+ll; s=ll%(totalAttributes); ll=ll-1;};

//cout <<s <<"-";
//if (i<s) s--;
selection2->insertElement(s);
}
//if (selection2!=NULL)
cout <<"sel" <<*selection2 <<"class:" <<i <<"\n";
//cout <<"totalins" << selection2->GetSize();
runSelected(i, manual, selection2);
//cout <<"\n";
//if (i2==2) end();
//cout <<"\n\n" << i2 <<":";
} // end for
zap(selection2);
}

/*_________________________________________________________________________*/

int MissingImputation::getExtremeInChromosome (int i, bool first)
{
string name=listOfAttributes->GetElement(i)->GetName(), name2;
int totalRelevants=totalAttributes;
if (hasClass) totalRelevants=totalRelevants-1;
if (strncmp(name.c_str(), "chrom", 5)!=0) 
if (first==true) return 0; else return totalRelevants-1;
name=name.substr(5,2);
int chrom=atoi(name.c_str());

int result, j;
if (first) {result=0; j=i-1;} else {result=totalRelevants-1; j=i+1;};
bool found=false;
while (((first && j>0) || (!first && j<totalRelevants)) && !found)
{
name2=listOfAttributes->GetElement(j)->GetName();
name2=name2.substr(5,2);
if (atoi(name2.c_str())!=chrom) 
{
found=true;
if (first) result=j+1; else result=j-1;
}
else
if (first) j--; else j++;
}
return result;
}
/*_________________________________________________________________________*/

int MissingImputation::getPositionInOtherChromosome (int i, int j)
{
int totalRelevants=totalAttributes;
if (hasClass) totalRelevants=totalRelevants-1;

int cont=0, position=-1;
int first=getFirstInChromosome(i), last=getLastInChromosome(i);
while (cont<totalRelevants && position<j)
{
if (cont>last || cont<first) position++;
cont++;
}
return cont-1;
}
/*_________________________________________________________________________*/

void MissingImputation::runSample (int i, bool includeClass, floatList* otherValues)
// otherValues is empty for MS and PS (depending on the includeClass value, 1 and so on for the remaining configurations
{
floatList *selection2=new floatList();
selection2->insertElement(i);
if (includeClass)
if (!hasClass)
{
cout <<"Error in MissingImputation::runSample. The input file has no class";
end();
}
else selection2->insertElement(totalAttributes-1);
selection2->copyPaste(otherValues);
runSelected(i, manual, selection2);
//cout <<"sel" <<*selection2 <<"class:" <<i <<"\n";

zap(selection2);
}
/*_________________________________________________________________________*/

void MissingImputation::runSamples (int i)
{
//cout <<"runsamplesi";
floatList* includeValues=new floatList();

runSample(i, false, includeValues);

if (hasClass)
runSample(i, true, includeValues);

int totalRelevants=totalAttributes-1;// att i already inserted
if (hasClass) totalRelevants--;
int first=getFirstInChromosome(i);
int last=getLastInChromosome(i);
int totalInChromosome=last-first+1;

int s=i;
int lr=i+1;
int ll=i-1;
bool altern=true, left=true;

for (int i2=0;i2<totalRelevants;i2++)
{
 if (i2<(totalInChromosome-1))
{
if (s==first || s==last) 
{
altern=false;
if (s==first) 
{
left=false;
s=lr-1;
}
else s=ll+1;
}
if (altern)
if (i2%2==0)  { s=lr;lr=lr+1;}
else {if (ll<0) ll=totalInChromosome+ll; s=ll; ll=ll-1;}
else // non alternate
{
if (left) 
{
s=s-1; 
if (s==i) s=s-1;
}
else 
{
s=s+1;
if (s==i) s=s+1;
}
}
}
else 
{
s=getPositionInOtherChromosome(i, i2-totalInChromosome+1);
if (i2==totalInChromosome-1) cout << "-1" << "\t";

}
includeValues->insertElement(s);
runSample(i, hasClass, includeValues);
} // end for

zap(includeValues);

}
  /*____________________________________________________________________________________________*/

floatList*  MissingImputation::filterKernelSelection(int i)
{
char fileKernel[256];
ChangeExtension(sample->filename, fileKernel, "ke");
floatSample* kernels=new floatSample(fileKernel);
floatList* currentKernel=new floatList(*kernels->GetElement(i));
if (hasClass) currentKernel->insertElementAtPos(totalAttributes-1,0);
zap(kernels);
return (currentKernel);
}
/*____________________________________________________________________________________________*/

floatList*  MissingImputation::blockSelection(int i)
{
char fileBl[256];
intSample* blocks=NULL;
intSample::NodePointer p;
bool found=false;
intList* block;
floatList* selectionFinal=new floatList();
if (hasClass) selectionFinal->insertElement(totalAttributes-1);
ChangeExtension(inputTUI->filename, fileBl, "bl");
blocks=new intSample(fileBl);
//if (i==47)
//cout <<"blocks:" << *blocks;
p=blocks->GetFirst();

while (p!=NULL && !found)
{
block=blocks->GetElement(p);
if (block->findElement(i+1)!=NULL)
found=true;
else p=blocks->GetNext(p);
}
floatList* floatBlock=block->getFloatList();
floatList::NodePointer pB=floatBlock->GetFirst();
while(pB!=NULL)
{
selectionFinal->insertElement(floatBlock->GetElement(pB)-1);
pB=floatBlock->GetNext(pB);
}
zap(blocks);
if (!found)
{
cout << "Error in  MissingImputation::runSelected. Att " << i << " was not found";
end();
}
return selectionFinal;
}
/*____________________________________________________________________________________________*/

void MissingImputation::runSelected (int i, SelMode selMode, floatList *selection2)
{
//cout <<"selection:" << *selection2;

floatList* selectionFinal=NULL;

//cout <<"\ncurrentsel is:" << *selection2;

selectionFinal=new floatList(*selection2);

/*
if (selection2->GetSize()>=1)
if (selection2->GetFirstElement()==4 && !hasClass) {cout <<"Error in runSelected, incorrect selection mode"; end();}

if (selMode!=transformedManual) selectionFinal=new floatList(*selection2);
else
{
if (selection2->GetSize()==0) {cout <<"Error in runSelected, no parameter in selection"; end();}
if (selection2->GetFirstElement()<1 || selection2->GetFirstElement()>4) {cout <<"Error in runSelected, incorrect parameter in selection"; end();}
switch ((int)selection2->GetFirstElement())
{
case 1:  selectionFinal=filterKernelSelection(i); 
case 2: selectionFinal=blockSelection(i); 
case 3:  selectionFinal=new floatList(); selectionFinal->insertElement(i);
case 4: selectionFinal=new floatList(); selectionFinal->insertElement(i);
        if (hasClass) selectionFinal->insertElement(totalAttributes-1);
default: selMode=manual;
}
}
*/

//cout <<"att: " << i <<" belongs to block " << *selectionFinal <<"\n";

ClassificationResults val;

LossFunction *lossFunction=new LossFunction(inputTUI->useFileForLossFunction, sample->listOfAttributes->GetElement(i)->GetTotalModalidades(), inputTUI->filename);
ClassifierTest *classifierTest=new ClassifierTest(sample, NULL, NULL, inputTUI->testMode, inputTUI->numberOfFolds, inputTUI->verbosity, i, lossFunction);
val=classifierTest->getAveragedAccuracy(inputTUI->algType, inputTUI->discMode, inputTUI->algorithmParameters, inputTUI->discretization, selMode, selectionFinal);
 if (inputTUI->verbosity.verbosityR.accuracy)
cout << val.set.averageAccuracy << "\t";
zap(lossFunction);
zap(classifierTest);
zap(selectionFinal);
}
/*_________________________________________________________________________*/

MissingImputation::MissingImputation(int argc, char *argv[])
{

inputTUI=new InputTUI(argc, argv, "MissingImputation");

char fileSample[256], completeFileSample[256], fileMas[256], fileNames[256];
//strcpy(path, GetFilePath(inputTUI->filename));


char filePos[256];
ChangeExtension(inputTUI->filename, filePos, "pos");

ifstream InputFile;
OpenInput(inputTUI->filename, &InputFile);

//cout <<"\ninitial list name is: " << listOfAttributes->getName();

sample=new floatMLSample(inputTUI->filename, inputTUI->verbosity);
totalAttributes=sample->listOfAttributes->GetTotalAttributes();
listOfAttributes=sample->listOfAttributes->clone();
string name;
ofstream OutputFile;

hasClass=false;
if (strcmp(listOfAttributes->GetLastElement()->GetName().c_str(), "class")==0)
hasClass=true;
int total=totalAttributes;


if (hasClass) 
{
if (inputTUI->selectedClassPosition>1)
{
cout <<"Error, class must be a boolean";
end();
}


if (inputTUI->selectedClassPosition<1) // not to include class
{
totalAttributes--;

intList* attList=new intList(totalAttributes);

floatMLSample* sample2=sample->copyColumns(attList);
zap(attList);

zap(sample);
sample=sample2;

listOfAttributes->Pop();
hasClass=false;
}

total--;
//cout <<"total is:" << total;
}



for (int i=0;i<total;i++)
{
runSelected(i, inputTUI->selMode, inputTUI->selection);
/*
if (inputTUI->selMode==todos) 
runSelected(i, todos, NULL);
//runSamples (i);
else runSelected(i, inputTUI->selMode, inputTUI->selection);
*/
cout <<"\n";
}

InputFile.close();
zap(sample);

zap(listOfAttributes);
};

/*_________________________________________________________________________*/

MissingImputation::~MissingImputation() 
{
zap(inputTUI);

};


}






