/* File: BN.cpp */


#ifndef __BN_cpp__
#define __BN_cpp__


#include "BN.h"


//using namespace UTILS;


namespace BIOS
{

  /*____________________________________________________________________________________ */

  BN::BN(floatMLSample* sample, int classPosition, floatList* algorithm, VerbosityClass verbosity, LossFunction* lossFunction):Classifier(sample, classPosition, algorithm, verbosity, lossFunction), GBN(sample, algorithm, verbosity, totalClasses)
  {
  };
  /*____________________________________________________________________________________ */

  BN::BN():Classifier(), GBN()
  {
  };

  /*____________________________________________________________________________________ */

  BN::~BN()
  {
  };
 /*____________________________________________________________________________________ */
/*
  float BN::getSNPDistance(int att)
  {
//it actually returns (1-exp(-d)), with d in hundred kilobases

//cout <<"bayestype:" << bayesType <<", parents:" <<*parents[att];
if ((bayesType==BDistanceUniform)// || bayesType==BDistanceMarginal)
&& (!empty(parents[att]) && (parents[att]->GetSize()==1)))
return sample->getSNPDistance(att, parents[att]->GetFirstElement());
else cout << "Error in CPT:CPT, estimator " << bayesType << " is only allowed for NB";
return distance;
  }

/*____________________________________________________________________________________ */

/*
 void BN::extractDistancesVector()
{
directMethod=false;
//positions=NULL;
//bayesType=MLE;
//alpha=0;


if (bayesType==BDistanceUniform || bayesType==BDistanceMarginal)
 Classifier::extractDistancesVector(3);
}
 
/*____________________________________________________________________________________ */

  void BN::set()
  {

   GBN::set(); 
   set();
report();
if (GBN::verbosity.verbosityR.parameters) printProbabilityTables(); 

  
   };
  /*____________________________________________________________________________________ */

  intList* BN::discretizePattern(floatList* inputPattern, int totalClasses)
  {
       inputPattern->insertElementAtPos(totalClasses, classPosition);//frequired for sample->listOfAttributes->getDiscretePositions;
    intList* discreteInputPattern=sample->listOfAttributes->getDiscretePositions(inputPattern);
    inputPattern->removeNode(classPosition);
  //  discreteInputPattern->removeNode(classPosition);
    return(discreteInputPattern);
  }
  /*____________________________________________________________________________________ */

  double* BN::GetClassFrequencies(floatList* inputPattern) 
  {
//double *classFrequencies=new double[totalClasses];
//return classFrequencies;
  
    intList* discreteInputPattern=discretizePattern(inputPattern, totalClasses);
    double* probs=getPosteriorProb(classPosition, discreteInputPattern,directMethod);
zap(discreteInputPattern);
return probs;

//true when direct method; false when junction tree is used




  }
  

  /*____________________________________________________________________________________ */

  void BN::printCommonColumns(int att, int r, int totalRows)
  {
    Attribute* attribute=discreteSample->listOfAttributes->GetElement(att);
    int totalAttModalidades=attribute->GetTotalModalidades();

    cout <<"\t|";
    int pos, *positions;
    Prob freq;
//float alphaNumerator, alphaDenominator;

    for (int j=0;j<totalAttModalidades;j++)
    {
           pos=totalAttModalidades*r+j;
      pos=j*totalRows+r;
     positions=probTables[att]->getPositions(pos);
//alphaDenominator=getAlphaDenominator(att);
//alphaNumerator=getAlphaNumerator(att, j, alphaDenominator);

          freq=probTables[att]->getValue(positions);//, alphaNumerator, alphaDenominator);
    zaparr(positions);
       cout <<"|";
      if (empty(parents[att]))
      {
        	  cout << freq.print();
        cout <<"\t";
        printf("%0.3f", freq.convert());
        cout <<"\t";
      }
      else
      {
        if ((freq).isUndefined())
          cout <<"\t" << "---"<<"\t";
        else
        {
               cout << freq.print();
          cout <<"\t";
          printf("%0.3f", freq.convert());
          cout <<"\t";
        }
      }

    } // end for each comun
  }
  /*____________________________________________________________________________________ */

  void BN::printHasParents(int att, int r)
  {
    int* positions=probTables[att]->getPositions(r), totalModalidades;
    Attribute* condAttribute;
    stringList* modalidades;
    floatList* valores;

    //////// conditionant attributes columns ///////

    for (int j=1;j<probTables[att]->getDimension();j++)
    {
      condAttribute=discreteSample->listOfAttributes->GetElement(parents[att]->GetElement(( int)j-1));
      if (!condAttribute->isContinuous())
        modalidades=condAttribute->GetModalidades();
      else valores=condAttribute->GetIntervals();
      totalModalidades=condAttribute->GetTotalModalidades();
      cout <<"\t|";

      if (!condAttribute->isContinuous()) cout <<"\t" << modalidades->GetElement(( int)positions[j]);
      else
      {
        if (positions[j]==0) cout << "\t]-,";
        else cout <<"\t" <<"[" << valores->GetElement(( int)positions[j]-1) << ", ";
        if (positions[j]==totalModalidades-1) cout << "-[,";
        else cout <<"\t" << valores->GetElement(( int)positions[j]) << "]";
      }
    } // end for each dimension
    zaparr(positions);
  }
  /*____________________________________________________________________________________ */

  void BN::printHeading(int att)
  {
    int* positions=NULL;
    int* positions2=NULL;
    Attribute* attribute=discreteSample->listOfAttributes->GetElement(att);
    int totalAttModalidades=attribute->GetTotalModalidades();
    int totalColumns=totalAttModalidades;
    stringList* modalidades;
    floatList* valores;

    if (!empty(parents[att])) totalColumns=totalColumns+parents[att]->GetSize();

    cout <<"\n\nProbability table for attribute " << attribute->GetName() <<" (" << att+1 <<")\n\t";


    for (int j=0;j<totalColumns-totalAttModalidades;j++)
      cout << "|\t" << discreteSample->listOfAttributes->GetElement(parents[att]->GetElement(j))->GetName() <<"\t";

    //if (att==totalAttributes-1)
    if (empty(parents[att])) cout <<"\t";


    if (!attribute->isContinuous()) modalidades=attribute->GetModalidades();
    else
    {
      valores=attribute->GetIntervals();


      if (valores==NULL)
      {
        cout <<"not disc";
        end();
      }
    }


    cout << "||";

    for (int j=0;j<totalAttModalidades;j++)
      if (!attribute->isContinuous())
        cout <<"\t" << modalidades->GetElement((int)j) << "\t|";
      else
        if (j==0)
          cout <<"\t" <<"]-," << valores->GetElement(( int)j) << "]\t |";
        else if (j== totalAttModalidades-1) cout <<"\t" <<"]" << valores->GetElement((int)j-1) << ",-[\t |";
        else cout <<"\t" <<"]" << valores->GetElement(( int)j-1) << ","<<  valores->GetElement((int)j) <<"]\t |";


    cout <<"|\n";
  }
  /*____________________________________________________________________________________ */

  void BN::printBody(int att)
  {
    int totalRows=1;
    if (!empty(parents[att])) totalRows=probTables[att]->getSize()/probTables[att]->getDimensionList()->GetElement((int)0);
    /////////////////// rows//////////////////////

    if (att==classPosition) cout <<"\t";
    for (int r=0;r<totalRows;r++)
    {
      if (!empty(parents[att]))
        printHasParents(att, r);
      printCommonColumns(att, r, totalRows);
      cout <<"||\t\n";
    }  // end for each row
  }
  /*____________________________________________________________________________________ */

  void BN::printProbabilityTables()
  {
  //  if (probTables==NULL) setProbTables();
    for (int i=0;i<totalAttributes;i++)
   //   if (discreteSample->listOfAttributes->GetElement(i)->isSelected())
      {
        printHeading(i);
        printBody(i);
      }
    cout <<"\n";
  }

}
;  // Fin del Namespace

#endif

/* Fin Fichero: BN.cpp */
