/* File: TestModeClass.h */

#ifndef __TestModeClass_cpp__
#define __TestModeClass_cpp__



using namespace std;


namespace BIOS {


 	
TestModeClass::TestModeClass(TestMode tm, int numberOfFolds)
{
this->tm=tm;
this->numberOfFolds=numberOfFolds;

if (numberOfFolds<=0 && tm==tCrossValidation)
throw BadFormat("TestModeClass::TestModeClass(TestMode tm, int numberOfFolds)");
if ((tm==tLeaveOneOut || tm==tHoldout || tm==tTraining || tm==tHalfTraining) && numberOfFolds!=-1)
{
cout << "tm is:" << *this <<"\n";
throw BadFormat("TestModeClass::TestModeClass(TestMode tm, int numberOfFolds)");
}
if (tm==tTraining || tm==tHoldout || tm==tHalfTraining) this->numberOfFolds=1;
}

/*_______________________________________________________________________*/

TestModeClass* TestModeClass::clone()
{
if (tm==tCrossValidation) return new TestModeClass(tm, numberOfFolds);
else return new TestModeClass(tm);
}

/*_______________________________________________________________________*/

TestMode TestModeClass::getValue()
{
return tm;
}

/*_______________________________________________________________________*/

int TestModeClass::getNumberOfFolds()
{
return numberOfFolds;
}

/*_______________________________________________________________________*/

string TestModeClass::print (TestMode tm)
{
  switch (tm) //
  { //
   case tLeaveOneOut: return string("Leave one out"); break;  //
   case tCrossValidation: return string("CrossValidation_fold")+tos(numberOfFolds);break; //
   case tHoldout: return string("Holdout"); break; //
   case tTraining: return string("Training"); break; //
   case tHalfTraining: return string("HalfTraining"); break;
     } //
};

/*_______________________________________________________________________*/

char* TestModeClass::print ()
{
 strcpy(line, "\nTest mode:\t\t\t");
 strcat(line, print(tm).c_str());
 if (tm==tCrossValidation) sprintf (line, "%s fold=%d", line, numberOfFolds);
return line;
};

string TestModeClass::getShortName()
{

	switch(tm){
   		case tLeaveOneOut: return string("L1out"); break;  //
   		case tCrossValidation: return string("Xval")+tos(numberOfFolds);break; //
   		case tHoldout: return string("Holdout"); break; //
   		case tTraining: return string("Training"); break; //
   		case tHalfTraining: return string("HalfTraining"); break;
		default:		
			return "aa";
			break;
	}
}


/*_______________________________________________________________________*/

ostream& operator<<(ostream& out, TestModeClass& p)
{
out << p.print();
return out;
}


};  // Fin del Namespace

#endif

/* Fin Fichero: TestModeClass.h */
