/* File: TestModeClass.h */

#ifndef __TestModeClass_h__
#define __TestModeClass_h__



using namespace std;


namespace BIOS {

enum TestMode{
	tLeaveOneOut=0, // cross validations with as many folds as individuals (patterns) in the sample
	tCrossValidation=1, 
	tHoldout=2, // half of the sample used for training the other for test
	tTraining=3, // the whole sample is used for both training and test
	tHalfTraining=4 // only half of the sample is used for both training and test
	}; 



class TestModeClass {


public:

char line[256];
int numberOfFolds;

TestMode tm;
 	
TestModeClass(TestMode tm, int numberOfFolds=-1);

TestMode getValue();

int getNumberOfFolds();


char* print ();

string getShortName();

string print (TestMode tm);

TestModeClass* clone();

friend ostream& operator<<(ostream& out, TestModeClass& p);
};




};  // Fin del Namespace

#endif

/* Fin Fichero: TestModeClass.h */
