#ifndef __extern_h__
#define __extern_h__

#include <iostream>//
#include <fstream>//                                                    
#include <cstring>//
#include <cstdio>//
#include <cstdlib>//
#include <cmath>//

using namespace std;


namespace BIOS {
/*************************************************************************/// 
/*									 */// 
/*		Global data for C4.5					 */// 
/*		--------------------					 */// 
/*									 */// 
/*************************************************************************/// 
// 
// 
extern  short		MaxAtt,		/* max att number */// 
			MaxClass,	/* max class number */// 
			MaxDiscrVal;	/* max discrete values for any att */// 
// 
extern  ItemNo		MaxItem;	/* max data item number */// 
// 
extern  Description	*Item;		/* data items */// 
// 
extern  DiscrValue	*MaxAttVal;	/* number of values for each att */// 
// 
extern  char		*SpecialStatus;	/* special att treatment */// 
// 
extern  String		*ClassName,	/* class names */// 
		  	*AttName,	/* att names */// 
		  	**AttValName;	/* att value names */// 
			//FileName;	/* family name of files */// 
			
extern char FileName[256];			
// 
extern  Boolean		AllKnown;	/* true if there have been no splits// 
					   on atts with missing values above// 
					   the current position in the tree */// 



extern ItemCount// 
	*Weight,	/* Weight[i]  = current fraction of item i */// 
	**Freq,		/* Freq[x][c] = no. items of class c with outcome x */// 
	*ValFreq,	/* ValFreq[x]   = no. items with outcome x */// 
        *ClassFreq,     /* ClassFreq[c] = no. items of class c *///
        *ContFreq;
// 
extern float// 
	*Gain,		/* Gain[a] = info gain by split on att a */// 
	*Info,		/* Info[a] = potential info of split on att a */// 
	*Bar,		/* Bar[a]  = best threshold for contin att a */// 
        *EmpRisk,
        *UnknownRate;	/* UnknownRate[a] = current unknown rate for att a *///
// 
extern Boolean// 
	*Tested,	/* Tested[a] set if att a has already been tested */// 
	MultiVal;	/* true when all atts have many values */// 
// 
// 
	/*  External variables initialised here  */// 
// 
extern float// 
	*SplitGain,	/* SplitGain[i] = gain with att value of item i as threshold */// 
        *SplitInfo,     /* SplitInfo[i] = potential info ditto */// 
        *SplitEmpRisk; 
//
extern ItemCount// 
	*Slice1,	/* Slice1[c]    = saved values of Freq[x][c] in subset.c */// 
	*Slice2;	/* Slice2[c]    = saved values of Freq[y][c] */// 
// 
extern Setc45// 
	**Subset;	/* Subset[a][s] = subset s for att a */// 
// 
extern short// 
	*Subsets;	/* Subsets[a] = no. subsets for att a */// 

// 
// 
/*************************************************************************/// 
/*									 */// 
/*		Global parameters for C4.5				 */// 
/*		--------------------------				 */// 
/*									 */// 
/*************************************************************************/// 
// 
// 
extern  short		VERBOSITY,	/* verbosity level (0 = none) */// 
			TRIALS;		/* number of trees to be grown */// 
// 
extern  Boolean		GAINRATIO,	/* true=gain ratio, false=gain */// 
			SUBSET,		/* true if subset tests allowed */// 
			BATCH,		/* true if windowing turned off */// 
			UNSEENS,	/* true if to evaluate on test data */// 
			PROBTHRESH;	/* true if to use soft thresholds */// 
// 
extern  ItemNo		MINOBJS,	/* minimum items each side of a cut */// 
			WINDOW,		/* initial window size */// 
			INCREMENT;	/* max window increment each iteration */// 
// 
extern  float		CF;		/* confidence limit for tree pruning */// 

extern void Error(short n, String s1, String s2);

extern int Which(String Val, String List[], short First, short Last);

extern void ResetFreq(DiscrValue MaxVal);


}
#endif

