#ifndef GenericMLTest_h//
#define GenericMLTest_h//



namespace BIOS {


class InputTUI;


////////////////////////////

class GenericMLTest {

/** This class is used as a generalization of any sample (ML Sample, genetic samples, etc.) so that they all can be divided in order to use tests, classifier or any other measure using different testting comfigurations (cross-validation, holdout, training).
*/



protected:


char* fileName;

string timeMark;

bool testModeForInsideMeasure;

int externalNumberOfFolds;

int size, totalAtts;// size is the total number of effective attributes considering the type of sample (eg. genotype samples in makeped format does also include phenotypes and have to be ignored), totalAtts is the total number of attrib. in each file

GenericCounts** genericCountsForTraining, **genericCountsForTest, *wholeCounts;

GenericSample** samplesForTraining, **samplesForTest, *wholeSample;

TestModeClass* testMod;


protected:

virtual int getRealNumberOfAtts(); 

void setSize();

public:

GenericMLTest(char* fileSample, TestModeClass *testMod, int jointRows, bool testModeForInsideMeasure);
~GenericMLTest();
void emptyCounts();
MeasureResults** getResults(ListOfGenericMeasures* measures, Container<vector<ofstream*>,ofstream*>* listOfStreams=NULL); //, int* subRegion, int length);
virtual GenericCounts* getCounts(GenericSample* sample, int*pos, int length)=0;
void setGenericCounts(int*realtivePositions, int length);
void setSubsamples(int iniPos, int length);
int getSize();
char* getFileName();
GenericCounts** getGenericCountsForTraining();
GenericCounts** getGenericCountsForTest();
virtual GenericSample* getSample(char* file, int* pos, int length)=0;
};

} // end namespace
#endif

