#ifndef ProbabilityIntervals_h//
#define ProbabilityIntervals_h//



namespace BIOS 
{




class ProbabilityIntervals: public Container<ProbabilityInterval, ListOfPointers>
{ 
   
public:

//ProbabilityIntervals():Set<ProbabilityInterval, list>(){};
Container<ProbabilityInterval, ListOfPointers>* getMaxEntropy();
Container<ProbabilityInterval, ListOfPointers>* getVertexSet();
void getMaxEntropy(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution, Container<ProbabilityInterval, ListOfPointers> *resultDistribution, intList* positions);
double sumLower(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution);
int minLower(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution, intList* positions);
int totalMin(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution, intList* positions);
int secondMinLower(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution, int pos, intList* positions);
Prob min(Prob a, Prob b, Prob c);
Prob min(Prob a, Prob b);
double getEntropy();
};//

/*______________________________________________________*/
/*
double ProbabilityIntervals::getEntropy()
{
Container<ProbabilityInterval, ListOfPointers>* distr=getMaxEntropy();
Entropy* e=new Entropy();
double ent=e->getMeasure();
zap(e);
zap(distr);
return ent;
}
/*______________________________________________________*/

Prob ProbabilityIntervals::min(Prob a, Prob b, Prob c)
{
if (a<=b && a<=c) return a;
else if (b<=a && b<=c) return b;
else return c;
}

/*______________________________________________________*/

Prob ProbabilityIntervals::min(Prob a, Prob b)
{
if (a<=b) return a;
else return b;
}
/*______________________________________________________*/

double ProbabilityIntervals::sumLower(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution)
{
double result=0;
Container<ProbabilityInterval, ListOfPointers>::NodePointer p=maxEntropyDistribution->GetFirst();
while(p!=NULL)
{
result=result+maxEntropyDistribution->GetElement(p)->getFirst().convert();
p=maxEntropyDistribution->GetNext(p);
}
return result;
}
/*______________________________________________________*/

int ProbabilityIntervals::minLower(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution, intList* positions)
{
double min=1;
int pos=0;
for (int i=0;i<maxEntropyDistribution->GetSize();i++)
if (positions->GetElement(i)!=-1)
if (maxEntropyDistribution->GetElement(i)->getFirst().convert()<=min)
{
pos=i;
min=maxEntropyDistribution->GetElement(i)->getFirst().convert();
}
return pos;
}
/*______________________________________________________*/

int ProbabilityIntervals::secondMinLower(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution, int pos, intList* positions)
{
double min=1;
int pos2=-1;
for (int i=0;i<maxEntropyDistribution->GetSize();i++)
if (positions->GetElement(i)!=-1)
if (i!=pos)
if (maxEntropyDistribution->GetElement(i)->getFirst().convert()<=min)
{
pos2=i;
min=maxEntropyDistribution->GetElement(i)->getFirst().convert();
}
return pos2;
}
/*______________________________________________________*/

int ProbabilityIntervals::totalMin(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution, intList* positions)
{
int pos=minLower(maxEntropyDistribution, positions);
int total=0;
for (int i=0;i<maxEntropyDistribution->GetSize();i++)
if (positions->GetElement(i)!=-1)
if (maxEntropyDistribution->GetElement(i)->getFirst().convert()==maxEntropyDistribution->GetElement(pos)->getFirst().convert())
total++;
return total;
}
/*______________________________________________________*/
Container<ProbabilityInterval, ListOfPointers>* ProbabilityIntervals::getMaxEntropy()
{
Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution=new Container<ProbabilityInterval, ListOfPointers>(*this), *resultDistribution=NULL;
intList* positions=new intList(this->GetSize());
getMaxEntropy(maxEntropyDistribution, resultDistribution, positions);
zap(maxEntropyDistribution);
zap(positions);
return  resultDistribution;
}
/*______________________________________________________*/

void ProbabilityIntervals::getMaxEntropy(Container<ProbabilityInterval, ListOfPointers>* maxEntropyDistribution, Container<ProbabilityInterval, ListOfPointers> *resultDistribution, intList* positions)
{
Prob li, ui, lf, lr, li2;
//intList* positions=new intList(this->GetSize());
zap(resultDistribution);
resultDistribution=new Container<ProbabilityInterval, ListOfPointers>(*maxEntropyDistribution);
double sum=sumLower(maxEntropyDistribution);
if (sum<1)
{
 for (int i=0; i<maxEntropyDistribution->GetSize(); i++)
  if (maxEntropyDistribution->GetElement(i)->getFirst().convert()==maxEntropyDistribution->GetElement(i)->getSecond().convert()) positions->changeElementAtPos(-1, i);

//ProbabilityInterval pi;
int mini=minLower(maxEntropyDistribution, positions), mini2=secondMinLower(maxEntropyDistribution, mini, positions),
totalM=totalMin(maxEntropyDistribution, positions);
lf=maxEntropyDistribution->GetElement(mini2)->getFirst();
lr=maxEntropyDistribution->GetElement(mini)->getFirst();
for (int i=0; i<maxEntropyDistribution->GetSize();i++)
{
 li=maxEntropyDistribution->GetElement(i)->getFirst();
 ui=maxEntropyDistribution->GetElement(i)->getSecond();
if (i==mini)
{
 if (mini2==-1) 
 li2=min(ui-li, Prob(1-sum, totalM));
 else if (lf==lr) li2=min(ui-li,Prob(1-sum,totalM)); else li2=min(ui-li,lf-lr,Prob(1-sum,totalM));
 ProbabilityInterval* pi=new ProbabilityInterval(Prob(li+li2), ui);
 maxEntropyDistribution->removeNode(i); 
 maxEntropyDistribution->insertElementAtPos(pi,i); 
}
}
//cout << *maxEntropyDistribution;
getMaxEntropy(maxEntropyDistribution, resultDistribution, positions);
}
}


/*______________________________________________________*/
/*
template<class T> ostream& operator<<(ostream& out, BayesScore<T>& lista)
{
 
//out << *lista.sample;

return out;
  }
*/
} // end namespace

#endif
