/* File: Attribute.cpp */


#ifndef __Attribute_cpp__
#define __Attribute_cpp__


#include "Attribute.h"


namespace BIOS
{



  /************************/
  /* Attribute DEFINITION */
  /************************/


  /**
          @memo Attribute for SNPs
   
  	@doc
     
   
      @author Maria M. Abad Grau
  	@version 1.0
  */

  /*********************************************************************/
  /***     ASSOCIATED FUNCTIONS     ***/
  /*********************************************************************/

  void Attribute::set(string name, stringList* modalidades, distanceType tipo_distancia, unsigned int selected, floatList * puntos)
  {
    attribute.name=name;
	if (&modalidades!=NULL)
	{
    zap (attribute.modalidades);
    attribute.modalidades=new Modalidades(*modalidades);
	}
	else attribute.modalidades=NULL;
    attribute.tipo_distancia=tipo_distancia;
    attribute.selected=selected;
	if (&puntos!=NULL)
	{
	zap (attribute.puntos);
    attribute.puntos=new Valores(*puntos);
	}
	else attribute.puntos=NULL;


  };
  /*________________________________________________________________________*/

  Attribute::Attribute(string name, stringList* modalidades, distanceType tipo_distancia, unsigned int selected, VerbosityClass verbosity, floatList *puntos)
  {
    //Attribute();


this->verbosity=verbosity;
    set(name, modalidades, tipo_distancia, selected, puntos);
   //   if (verbosity->GetFirstElement()>=1)
   //   cout << this;

  }
  /*________________________________________________________________________*/

  Attribute::Attribute()
  {
    set();
  }

  /*________________________________________________________________________*/

   bool Attribute::operator==(Attribute & e)//{cout <<"Attribute::operator== Not implemented"; exit(0);};
{
  return e.GetName()==GetName();
}
  /*________________________________________________________________________*/

  void Attribute::set()
  {
    attribute.modalidades=NULL;
    attribute.tipo_distancia=categorical;
    attribute.puntos=NULL;
    attribute.selected=true;
this->verbosity=VerbosityClass();
  //if (verbosity->GetFirstElement()>=1)
    //  cout <<"\n Attribute: " << this;

   }
  /*________________________________________________________________________*/
/*
  string Attribute::print()
  {
   char  line[3000];

 
    sprintf(line, "Att: %s", attribute.name.c_str());
    
 if (attribute.selected==true)
{
    switch (attribute.tipo_distancia)
    {
    case categorical: sprintf(line, "%s, type: categorical", line); break;
    case ordinal: sprintf(line, "%s, type: ordinal", line); break;
    case continuous: sprintf(line, "%s, type: continuous", line); break;
    case discretized: sprintf(line, "%s, type: discretized", line); break;
    }
	//return string(line);
	
	if (isContinuous())
	{
	if (attribute.puntos!=NULL) sprintf(line, "%s, cut points: %s", line, *attribute.puntos->print().c_str());
	}
	else 
{
	if (attribute.modalidades!=NULL)
	sprintf(line, "%s, values: %s", line, attribute.modalidades->print().c_str());
	}
	 
}
else    sprintf(line, "%s not selected", line);
    
  return string(line);
   
  }

  

  /*________________________________________________________________________*/

  Attribute::Attribute(Attribute & Source)
  {
    set();
    *this=Source;

  }

  /*________________________________________________________________________*/

  Attribute::~Attribute()
  {
    zap(attribute.modalidades);
    zap(attribute.puntos); //else cout <<"P";
   };

  /*_____________________________________________________________________________*/
/*
  int Attribute::getOrderedValue(float value)
  {
    if (attribute.tipo_distancia!=1) //
    {
      cout <<"not an ordered attribute in Attribute::getOrderedValue";
      exit(0);
    }
    else return atoi(attribute.modalidades->GetElement((int) value).c_str());

  }
  */
  /*________________________________________________________________________*/

  float Attribute::GetPureValue(float valor)
  {
    // returned value can be a float for continuous attributes
   // if is missing, return maxreal for no discretized or the number of dimensions otherwise
    switch (attribute.tipo_distancia)
    {
    case categorical:
    case ordinal: return valor; break;
    case continuous: return valor; break;
    case discretized: // continuous discretized
    try{  if (attribute.puntos==NULL) throw NullValue();}
      catch (NullValue nv)
      {
        nv.PrintMessage(" Attribute::GetValue. Attribute is continuous but there are not intervals");
      };
	  if (valor==maxreal) return GetTotalModalidades();
      floatList::NodePointer p=attribute.puntos->GetFirst();
      float posicion=0;
      while (p!=NULL)
      {
        if (valor < attribute.puntos->GetElement(p))
          return posicion;
        p=attribute.puntos->GetNext(p);
        posicion=posicion+1;
      }
      return posicion;
    }
  }
 /*________________________________________________________________________*/

  float Attribute::GetPureValue(string valor)
  {
    // returned value can be a float for continuous attributes
   // if is missing, return maxreal for no discretized or the number of dimensions otherwise
   float v;
    switch (attribute.tipo_distancia)
    {
    case categorical:
    case ordinal: return GetPosition(valor); break;
    case continuous: return atof(valor.c_str()); break;
    case discretized: // continuous discretized
    try{  if (attribute.puntos==NULL) throw NullValue();}
      catch (NullValue nv)
      {
        nv.PrintMessage(" Attribute::GetValue. Attribute is continuous but there are not intervals");
      };
	  if (valor=="?") return GetTotalModalidades();
	  v=atof(valor.c_str());
      floatList::NodePointer p=attribute.puntos->GetFirst();
      float posicion=0;
      while (p!=NULL)
      {
        if (v < attribute.puntos->GetElement(p))
          return posicion;
        p=attribute.puntos->GetNext(p);
        posicion=posicion+1;
      }
      return posicion;
    }
  }
  /*________________________________________________________________________*/

  float Attribute::GetValue(float valor)
  {
    // returned value can be a float for continuous attributes
    // if missing, error
    float value=GetPureValue(valor);
    try
    {
      switch (attribute.tipo_distancia)
      {
      case categorical:
      case ordinal: 
      case discretized: if ((int)value==GetTotalModalidades()) throw MissingValue();return value; break;
      case continuous: if (value==maxreal) throw MissingValue(); return value; break;
     }
     }
    catch (MissingValue mv)
    {
      mv.PrintMessage(" Attribute::GetValue. Missing value", -1, GetName());
    }
   
  //  return value;
  }
  /*________________________________________________________________________*/

  bool Attribute::isMissing(float valor)
  {
   float value=GetPureValue(valor);

   switch (attribute.tipo_distancia)
      {
      case categorical:
      case ordinal: 
      case discretized: if (value==GetTotalModalidades()) return true; else return false; break;
      case continuous: if (value==maxreal) return true; else return false; break;
     }
  };
  /*________________________________________________________________________*/

  float Attribute::GetLowerBound(float valor)
  {
    if (attribute.tipo_distancia==2)
    {
      cout <<"Error, attribute is continuous, in Attribute::GetLowerBound";
      exit(0);
    }

    float val=GetValue(valor);
    if (attribute.tipo_distancia<2)// return 0;//val;
      return(val);

    else // continuous discretized
      if (val==0) return -maxreal; // first interval
    return attribute.puntos->GetElement((int)val-1);
  }
  /*________________________________________________________________________*/

  float Attribute::GetUpperBound(float valor)
  {
    if (attribute.tipo_distancia==2)
    {
      cout <<"Error, attribute is continuous, in Attribute::GetLowerBound"; exit(0);
    }

    //    return 0;
    float val=GetValue(valor);
    if (attribute.tipo_distancia<2) return val;
    else
      if (val==(GetTotalIntervals()-1)) return maxreal; // last interval
      else return attribute.puntos->GetElement((int)val);
  }

  /*________________________________________________________________________*/

  string Attribute::GetStringValue(float valor)
  {
    char stringValue[10];
    string sv;
    if (GetTipoDistancia()!=continuous)
    {
      if (GetTotalModalidades()==(int)valor)
        strcpy(stringValue, "?");
      else sprintf(stringValue, "%d", (int)valor);
    }
    else // continuous
    {
      if (maxreal==valor)
        strcpy(stringValue, "?");
      else sprintf(stringValue, "%0.4f", valor);
    }
	sv=string(stringValue);
    return sv;
  }
  /*________________________________________________________________________*/

  distanceType Attribute::GetTipoDistancia()
  {
    return attribute.tipo_distancia;
  }
  /*________________________________________________________________________*/

  void Attribute::setDistanceType(distanceType tipo_distancia)
  {
    attribute.tipo_distancia=tipo_distancia;
  }
  /*________________________________________________________________________*/

  void Attribute::SetIntervals(Valores* values)
  {
    if (values!=NULL) 
{
attribute.puntos=new Valores(*values);
 attribute.tipo_distancia=discretized;

}
    else removeIntervals();
    
  
  }
  /*________________________________________________________________________*/

  void Attribute::removeIntervals()
  {
  if (attribute.tipo_distancia==discretized)
     attribute.tipo_distancia=continuous;
  
      zap (attribute.puntos);
   
   
  }
  /*________________________________________________________________________*/

  void Attribute::removeSelection()
  {
    attribute.selected=false;

  }
  /*________________________________________________________________________*/

  void Attribute::select()
  {
    attribute.selected=true;

  }
  /*________________________________________________________________________*/

  void Attribute::SetModalidades(Modalidades* modalidades)
  {
	  zap (attribute.modalidades);
    if (modalidades==NULL) attribute.modalidades=NULL;

    else attribute.modalidades=new Modalidades(*modalidades);
  }
  /*________________________________________________________________________*/

  void Attribute::SetName(string name)
  {
      attribute.name=name;
  }

  /*________________________________________________________________________*/

  bool Attribute::isDiscretized()
  {
    return attribute.tipo_distancia==discretized;
  }


  /*________________________________________________________________________*/

  string Attribute::GetName()
  {
    return attribute.name;
  }
  /*______________________________________________________________*/

  bool Attribute::IsTheClass()
  {
    if (attribute.name== "class") return true; else return false;
  }
  /*______________________________________________________________*/

  int Attribute::GetTotalModalidades()
  {
    if (attribute.tipo_distancia==categorical || attribute.tipo_distancia==ordinal)
      return attribute.modalidades->GetSize();
    else if (attribute.tipo_distancia==discretized)
      return attribute.puntos->GetSize()+1;
  else return 0;
  }
  /*______________________________________________________________*/

  int Attribute::GetTotalIntervals()
  {
    if (attribute.tipo_distancia!=discretized || attribute.puntos==NULL) return 0;
      else return attribute.puntos->GetSize()+1;
  //  else return 0;
  }
  /*______________________________________________________________*/

  Modalidades* Attribute::GetModalidades()
  {
       return attribute.modalidades;
   }

  /*______________________________________________________________*/

  Valores* Attribute::GetIntervals()
  {
    return attribute.puntos;
  }

 /*______________________________________________________________*/
/*
  string Attribute::getNonMissingOriginalDiscreteValue(float value)
  {
 switch (attribute.tipo_distancia)
    {
    case categorical:
    case ordinal: return attribute.modalidades->GetElement((int)value); break;
    case continuous: 
    case discretized: // continuous discretized
  return tos(value); break;
}
}
 /*______________________________________________________________*/
/*
  string Attribute::getNonMissingOriginalDiscreteValue(int value)
  {
 switch (attribute.tipo_distancia)
    {
    case categorical:
    case ordinal: return attribute.modalidades->GetElement(value); break;
    case continuous: 
    case discretized: // continuous discretized
  return tos(value); break;
}
}
  /*______________________________________________________________*/

  int Attribute::GetPosition(string cadena)
  {
    unsigned int  posicion=0;
    stringList::NodePointer p=attribute.modalidades->GetFirst();
    while (p!=NULL)
    {
      if (cadena.compare(attribute.modalidades->GetElement(p))==0)
        return posicion;
      posicion=posicion+1;
      p=attribute.modalidades->GetNext(p);
    }
    if (cadena.compare(string("?"))!=0)
    {
    cout <<"Error in att " << GetName() << ". Value " << cadena <<" has not been refered in its domain.";
    end();
    }
    return (posicion); // missing (=?) returns totalModalidades
  }


  /*____________________________________________________________ */

  Attribute& Attribute::operator=(Attribute & Source)
  {
    //   

//cout <<"LLL:";
//exit(0);
    if (&Source!=NULL)
    {

      if (this!=&Source)
      {
      //  attribute.puntos=new Valores(*Source.GetIntervals());

        this->SetName(Source.attribute.name);
        this->SetModalidades(Source.attribute.modalidades);
	//	cout <<this->attribute.modalidades->print();
    //        exit(0);
        this->setDistanceType(Source.attribute.tipo_distancia);
        this->SetIntervals(Source.attribute.puntos);
        this->attribute.selected=Source.attribute.selected;
        this->verbosity=Source.verbosity;
      }
      //   exit(0);
   	return *this;
 }

  }

  /*____________________________________________________________ */


  bool Attribute::isSelected()
  {
    return attribute.selected;
  }
  
  
   /*___________________________________________________________ */

template <class T> float Attribute::getDistance(T  e1, T e2, NumericalAttributeDistanceMethod numericalAttributeDistanceMethod, bool useMissing, int e1Class, int e2Class, CPT* const probs)
{

float distance=0;
float range=1;
int pos, pos2;

	if (!isMissing(e1))
	if (!isMissing(e2))

     
{
        if (GetTipoDistancia()==ordinal)
        if (numericalAttributeDistanceMethod==normalizedAbsoluteDifference)
   	range=GetPureValue(attribute.modalidades->GetLastElement())-GetPureValue(attribute.modalidades->GetFirstElement()); 

	switch (GetTipoDistancia())
	{
	case categorical: return 1-(e1==e2); break;
	default: 
	switch (numericalAttributeDistanceMethod)
	{
	case absoluteDifference: return fabs(e1-e2); break;
        case normalizedAbsoluteDifference: fabs(e1-e2)/range; break;
	case squareDifference: return std::pow((float)(e1-e2), 2); break;
        }
	}
}
if (!useMissing) return 0;
else // used in ReliefF
{
try
{
int totalClasses=probs->getMarginals()->getSize();
int totalMods=probs->getConditionals()->getSize()/totalClasses;

if (isMissing(e1) && isMissing(e2))
{
for (int i=0; i < totalMods; i++)
{
pos=totalClasses*i+e1Class;
pos2=totalClasses*i+e2Class;
distance=distance+(float)probs->getValue(pos).convert()*(float)probs->getValue(pos2).convert();
return 1-distance;
}
if (isMissing(e1)) pos=totalClasses*(int)GetPureValue(e2)+e1Class;
if (isMissing(e2)) pos=totalClasses*(int)GetPureValue(e1)+e2Class;
return 1-(float)probs->getValue(pos).convert();

}
}
catch (NonProb np){np.PrintMessage(" Atttribute::getDistance");};
}


};
   
  
}
;  // Fin del Namespace

#endif

/* Fin Fichero: Attribute.cpp */
