/* File: Attribute.h */


#ifndef __Attribute_h__
#define __Attribute_h__

//#include <string>
#include "../../../commonc++/list.h"

//using namespace UTILS;


namespace BIOS {

class CPT;
 
/************************/
/* Attribute DEFINITION */
/************************/


/**
        @memo Attribute for SNPs

	@doc
   

    @author Maria M. Abad
	@version 1.0
*/

typedef stringList Modalidades;
typedef floatList Valores;


  typedef enum distanceType {
    categorical=0,
    ordinal=1,
    continuous=2,
    discretized=3
    };


class Attribute   {

 public:
    /** @name Implementation of class Attribute
        @memo Private part.
    */
typedef struct atributo 
{ //
string name; //
Modalidades *modalidades; //
distanceType tipo_distancia; // 0: categorical, 1: ordinal, 2: continuous, 3: continuous discretized
bool selected;
Valores *puntos; // if 0, it contains 1 to the total number of categories; if continuous, it contain discretization intervals
}; 


VerbosityClass verbosity;

atributo attribute;

 void set(string name, stringList* modalidades, distanceType tipo_distancia, unsigned int selected, floatList *puntos);
 
void set();

public:

  string getNonMissingOriginalDiscreteValue(float value);
//  string getNonMissingOriginalDiscreteValue(int value);

  float GetPureValue(float valor);
  float GetPureValue(string valor);

  Attribute(string name,  stringList* modalidades, distanceType tipo_distancia, unsigned int selected, VerbosityClass verbosity,  floatList *puntos);

void SetAttribute(Attribute *attribute);

Attribute(); 

Attribute(Attribute & Source); 

~Attribute(); 

Modalidades* GetModalidades();

float GetValue(float valor); 

bool isMissing(float valor); 

float GetLowerBound(float valor); 

float GetUpperBound(float valor); 

bool IsTheClass();

int GetTotalModalidades();

int GetTotalIntervals();

distanceType GetTipoDistancia(); 

 
 inline bool isContinuous() {return attribute.tipo_distancia==discretized || attribute.tipo_distancia==continuous; }

bool isDiscretized(); 

string GetName();

string GetStringValue(float valor); 

void SetModalidades(Modalidades* modalidades);

int GetPosition(string cadena);

void setDistanceType(distanceType tipo_distancia);

void SetIntervals(Valores* values); 


void removeIntervals();

Valores* GetIntervals(); 

void SetName(string name); 

Attribute& operator=(Attribute & Source);

virtual bool operator>(Attribute & e){cout <<"Attribute::operator> Not implemented"; exit(0);};

virtual bool operator<(Attribute & e){cout <<"Attribute::operator< Not implemented"; exit(0);};

virtual bool operator==(Attribute & e);//{cout <<"Attribute::operator== Not implemented"; exit(0);};

virtual bool operator!=(const Attribute & e){cout <<"Attribute::operator!= Not implemented"; exit(0);};

void select();

void removeSelection();

bool isSelected();

//string print();

int getOrderedValue(float value);

template<class T> float getDistance(T  e1, T e2, NumericalAttributeDistanceMethod numericalAttributeDistanceMethod, bool useMissing=false, int e1Class=-1, int e2Class=-1, CPT* const probs=NULL);


int GetSize()
{
cout <<"no sense";
return 0;
}

//template <> Attribute list<Attribute>::ReadElement (ifstream * is, int size){};
};
/*______________________________________________________*/

  ostream& operator<<(ostream& out, Attribute& att)
  {
   
        out << "Att: " << att.attribute.name;
    
 if (att.attribute.selected==true)
{
    switch (att.attribute.tipo_distancia)
    {
    case categorical: out <<", type: categorical"; break;
    case ordinal: out <<", type: ordinal"; break;
    case continuous: out << ", type: continuous"; break;
    case discretized: out << ", type: discretized"; break;
    }
	//return string(line);
	
	if (att.isContinuous())
	{
	if (att.attribute.puntos!=NULL) out << ", cut points:  " << *att.attribute.puntos;
	}
	else 
{
	if (att.attribute.modalidades!=NULL)
	out <<", values: " << *(att.attribute.modalidades);
	}
	 
}
else    out << " not selected";
    
       return out;
  }
};  // Fin del Namespace

#endif

//#include "Attribute.cpp"

/* Fin Fichero: Attribute.h */


/* Fin Fichero: Attribute.h */
