/* File: ListOfAttributes.cpp */


#ifndef __ListOfAttributes_cpp__
#define __ListOfAttributes_cpp__



#include "ListOfAttributes.h"


//using namespace UTILS;


namespace BIOS
{



  /**********************************/
  /* DEFINITIONS OF THE FUNCTIONS */
  /**********************************/

ListOfAttributes* ListOfAttributes::clone()
{
return new ListOfAttributes(*this);
}
 /*___________________________________________________________*/

string ListOfAttributes::getName()
{
return string("ListOfAttributes");
}
 /*___________________________________________________________*/

 ListOfAttributes::ListOfAttributes():Set<Attribute, ListOfPointers>()
  {
this->verbosity=VerbosityClass();
  };
  /*___________________________________________________________*/

  ListOfAttributes::ListOfAttributes(ListOfAttributes & listOfAttributes, VerbosityClass verbosity):Set<Attribute, ListOfPointers>(listOfAttributes)
  {
this->verbosity=VerbosityClass();//listOfAttributes.verbosity;
};

   /*___________________________________________________________*/
 
  unsigned int ListOfAttributes::GetTotalAttributes()
  {
    return GetSize();
  }
  
    /*___________________________________________________________*/

  void ListOfAttributes::setDistance(Attribute* attribute, char* buffer)
  {
    char* cad;
  
   if ((cad = strtok (buffer, " "))==NULL) throw BadFormat(); // name
   int distance=atoi(cad);
    
    switch (distance)
    {
    case 0: attribute->setDistanceType(categorical); break;
    case 1: attribute->setDistanceType(ordinal); break;
    case 2: attribute->setDistanceType(continuous); break;
    default:
      {
        cout <<"Error in .mas file (ListOfAttributes::setDistance), distance in " << buffer <<" is " << distance;
        exit(0);
      }
    }

  }
  /*___________________________________________________________*/

  void ListOfAttributes::setName(Attribute* attribute, char* buffer)
  {
     char* cad;
     if ((cad = strtok (NULL, ":"))==NULL) throw BadFormat(); // name
     attribute->SetName(cad);
    }
  /*___________________________________________________________*/

  void ListOfAttributes::setModalidades(Attribute* attribute, char* buffer)
  {
    char *cad;
    Modalidades* modalidades=new stringList();
     if (!attribute->isContinuous())
    {
      modalidades=new stringList();
      if ((cad = strtok (NULL, ", "))==NULL) 
        throw BadFormat();
      while (cad[0]!='.' && cad[0]!='/' && cad[0]!='\n')
      {
        modalidades->insertElement(string(cad));
        cad = strtok (NULL, ", \n");
      };
      attribute->SetModalidades(modalidades);

      zap(modalidades); 

    }
    else attribute->SetModalidades(NULL);

  }
  /*___________________________________________________________*/

  void ListOfAttributes::ReadAttributes(char* fileMas)
  {
try{
   
    char *cad=NULL, *buffer=NULL;
    ifstream  is;
    Attribute* attribute=NULL;
    int distance;
    int total_attribs=GetTotalLines(fileMas);

    OpenInput(fileMas, &is);
    for (int i=0;i<total_attribs;i++)
    {
        buffer=CaptureLine(&is);
        attribute=new Attribute();
         setDistance(attribute, buffer);
         setName(attribute, buffer);
         setModalidades(attribute, buffer);
         insertElement(attribute);
 if (verbosity.verbosityR.attributeDescription)
      cout <<"\n " << *attribute;

      zap(attribute);
          zaparr(buffer);

    } // end for//
    is.close();
 if (verbosity.verbosityR.attributeDescription)
      cout <<"\n ";

 }
catch (ErrorFile eF)
{
   eF.PrintMessage(fileMas, " ListOfAttributes::ReadAttributes");
}
catch (BadFormat bF)
{
   bF.PrintMessage(fileMas, " ListOfAttributes::ReadAttributes");
}
}
  /*___________________________________________________________ */

  ListOfAttributes::ListOfAttributes(char* texto, VerbosityClass verbosity, int metadata):Set<Attribute, ListOfPointers>()
  {

this->verbosity=verbosity;
   // hasID=false;
    char fileFormat[256];
    strcpy(fileFormat, texto);
    char ext[4];
    strcpy(ext, "mas\0");

    ChangeExtension (texto, fileFormat, ext);
    if (existFile(fileFormat) && metadata<2)
    this->ReadAttributes(fileFormat);
   else 
    {
  if (existFile(fileFormat))
 //   if (metadata==2 || (metadata==1 && !existFile(fileFormat)))
{
readAttributesFromData(texto);
     CrearFicheroMas (fileFormat);
}
else
{
cout <<"Error, file " << fileFormat << " does not exist";
end();
}
 }

//readPositions(texto);
  }


   /*___________________________________________________________ */

  void ListOfAttributes::readAttributesFromData(char* texto)
  {
  
  TextFile* textFile=new TextFile(texto);
  int totalRows=textFile->getTotalLines();
  stringList* pattern;
  Attribute* attribute;
  string value;
  for (int i=0;i<totalRows;i++)
  {
  pattern=textFile->readLine();
  if (i==0)
  for (int j=0;j<pattern->GetSize();j++)
  {
    attribute=new Attribute();
    if (isAFloat(pattern->GetElement(j).c_str())) 
    attribute->setDistanceType(continuous);
    else  attribute->setDistanceType(ordinal);
    insertElement(attribute);
    }
  for (int j=0;j<pattern->GetSize();j++)
  {
   attribute=GetElement(i);
   value=pattern->GetElement(j);
   if (!attribute->isContinuous()) 
   if (attribute->GetModalidades()->findElement(value)==NULL)
    attribute->GetModalidades()->insertElement(value);
  }
  }
  }
 
  /*___________________________________________________________ */

  ListOfAttributes::~ListOfAttributes()
  {
    };
  /*___________________________________________________________ */

  template<class T> float ListOfAttributes::getDistance(Container<T, list> * pattern1, Container<T, list> * pattern2, bool noclass, DistanceMethodClass distanceMethodClass, int classPosition)
  {

    if (GetSize()!=(pattern1->GetSize()+noclass)) {cout <<"error 1 in ListOfAttributes::getDistance", exit(0);};
    if (pattern1->GetSize()!=pattern2->GetSize()) {cout <<"error 2 in ListOfAttributes::getDistance", exit(0);};


    NodePointer p=GetFirst();
    
    typename Container<T, list>::NodePointer p1=pattern1->GetFirst(), p2=pattern2->GetFirst();
    Attribute *attribute;
    float e1, e2, distance=0;
int pos=0;
    while (p1!=NULL)
    {
      if (noclass && classPosition==pos) this->GetNext(p);
      
      attribute=this->GetElement(p);

      if (attribute->isSelected())
      {
     
        //if ( this->getTotalSelectedAttributes()>1)
        // cout << "\nsssssss:" << this->getTotalSelectedAttributes();

        if (!attribute->isMissing(pattern1->GetElement(p1)))
          if (!attribute->isMissing(pattern2->GetElement(p2)))
{
   e1=attribute->GetValue(pattern1->GetElement(p1));
        e2=attribute->GetValue(pattern2->GetElement(p2));

	distance=distance+attribute->getDistance(e1, e2, distanceMethodClass.numericalAttributeDistanceMethod, pos, classPosition);
            
}
      }
      p=GetNext(p);
      p1=pattern1->GetNext(p1);
      p2=pattern2->GetNext(p2);
pos++;
    }
  if (distanceMethodClass.distanceMethod==SqRoot) return sqrt(distance);
  else  return distance;  //  return (-1);

  };
   /*___________________________________________________________ */

  template <class T> bool ListOfAttributes::isMissing(list<T>* l) throw (BadSize)
  {
//try{

if (l->GetSize()!=GetSize()) throw BadSize("ListOfAttributes::isMissing", l->GetSize(), GetSize());
typename list<T>::NodePointer pL=l->GetFirst();
    NodePointer p=GetFirst();
 bool missing=false;
    while (p!=NULL)
    {
     if (GetElement(p)->isMissing((float)l->GetElement(pL))) return true;
     // GetElement(p)->removeSelection();
      p=GetNext(p);
pL=l->GetNext(pL);
    }
//}
//catch (BadSize bs) {bs.PrintMessage("ListOfAttributes::isMissing", l->GetSize(), GetSize()); };
return false;
  }
     /*___________________________________________________________ */

  void ListOfAttributes::removeSelection()
  {
    NodePointer p=GetFirst();
    while (p!=NULL)
    {
      GetElement(p)->removeSelection();
      p=GetNext(p);
    }
  }
  /*___________________________________________________________ */

  bool ListOfAttributes::allSelected()
  {
    NodePointer p=GetFirst();
    while (p!=NULL)
    {
      if (GetElement(p)->isSelected()==false) return false;
      p=GetNext(p);
    }
    return true;
  }
  /*___________________________________________________________ */

  unsigned int ListOfAttributes::getTotalSelectedAttributes()
  {
    int t=0;
    NodePointer p=GetFirst();
    while (p!=NULL)
    {
      if (GetElement(p)->isSelected()==true) t++;
      p=GetNext(p);
    }
    return t;
  }
  /*___________________________________________________________ */

  bool ListOfAttributes::isDiscretized()
  {
    NodePointer p=GetFirst();
    Attribute* a;
    while (p!=NULL)
    {
      a=GetElement(p);
      if (a->isContinuous() && !a->isDiscretized())
{
//cout <<"\natt " << a <<" is cont";
        return false;
}
      p=GetNext(p);
    }
    return true;
  }
  /*___________________________________________________________ */

  bool ListOfAttributes::isContinuous()
  {
    NodePointer p=GetFirst();
    Attribute* a;
    while (p!=NULL)
    {
      a=GetElement(p);
      if (a->isContinuous())
        return true;
      p=GetNext(p);
    }
    return false;
  }
  /*___________________________________________________________ */

  intList* ListOfAttributes::getDiscretePositions(floatList* attPattern)
  {
//cout <<*this;
  intList* positions=new intList();
     try
    {
      floatList::NodePointer pP=attPattern->GetFirst();
      NodePointer p=GetFirst();
      while (pP!=NULL && p!=NULL)//pP!=NULL &&
      {
 if (this->GetElement(p)->isContinuous() &&  !this->GetElement(p)->isDiscretized()) throw BadFormat();
//cout << attPattern->GetElement(pP);
            positions->insertElement((int)GetElement(p)->GetPureValue(attPattern->GetElement(pP)));
pP=attPattern->GetNext(pP);
p=GetNext(p);
      }
     }
      catch (BadFormat bf)
    {
      bf.PrintMessage("in ListOfAttributes::getDiscretePositions, attributes must be first discretized");
    }
   return positions;
  }
  
  /*___________________________________________________________ */

  intList* ListOfAttributes::getDiscretePositions(stringList* attPattern)
  {
   
    try
    {
      if (!this->isDiscretized()) throw BadFormat();
      floatList* fPositions=getPositions(attPattern);
      intList* positions=getDiscretePositions(fPositions);
      zap(fPositions);  
      return positions;
     }
      catch (BadFormat bf)
    {
      bf.PrintMessage("in ListOfAttributes::getDiscretePositions, attributes must be first discretized");
    }
  }
 
 /*___________________________________________________________ */

template<class T>  stringList* ListOfAttributes::getStringPattern(list<T>* attPattern)
  {
string nul= "?";
stringList *result=new stringList();
    NodePointer pL=GetFirst();
    typename list<T>::NodePointer p=attPattern->GetFirst();
while (p!=NULL && pL!=NULL)
{
  if (GetElement(pL)->isMissing(attPattern->GetElement(p)))
  result->insertElement(nul);
 else result->insertElement(tos(attPattern->GetElement(p)));
p=attPattern->GetNext(p);
pL=GetNext(pL);
}

      return result;
     }
    
 
  /*___________________________________________________________ */

  floatList* ListOfAttributes::getPositions(stringList* attPattern)
  {
 
    try
    {
       floatList* positions=new floatList();

      Attribute * attribute;
      float value;
      stringList::NodePointer pP=attPattern->GetFirst();
      NodePointer p=this->GetFirst();

      if (attPattern->GetSize()!=GetSize())
        throw BadSize();
      while (p!=NULL && pP!=NULL)
      {
        attribute=this->GetElement(p);
	value=attribute->GetPureValue(attPattern->GetElement(pP));
        positions->insertElement(value);
        p=GetNext(p);
        pP=attPattern->GetNext(pP);
      }
         return positions;
    }
    catch (BadSize nv)
    {
      nv.PrintMessage(" ListOfAttributes::getPositions", GetSize(), attPattern->GetSize());
    }
 
  }
  /*___________________________________________________________ */

  void ListOfAttributes::selectAll()
  {
    NodePointer p=GetFirst();
    while (p!=NULL)
    {
      GetElement(p)->select();
      p=GetNext(p);
    }
  }
  /*___________________________________________________________ */
  // select attributes at attList
  void ListOfAttributes::select(intList* attList)
  {
    removeSelection();
    intList::NodePointer p=attList->GetFirst();
    while (p!=NULL)
    {
      GetElement(attList->GetElement(p))->select();
      p=attList->GetNext(p);
    }
  }
 /*___________________________________________________________ */
  // get a list of selected attributes
  intList* ListOfAttributes::getSelection()
  {
 intList* selectedAtts=new intList();
  for (int i=0;i<GetSize();i++)
  if (GetElement(i)->isSelected()) selectedAtts->insertElement(i);
return selectedAtts;
}
   /*___________________________________________________________ */
   
   ListOfAttributes* ListOfAttributes::select()
  {
  ListOfAttributes* newList=new ListOfAttributes();

     ListOfAttributes::NodePointer p=GetFirst();

    while (p!=NULL)
    {
      if (GetElement(p)->isSelected()) newList->insertElement(GetElement(p));
      p=GetNext(p);
    }
    return newList;
  }
  /*___________________________________________________________ */
  // select attributes at attList
  bool* ListOfAttributes::getSelected()
  {
    bool* selected=new bool[GetTotalAttributes()];
    NodePointer p=GetFirst();
    int i=0;
    while (p!=NULL)
    {
      if (GetElement(p)->isSelected())
        selected[i]=true;
      else selected[i]=false;
      p=GetNext(p);
      i++;
    }
    return selected;
  }
  /*___________________________________________________________ */
  // select attributes at attList
  bool* ListOfAttributes::getDiscrete()
  {
    bool* discrete=new bool[GetTotalAttributes()];
    NodePointer p=GetFirst();
    int i=0;
    while (p!=NULL)
    {
      if (GetElement(p)->isContinuous())
        discrete[i]=false;
      else discrete[i]=true;
      p=GetNext(p);
      i++;
    }
    return discrete;
  }
  /*___________________________________________________________ */
  // select attributes at attList
  /*
  void ListOfAttributes::select(floatMLSample* sample, SelMode selMode)
  {

    if (selMode!=Todos)
  {
    Selection* selection=new Selection(sample, this, selMode);
    zap (selection);

  }
  else 

  selectAll();

   }
 /*___________________________________________________________ */

  void ListOfAttributes::GetDiscreteListOfAttributes(ListOfAttributes* listOfDiscreteAttributes)
  {
unsigned int i=0;
    NodePointer p=GetFirst();
    Attribute *attribute, *sourceAttribute;
    stringList* modalidades;
    char val[256];
    while (p!=NULL)
    {
      sourceAttribute=this->GetElement(p);
      attribute=new Attribute(*sourceAttribute);
      if (sourceAttribute->isContinuous())
if (!sourceAttribute->isDiscretized()) throw NonDiscrete("ListOfAttributes::GetDiscreteListOfAttributes()");
else
      {
        modalidades=new stringList();
//cout <<"TOTITNS:" << attribute->GetTotalIntervals();
        for (int i=0;i<attribute->GetTotalIntervals();i++)
{
sprintf(val, "%d", i);
         modalidades->insertElement(string(val));
}
        attribute->setDistanceType(ordinal);// ordered
        attribute->SetModalidades(modalidades);
attribute->removeIntervals();
        zap(modalidades);
      

      }
      listOfDiscreteAttributes->insertElement(attribute);
      zap(attribute);
      p=GetNext(p);
    }
 }
  /*___________________________________________________________ */

  int ListOfAttributes::getTotalModalidades(int att)
  {
return GetElement(att)->GetTotalModalidades();
  }
  /*___________________________________________________________ */

  ListOfAttributes* ListOfAttributes::GetDiscreteListOfAttributes()
  {
    ListOfAttributes* listOfDiscreteAttributes;
    listOfDiscreteAttributes=new ListOfAttributes();
GetDiscreteListOfAttributes(listOfDiscreteAttributes);
return listOfDiscreteAttributes;
  }
  /*___________________________________________________________ */

  void ListOfAttributes::removeIntervals()
  {
    NodePointer p=GetFirst();
    while (p!=NULL)
    {
      if (GetElement(p)->isContinuous())
        GetElement(p)->removeIntervals();
      p=GetNext(p);
    }
  }
  /*___________________________________________________________ */

  intList* ListOfAttributes::getDimensionList(intList* varList)
  {
   intList::NodePointer p=varList->GetFirst();
    intList* dimensionList=new intList();
    Attribute *attribute;
    while (p!=NULL)
    {
      attribute=GetElement(varList->GetElement(p));
if (attribute->isContinuous() && attribute->GetTipoDistancia()!=discretized) throw NonDiscrete("ListOfAttributes::getDimensionList");
      dimensionList->insertElement(attribute->GetTotalModalidades());
      if (attribute->GetTotalModalidades()<=1)
      {
        cout <<"Error in ListOfAttributes::getDimensionList, att " << attribute->GetName() << " has only " << attribute->GetTotalModalidades() <<" value: ";
 if (attribute->GetTipoDistancia()==categorical || attribute->GetTipoDistancia()==ordinal)
 cout << *attribute->GetModalidades();
else if (attribute->GetTipoDistancia()==discretized) cout << *attribute->GetIntervals();
        end();
      }
      p=varList->GetNext(p);
    }
//cout <<"dimlist is" << *dimensionList <<"\n";
    return dimensionList;
  }

/*___________________________________________________________ */
/*
  Set<AttPattern>* ListOfAttributes::getSetOfAttPattern(intList* pattern)
  {
   try
    {
      if (!this->isDiscretized()) throw BadFormat();
      Set<AttPattern>* patternSet=new Set<AttPattern>();
      intList::NodePointer pP=pattern->GetFirst();
      AttPattern attPattern;
      int i=0;
      while (pP!=NULL)
      {
      attPattern=new AttPattern(i, pattern->GetElement(pP), pattern->GetElement(pP));
      patternSet->insertElement(attPattern);
      pP=attPattern->GetNext(pP);
      }
      return patternSet;
     }
      catch (BadFormat bf)
    {
      bf.PrintMessage("in ListOfAttributes::getSetOfAttPattern, attributes must be first discretized");
    }
  }

  /*___________________________________________________________________*/

  void ListOfAttributes::CrearFicheroMas (char texto[128])
  {//
    int TotalAttributes, cont=0;
    TotalAttributes=GetTotalAttributes();
    int i=0, i2;
    Attribute *attribute;
    fichero_salida fichero_salida1;
    fichero_salida1.abrir(texto);

    fichero_salida1 << TotalAttributes << " \n"; //

   NodePointer pA=GetFirst();
    while (pA!=NULL)
    {
      attribute=ListOfAttributes::GetElement(pA);
      if (attribute->GetTipoDistancia() == discretized) fichero_salida1 << 1; //changed to ordinal
      else fichero_salida1 << attribute->GetTipoDistancia();
      fichero_salida1 << " " << attribute->GetName() << ": ";

        if (attribute->GetTipoDistancia() != continuous)
        {
          if (attribute->GetTipoDistancia() != discretized)
	  fichero_salida1 << *attribute->GetModalidades();
	  else 
	  for (int i=0; i<attribute->GetTotalModalidades();i++) 
	  {
	  fichero_salida1 << i;
	  if (i<(attribute->GetTotalModalidades()-1))
	   fichero_salida1 << ",";
	   }
         }
        else fichero_salida1 << "continuous\n";
       pA=ListOfAttributes::GetNext(pA);
    }
    fichero_salida1.close();

  };//

  /*_______________________________________________________________________________*/

  void ListOfAttributes::CrearFicheroNombres (char texto[128], int classNumber, bool isDiscretized, bool select)
  {//
int totalModalities;
    if (classNumber==-1) classNumber=GetTotalAttributes()-1;
    int i=0, i2;
    NodePointer pA=ListOfAttributes::GetFirst();
    Attribute *inputAttribute, *classAttribute;
    fichero_salida fichero_salida1;
    fichero_salida1.abrir(texto);
    classAttribute=ListOfAttributes::GetElement(classNumber);
    stringList::NodePointer pm=classAttribute->GetModalidades()->GetFirst();
list<float>::NodePointer pm2;
    i2=0;
    while (pm!=NULL)
    {
      fichero_salida1 << i2;//pm->element;
      pm=classAttribute->GetModalidades()->GetNext(pm);
      if (pm!=NULL)
        fichero_salida1  << ", ";
      else
        fichero_salida1 << ".\n";
      i2++;
    }
    pA=ListOfAttributes::GetFirst();
    while (pA!=NULL)
    {
      inputAttribute=ListOfAttributes::GetElement(pA);

      if (i!=classNumber && (!select|| inputAttribute->isSelected()))
      {
        fichero_salida1 << inputAttribute->GetName() << ": ";
        if (!isDiscretized &&  ((inputAttribute->GetTipoDistancia() == discretized) || inputAttribute->GetTipoDistancia() == continuous))
          fichero_salida1 << "continuous.\n";
        else
        for(int i2=0;i2< inputAttribute->GetTotalModalidades();i2++)
{
         fichero_salida1 << i2;
if (i2<inputAttribute->GetTotalModalidades()-1) fichero_salida1  << ", ";
else fichero_salida1 << ".\n";
      }
}
      i++;

      pA=ListOfAttributes::GetNext(pA);
    }


    fichero_salida1.close();

  }

  /*______________________________________________________*/

float ListOfAttributes::getAlphaDenominator(BayesType bayesType, float alpha, intList *varList, intList *conditionalVarList)
{
float alphaDenominator=alpha;

switch (bayesType)
{
	case UBalpha: alphaDenominator=alpha; break; 
	case BDistanceUniform: 
alphaDenominator=alpha; 
if (conditionalVarList!=NULL && conditionalVarList->GetSize()==1)
alphaDenominator=alpha*getDistance(varList->GetFirstElement(), conditionalVarList->GetFirstElement());
else alphaDenominator=alpha;
break;
default:break;
}
return alphaDenominator;
}
 /*______________________________________________________*/

ListOfAttributes* ListOfAttributes::copyAttributesWithPositionsIn(intList* columns, bool isThis)
{

ListOfAttributes* res= new ListOfAttributes();

intList::NodePointer p=columns->GetFirst();
while(p!=NULL)
{
res->insertElement(this->GetElement(columns->GetElement(p)));
p=columns->GetNext(p);
}
return res;
}
};  // Fin del Namespace

#endif

/* Fin Fichero: ListOfAttributes.h */
