/* File: ListOfOrderedAttributes.cpp */


#ifndef __ListOfOrderedAttributes_cpp__
#define __ListOfOrderedAttributes_cpp__



#include "ListOfOrderedAttributes.h"


//using namespace UTILS;


namespace BIOS
{



  /**********************************/
  /* DEFINITIONS OF THE FUNCTIONS */
  /**********************************/


ListOfOrderedAttributes* ListOfOrderedAttributes::clone()
  {
return new ListOfOrderedAttributes(*this);
  };
/*___________________________________________________________*/

 ListOfOrderedAttributes::ListOfOrderedAttributes():ListOfAttributes()
  {
this->positionsVector=NULL;
  };
/*___________________________________________________________*/

  ListOfOrderedAttributes::ListOfOrderedAttributes(ListOfAttributes & listOfOrderedAttributes, VerbosityClass verbosity)
  {
cout <<"It should not be implemented ListOfOrderedAttributes::ListOfOrderedAttributes(ListOfAttributes & listOfOrderedAttributes, intList* verbosity)";
end();
}
  /*___________________________________________________________*/

  ListOfOrderedAttributes::ListOfOrderedAttributes(ListOfOrderedAttributes & listOfOrderedAttributes, VerbosityClass verbosity):ListOfAttributes(listOfOrderedAttributes, verbosity)
  {
if (listOfOrderedAttributes.positionsVector==NULL)
{
cout <<"Error in  ListOfOrderedAttributes::ListOfOrderedAttributes(ListOfOrderedAttributes & listOfOrderedAttributes, intList* verbosity)";
end();
}
 this->positionsVector=new floatList(*listOfOrderedAttributes.positionsVector);
};

  /*___________________________________________________________*/
/*
  ListOfOrderedAttributes::ListOfOrderedAttributes(ListOfAttributes & listOfAttributes, intList* verbosity):ListOfAttributes(listOfAttributes, verbosity)
  {

this->positionsVector=NULL;
};

  /*___________________________________________________________ */

  ListOfOrderedAttributes::ListOfOrderedAttributes(char* texto, VerbosityClass verbosity, int metadata):ListOfAttributes(texto, verbosity, metadata)
  {
this->positionsVector=NULL;
readPositions(texto);
//cout <<"  ListOfOrderedAttributes::ListOfOrderedAttributes finished";
  }

/*____________________________________________________________________*/

  void ListOfOrderedAttributes::readPositions(char* filename)
{
	positionsVector=NULL;
char filePos[256];
ChangeExtension(filename, filePos, "pos");
  if (existFile(filePos))
{
   positionsVector=new floatList(filePos);
if (positionsVector->GetSize()!=GetSize())
{
cout <<"Error in ListOfOrderedAttributes::readPositions, there are " << positionsVector->GetSize() <<" rows in file pos while there are " << GetSize() <<" attributes";
end();
}
}
else
{
cout <<"Error in ListOfOrderedAttributes::readPositions(char* filename), file .pos does not exist";
end();
}
}

  
  /*___________________________________________________________ */

  ListOfOrderedAttributes::~ListOfOrderedAttributes()
  {
  zap(positionsVector);

  };
  
  
 
   /*___________________________________________________________ */
   
   ListOfOrderedAttributes* ListOfOrderedAttributes::select()
  {
  ListOfOrderedAttributes* newList=new ListOfOrderedAttributes();
newList->positionsVector=NULL;

 newList->positionsVector=new floatList();
    ListOfOrderedAttributes::NodePointer p=GetFirst();

    while (p!=NULL)
    {
      if (GetElement(p)->isSelected())
{
       newList->insertElement(GetElement(p));
newList->positionsVector->insertElement(positionsVector->GetElement(GetPos(p)));
}
      p=GetNext(p);
    }
    return newList;
  }
 
/*___________________________________________________________ */

  void ListOfOrderedAttributes::GetDiscreteListOfAttributes(ListOfOrderedAttributes* listOfDiscreteOrderedAttributes)
  {
ListOfAttributes::GetDiscreteListOfAttributes(listOfDiscreteOrderedAttributes);
 listOfDiscreteOrderedAttributes->positionsVector=new floatList(*positionsVector);

}
  /*___________________________________________________________ */

  ListOfOrderedAttributes* ListOfOrderedAttributes::GetDiscreteListOfAttributes()
  {
    ListOfOrderedAttributes* listOfOrderedAttributes= new ListOfOrderedAttributes();
  GetDiscreteListOfAttributes(listOfOrderedAttributes);
   return (listOfOrderedAttributes);
  }

 
/*____________________________________________________________________________________ */

  float ListOfOrderedAttributes::getMaxBasicDistance(int att)
  {


if (positionsVector->GetElement(att)==-1) return 1;
float max=0;
for (int i=0;i<GetSize();i++)
if (positionsVector->GetElement(i)!=-1)
if (getBasicDistance(att,i)>max) 
max=getBasicDistance(att,i);
return max;
}
/*___________________________________________________________*/

Attribute* ListOfOrderedAttributes::Pop()
{
positionsVector->Pop();
return Set<Attribute, ListOfPointers>::Pop();
}
 /*___________________________________________________________*/

string ListOfOrderedAttributes::getName()
{
return string("ListOfOrderedAttributes");
}
/*____________________________________________________________________________________ */

  Pair<int> ListOfOrderedAttributes::getExtremes(int att, float maxDistance)
  {
Pair<int> extremes;
extremes.First=att;
extremes.Second=att;
bool foundLeft=false;
for (int i=0;i<GetSize();i++)
if (positionsVector->GetElement(i)!=-1 && positionsVector->GetElement(att)!=-1)
{
if (i<=att && !foundLeft){if (getBasicDistance(att,i)<=maxDistance) {extremes.First=i; foundLeft=true;}}
if (i>=att && getBasicDistance(att,i)<=maxDistance) extremes.Second=i;
}
return extremes;
}

/*____________________________________________________________________________________ */

  float ListOfOrderedAttributes::getDistance(int att, int att2)
  {
if (positionsVector->GetElement(att)!=-1 && positionsVector->GetElement(att2)!=-1)
return 1-getWeight(att, att2);
else return 1.0;
}
/*____________________________________________________________________________________ */

  float ListOfOrderedAttributes::getBasicDistance(int att, int att2)
  {
if (positionsVector->GetElement(att)!=-1 && positionsVector->GetElement(att2)!=-1)
return fabs(positionsVector->GetElement(att)-positionsVector->GetElement(att2));
else return 1.0;
}
/*____________________________________________________________________________________ */

  float ListOfOrderedAttributes::getWeight(int att, int att2)
  {
if (positionsVector->GetElement(att)!=-1 && positionsVector->GetElement(att2)!=-1)
return exp(-getBasicDistance(att, att2)/(float)100000);
else return 1.0;
}

 /*______________________________________________________*/

ListOfOrderedAttributes* ListOfOrderedAttributes::copyAttributesWithPositionsIn(intList* columns, bool isThis)
{
ListOfOrderedAttributes* res= new ListOfOrderedAttributes();
res->positionsVector=new floatList();

intList::NodePointer p=columns->GetFirst();
while(p!=NULL)
{
res->insertElement(this->GetElement(columns->GetElement(p)));
res->positionsVector->insertElement(this->positionsVector->GetElement(columns->GetElement(p)));
p=columns->GetNext(p);
}
return res;
}
};  // Fin del Namespace

#endif

/* Fin Fichero: ListOfOrderedAttributes.h */
