#ifndef Discretization_h
#define Discretization_h



namespace BIOS {

/**
Discretization can be done in three ways:
1. Embeded in a learning algorithm (not in this class)
2. Filtered before using the sample to learn a classifier or whatever
3. Wrapping a learning algorithm so that accuracy will drive the selected intervals

There is other classification:
1. autonomous discretization (???)
2. Class-driven discretization

Any of them can be filtered or embedded, while wrapping forces class-driven
*/

class Discretization {

private:

int classPosition;
DiscMode discMode;
intMLSample* discreteSample;
bool half, puntos, parada, entropia;
//AttributeDiscretization* attributeDiscretization;
floatList* SetIntervals(floatMLSample* narrowSample);
int totalAttributes;

public:
        Discretization(floatMLSample* sample, DiscMode discMod, bool supervised, VerbosityClass* verbosity, int classPosition=-1); //
    	~Discretization(); //
 
};

}
#endif

//#include "Discretization.cpp"//
