/***************************************************************************
 *   Copyright (C) 2005 by M. Mar Abad  				   *
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <fstream>
#include <string>
#include <stdio.h>//
#include <iostream>//
#include <cassert>//
#include <cstring>//
#include <cstdio>//
#include <cstdlib>//
#include <cmath>//
#include <ctime>//
#include <malloc.h>//
#include <fstream>//
#include <math.h>
#include "../../commonc++/list.h"
#include "DiscModeClass.h"
#include "../TestModeClass.h"
#include "../selection/SelMode.h"
#include "../AlgTypeClass.h"
#include "../SampleTest.h"

using namespace std;

namespace BIOS {


char* filename;

int disc, seleccionar, numal, k, num_vecinos, tipomissing, missing;
bool verbosity;
unsigned int haplotypes, salida;
int foldbase;



/*____________________________________________________________________*/
/*
void lectura_argumentos(int argc, char *argv[], char filename[128], DiscMode & discMode,
						TestMode & testMethod, unsigned int & numberOfFolds, SelMode & selection,
						unsigned short int salida, unsigned short int & verbosity,
						AlgType & algorithm, intList * parameters)
{

if (argc<9) 
{
cout <<"Ha olvidado escribir algun argumento para el modificador d (discretizacion)";
cout <<" \n\n<filename (all/data)>";
cout <<"\n\n<disc(";
cout <<	"No=0, ";
cout <<	"IgualAnchura=1, ";
cout << "D1R=2, ";
cout << "PRPRMR=3, ";
cout << "PRPEME=4, ";
cout << "RM=5, ";
cout << "PEPEME=7, ";
cout << "PEPRMR=8, ";
cout << "EM=9, ";
cout << "IgualFrecuenciaYang=11, ";
cout << "EntropiaDirichletImprecisa=12, ";
cout << "EntropiaDirichlet=13, ";
cout << "PRPRME=16,";
cout << "PRPEMR=17,";
cout << "PEPRME=18,";
cout << "PEPEMR=19,";
cout << "LocalEntropiaPuntosRiesgo=-5,";
cout << "LocalRiesgoPuntosEntropia=-4,	";
cout << "LocalEntropiaPuntosEntropia=-3, ";//C45
cout << "LocalRiesgoPuntosRiesgo=-2,";
cout << "LocalMitadEntropia=-1,";
cout << "LocalMitadRiesgo=0)> ";
cout << "\n\n<testMethod (";
cout << "LeaveOneOut=0, ";
cout << "CrossValidation=1, ";
cout << "holdout=2, ";
cout << "Training=3)> ";
cout << "\n\n<numberOfFolds> ";
cout << "\n\n<selection(";
cout << "Todos=0, ";
cout << "InclusionSRM=1, ";
cout << "InclusionERM=2, ";
cout << "manual = 3,";
cout << "arbol = 4,";
cout << "InclusionWrapper=5)> ";
cout << "\n\n<salida> ";
cout << "\n\n<verbosity>";
cout << "\n\n<algorithm (";
cout << "NB=0, ";
cout << "NBB=1, ";
cout << "TAN=2, ";
cout << "TANB=3, ";
cout << "GTAN=4, ";
cout << "GTANB=5, ";
cout << "FUNC=6,";
cout << "C45=10, ";
cout << "BT=11, ";
cout << "NN = 12)> ";
cout << "\n\n<parameters...>\n";
exit (0);
}
strcpy(filename, argv[1]);
discMode=(DiscMode)atoi(argv[2]);
testMethod=(TestMode)atoi(argv[3]);
numberOfFolds=atoi(argv[4]);
selection=(SelMode) atoi(argv[5]);
salida=atoi(argv[6]);
verbosity=atoi(argv[7]);
algorithm=(AlgType) atoi(argv[8]);


for (unsigned int i=9; i<argc; i++)
 parameters->insertElement(atoi(argv[i]));
}
/*_________________________________________________________________________*/

list<unsigned int>* GetSelected(char* filename, unsigned int cm, unsigned int totalmuestras)
{
list<unsigned int>*listSelected;
listSelected=new list<unsigned int>();
char fileblocks[128];
ChangeExtension(filename, fileblocks,"bl");
int TotalLines=GetTotalLines(fileblocks), i=0;
bool NotFound=true, EOLN=false;
ifstream * source;
int lineSize=GetLineLength(fileblocks);
char *line, *SNP;
while (NotFound && i<TotalLines)
{
line=GetLine (source);
SNP = strtok (line," \t");
while (SNP!=NULL) 
{
if (atoi(SNP)!=cm) listSelected->insertElement(atoi(SNP));
else NotFound=false;
SNP = strtok (NULL," \t");
};
if (NotFound) listSelected->Empty();
}
listSelected->insertElement(cm); // current SNP to be completed
listSelected->insertElement(totalmuestras); // current SNP to be completed
zaparr(line);
return listSelected;
}


}// end namespace

using namespace BIOS;


/*_________________________________________________________________________*/

// This program computes test accuracy and sd given:
// - a discretization algorithm 
// - a classification algorithm
// - a sample

int main(int argc, char *argv[]) {

char filename[128];
DiscMode discMode;
SampleTest<KNN<int>, int> *testKNN;
SampleTest<C45<int>, int> *testC45;
SampleTest<NB<int>,  int> *testNB;
SampleTest<TAN<int>, int> *testTAN;

list<intList > *sample;
TestMode testMethod;
unsigned int numberOfFolds, dependiente;
SelMode selection;
unsigned short int Salida, verbosity;
AlgType algorithm;
intList * parameters;
parameters=new intList();
Pair<double> acc;
lectura_argumentos(argc, argv, filename, discMode, testMethod, numberOfFolds, selection, salida, verbosity, algorithm, parameters);

unsigned int totalmuestras;

char texto2[128], textoa[128], texto3[128], texto[128], text[128], filename2[128];

ChangeExtension(filename, texto2, "mas");
list<Attribute*> listOfAttributes(texto2);
Attribute *clase, *clase2;

switch (algorithm)
{
case aNB:
case aNBB:
testNB=new SampleTest<NB<int>, int>(texto, testMethod, numberOfFolds, parameters);
break;
case aTAN:
case aTANB:
testTAN=new SampleTest<TAN<int>, int>(texto, testMethod, numberOfFolds, parameters);
break;
//case GTAN:
//case GTANB:
//testGTAN=new SampleTest<GTAN<int>, int>(texto, testMethod, numberOfFolds, parameters);
//break;
//case FUNC:
//DirectDependency* classifier;
//test=new SampleTest<DirectDependency>(texto, testMethod, numberOfFolds, parameters);
//break;
case aC4_5:
//C45* classifier;
    testC45=new SampleTest<C45<int>, int>(texto, testMethod, numberOfFolds, parameters);
    acc=testC45->GetAveragedAccuracy();
delete testC45;

break;
// case BT:
//  test=new SampleTest<M1nn>(texto, testMethod, numberOfFolds, parameters);
// break;
case aNN:   
	testKNN=new SampleTest<KNN<int>, int>(texto, testMethod, numberOfFolds, parameters);
	acc=testKNN->GetAveragedAccuracy();
	delete testKNN;
break;  
}



tasaAciertos=acc.First;
cout  << acc.First;

unlink(texto);
unlink(texto2);
unlink(texto3);
} // end if cm!=total_muestras
pA=listOfAttributes.getNext(pA);
cm++;
};// fin for each muestra

//InputFile.close();
cout <<"\n\nTotal prueba medio: " << GetMean(tasaAciertos, totalmuestras)  <<"+-" <<GetSampleSD(tasaAciertos, totalmuestras);
cout <<"\n";

 }






