#ifndef __SelModeClass_h__
#define __SelModeClass_h__


namespace BIOS {

typedef enum SelMode {
	todos=0,
	reliefF=367, //
	forwardHillclimbingSRM=31211, //embedded+forward+SRM; same comment as for inclusionCorrelation?
	forwardHillclimbingERM=31111, //embedded+forward+ERM; // nonsense because does not penilize large subsets
	manual = 200, //filter, read vars from command line
	treeWrapper = 140,// for ordered features, as SNPs, it searches over different kernel sizes by using binary search.
	forwardHillclimbingWrapper=11011,
        forwardHillclimbingEntropy=31311, // nonsense because does not penilize large subsets; NP (exp to the number of variables)
        forwardHillclimbingCorrelation=31611, // it uses correlation and symmetrical uncertainty (Hall & Smith 97)
	forwardHillclimbingMDL=31411,// it is used for p(K/inputFeatures). If other classifiers were used, it would be suboptimal (Friedman et. al. 97), conditional likelihhod would be better but there is no closed form solution through the parameter space assuming NB or some accurate classifier Bayesian structure.
	//NP (exp to the number of variables)
	oneByOneBayesScore=325,
	oneByOneBayesScoreGenotypeLD=3252,
	oneByOneLDBayesScore=3251,
	forwardHillclimbingBayesScore=31511,// same comment as for inclusionMDL, NP (exp to the number of variables)
	oneByOneEntropy=323,// nonsense
        oneByOneMDL=324,
        oneByOneMDLGenotypeLD=3242,
	oneByOneLDMDL=3241,
        oneByOneWrapper=120,//
        manualFromFile=210, //filter, read vars from a file [+params]: some algorithm gets from a file or compute vars to be selected, as for SNPs
//        onlyClass=220 //filter, read vars from a file [+params]: some algorithm gets from a file or compute vars to be selected, as for SNPs
//	filterKernel=11 // for ordered features, as SNPs, it learns a kernel as a previous step.
	oneByOneAndConditionalMDL=344, // NP (exp to the number of variables)
	oneByOneAndConditionalBayesScore=345, // NP (exp to the number of variables)
	oneByOneAndConditionalEntropy=343, // NP (exp to the number of variables)
	oneByOneAndPairsMDL=354,
	oneByOneAndPairsBayesScore=355

};


//wrapper/filter/embedded: 1/2/3
//an embedded method can be used as a filter by using a training set in a previous run
//space-search/oneByOne/tree/oneByOneAndConditional/oneByOneAndPairs/allRelated: 1/2/3/4/5/6 (for embedded or wrapper) //commandLine/file/: 0/1/2 (for filter) 
//ERM/SRM/Entropy/MDL/bayesScore/Correlation/distance: 1/2/3/4/5/6/7  (only for embedded)
//space search strategy: steepest-ascent hillclimbing/best-first: 1/2
//space search direction: forward/backward: 1/2

class SelModeClass {

public:

SelMode selMode;

floatList* arguments;
 	
SelModeClass(SelMode selMode, floatList* arguments)
{
this->selMode=selMode;
 this->arguments=arguments;
}

bool isBayesian()
{
switch (selMode)
{
case oneByOneBayesScore:
case oneByOneAndPairsBayesScore:
case oneByOneAndConditionalBayesScore:
case oneByOneLDBayesScore:
case forwardHillclimbingBayesScore:
return true;
default: return false;
}
} 	

~SelModeClass() {};

///////
/*
char* print ()
{
	strcpy(line, "\nExtraction algorithm:\t\t");
	switch (selMode)
	{
	case todos: strcat(line, "No selection"); break;
	case inclusionSRM:  strcat(line, "Forward SRM"); break;
	case inclusionERM:  strcat(line, "Forward ERM"); break;
	case inclusionLDM:  strcat(line, "Forward LDM"); break;
	case inclusionEntropy:  strcat(line, "Forward Entropy"); break;
	case manual:  strcat(line, "User-specified"); break;
	case treeWrapper:  strcat(line, "Tree-based"); break;
	case inclusionWrapper:  strcat(line, "Wrapper-forward"); break;

	}
	return line;
}
*/
};

ostream& operator<<(ostream& out, SelModeClass& p)
  {
  
out << "\nExtraction algorithm:\t\t";
	switch (p.selMode)
	{
	case todos: out << "No selection"; break;
	case forwardHillclimbingSRM:  out <<  "Forward SRM"; break;
	case forwardHillclimbingERM:  out <<  "Forward ERM"; break;
	case forwardHillclimbingMDL:  out <<  "Forward LDM"; break;
	case forwardHillclimbingEntropy:  out <<  "Forward Entropy"; break;
	case manual:  out <<  "User-specified with params: " << *p.arguments; break;
	case treeWrapper:  out <<  "Tree-based wrapper"; break;
	case forwardHillclimbingWrapper:  out <<  "Wrapper-forward"; break;
	case forwardHillclimbingBayesScore:  out <<  "Forward Bayes score"; break;
	case forwardHillclimbingCorrelation:  out <<  "Forward correlation"; break;
	case manualFromFile:  out <<  "Manual from file"; break;
	case oneByOneBayesScore:  out <<  "OneByOne Bayes score"; break;
	case oneByOneLDBayesScore:  out <<  "OneByOne LD Bayes score (only for SNP genotype data sets"; break;
	case oneByOneEntropy:  out <<  "OneByOne entropy"; break;
	case oneByOneMDL:  out <<  "OneByOne MDL"; break;
	case oneByOneLDMDL:  out <<  "OneByOne LD MDL (only for SNP genotype data sets"; break;
	case oneByOneWrapper:  out <<  "OneByOne wrapper"; break;
	case oneByOneAndConditionalBayesScore:  out <<  "OneByOneAndConditional Bayes Score"; break;
	case oneByOneAndConditionalEntropy:  out <<  "OneByOneAndConditional entropy"; break;
	case oneByOneAndConditionalMDL:  out <<  "OneByOneAndConditional MDL"; break;
	case oneByOneAndPairsBayesScore:  out <<  "OneByOneAndPairs Bayes score"; break;
	case oneByOneAndPairsMDL:  out <<  "OneByOneAndPairs MDL"; break;
	case reliefF:  out <<  "reliefF "; 
	if (p.arguments->size()>0) out << " with m (number of instances for sampling): " << p.arguments->getElement(0); 
else out << " with m=all instances being used for sampling"; 
if (p.arguments->size()>1) out << ",  " << p.arguments->getElement(1) <<" nearest neighbours"; 
else out << ", 10 nearest neighbours ";
if (p.arguments->size()>2) out << " and threshold  " << p.arguments->getElement(2); 
else out << " and threshold 1/sqrt(m)"; 
	
	break;
	
//case transformedManual:  out <<  "transformed Manual"; break;
//case onlyClass:  out <<  "only class"; break;
default: out <<"Invalid selection algorithm code " << p.selMode; end(); break;
	}
	
if (p.selMode!=manual && p.selMode!=manualFromFile && p.selMode!=todos  && p.selMode!=treeWrapper  && p.selMode!=forwardHillclimbingWrapper)
//if (p.isBayesian())
{
	if (p.arguments->size()>0)
             cout << " with Bayes type " << p.arguments->getElement(0); 
else cout << " with MLE"; 

if (p.arguments->size()>1)
             cout << " and alpha " << p.arguments->getElement(1); 
else cout << " and alpha " << 0; 
}
	

}






}

#endif
