/* File: AlleleProbabilityTable.h */


#ifndef __AlleleProbabilityTable_h__
#define __AlleleProbabilityTable_h__




using namespace std;


namespace BIOS
{
// assumption: categories are ordered this way: H, O1, O2
class AlleleProbabilityTable: public ProbabilityTable
{
public:
  AlleleProbabilityTable(intMLSample*  sample, intList *varList, intList* dimensionList, floatList* alphaNumerator=NULL, float alphaDenominator=0)  throw (BadFormat,NullValue,NonProb) :ProbabilityTable() 
  {
for (int i=0;i<dimensionList->GetSize();i++)
 if (dimensionList->GetElement(i)!=3) 
{
cout << *sample->listOfAttributes;
throw BadFormat(string("AlleleProbabilityTable::AlleleProbabilityTable, dimension is "+tos(dimensionList->GetElement(i)))); 
};
if (varList->GetSize()>2)   throw BadFormat(string("AlleleProbabilityTable::AlleleProbabilityTable, size is "+tos(varList->GetSize()))); 

VarsTable<int>* pT=new VarsTable<int>(sample, varList, dimensionList);


dimensionList=new intList();
for (int i=0;i<varList->GetSize();i++)
dimensionList->insertElement(2);


MultidimensionalTable<Prob>::set(dimensionList);
set(varList, pT->totalSample*2);

int indexFirst;
double* numerator=new double[size], nHH, fA, fB, total;

totalSample=pT->totalSample*2;

for (int i=0;i<this->getSize();i++)
{
indexFirst=this->getIndexPositionOfIndexVar(i, 0);
if (alphaNumerator!=NULL)  
numerator[i]=alphaNumerator->GetElement(indexFirst);
else   
numerator[i]=alphaDenominator/(double)size;
}

if (varList->GetSize()==1)
{
numerator[0]=numerator[0]+pT->getValue(1)*2+pT->getValue(0); //major allele
numerator[1]=numerator[1]+pT->getValue(2)*2+pT->getValue(0); // minor allele
}
else
{
numerator[0]=numerator[0]+pT->getValue(4)*2+pT->getValue(1)+pT->getValue(3); //AB
numerator[1]=numerator[1]+pT->getValue(5)*2+pT->getValue(2)+pT->getValue(3); // Ab
numerator[2]=numerator[2]+pT->getValue(7)*2+pT->getValue(1)+pT->getValue(6); //aB
numerator[3]=numerator[3]+pT->getValue(8)*2+pT->getValue(2)+pT->getValue(6); // ab
total= numerator[0]+numerator[1]+numerator[2]+numerator[3];
nHH=pT->getValue(0);
fA=(numerator[0]+numerator[1]+nHH)/(total+2*nHH), fB=(numerator[0]+numerator[2]+nHH)/(total+2*nHH);
Table2x2 T2x2;
numerator[0]=T2x2.EstimateMLE(fA*fB, nHH, numerator[0], total, fA, fB);
numerator[1]=fA-numerator[0];
numerator[2]=fB-numerator[0];
numerator[3]=1-numerator[0]-numerator[1]-numerator[2];
}
zap(pT);
//cout <<"totslSample:" << totalSample;
for (int i=0;i<this->getSize();i++)
{
//cout <<"\nnum is " << numerator[i] <<"\n";
if (varList->GetSize()==1)
this->table[i]=Prob(numerator[i], totalSample+alphaDenominator);
else this->table[i]=Prob(numerator[i]*(totalSample+alphaDenominator), totalSample+alphaDenominator);
}
};
};
};
  
#endif
