/* File: ConditionalProbabilityTable.h */


#ifndef __ConditionalProbabilityTable_h__
#define __ConditionalProbabilityTable_h__

#include <sys/stat.h>
#include <iostream>
#include <cassert>
#include <fstream>
//#include <individual.h>
#include <string>
#include <iostream>
//#include <math.h>
#include <cmath>
#include <stdio.h>//
#include "../../../commonc++/ExceptionsBasic.h"
#include "../../../commonc++/basic.h"
#include "../../../commonc++/NonZero.h"
#include "../../../commonc++/prob.h"
#include "../../../commonc++/MultidimensionalTable.h"
#include "../MLSample.h"

using namespace std;

namespace BIOS
{

  /////////////////////////////////////////
  class ConditionalProbabilityTable: public MultidimensionalTable<prob> //
  {//
    // it is a 2D table with only the element at one side of a diagonal plus the diagonal
    
 private:
    
 float alpha;

 intList *conditionalVarList;

 intList *varList;

  public:
	  /*______________________________________________________*/

	  ConditionalProbabilityTable(float alpha):MultidimensionalTable<prob>::MultidimensionalTable()
	  {
      this->varList=NULL;
      this->conditionalList=NULL;
	  this->alpha=alpha;
    };
	    /*______________________________________________________*/

	  ConditionalProbabilityTable(ConditionalProbabilityTable &source):MultidimensionalTable<prob>::MultidimensionalTable(source.dimensionList)
    {
  		  this->conditionalVarList=new intList(*source.conditionalVarList); 
  		  this->varList=new intList(*source.varList); 		

		  this->alpha=source.alpha;

		 
	  }
        /*______________________________________________________*/

	  ConditionalProbabilityTable(ProbabilityTable &source):MultidimensionalTable<prob>::MultidimensionalTable(source.dimensionList)
    {
  		  this->conditionalVarList=NULL; 
  		  this->varList=new intList(*source.varList); 		

		  this->alpha=source.alpha;

		 
	  }

 /*______________________________________________________*/

	  ConditionalProbabilityTable(intList *varList, intList *conditionalVarList, intList* dimensionList, floar alpha)
		  :MultidimensionalTable<int>::MultidimensionalTable(dimensionList)
	  {
		  if (varList==NULL || dimensionList==NULL)
		  {
			  cout <<"Error in ConditionalProbabilityTable";
			  exit(0);
		  }
		  this->varList=new intList(*varList); 
		  if (conditionalVarList!=NULL)
  		  this->conditionalVarList=new intList(*conditionalVarList); 		
		  else this->conditionalVarList=NULL;
	  this->alpha=alpha;
		  
		 
	  };


    /*______________________________________________________*/

  ~ConditionalProbabilityTable(){zap(varList)};
  
  /*_______________________________________________________________*/
    /*
  prob getProbability(int* values)
  {
	
  if (isCompletelyMissing(values)) 
	  return prob(0,0);
 
  return getValue(values);
  }
   /*_______________________________________________________________*/
  
  
  ConditionalProbabilityTable* marginalize(intList* sourceVarList)
  {
	  
	  ProbabilityTable* probabilityTable(this->varList, this->dimensionList);
	  probabilityTable->alpha=alpha; 
	  int *pos;
	  for (i=0; i<size;i++)
		  {
			 pos=getPos(i);
             probabilityTable->setValue(pos, getValue(pos)->getNumerator());
			 zap(pos);
			 }

	  ProbabilityTable* targetProbabilityTable=probabilityTable->marginalize(sourceVarList);
	  zap(probabilityTable);
	
		  return targetProbabilityTable;
  }
    /*_______________________________________________________________*/
  
  
  ConditionalProbabilityTable* void removeInconsistenciesWithEvidence(intList* sourcePosList)
  {
	  
	  int *pos;
	  int j;
	  double numerator, denominator;
	  bool inconsistency, conditionalInconsistency;
	  for (i=0; i<size;i++)
		  {
		  inconsistency=false;
		  conditionalInconsistency=false;
			 pos=getPos(i);
			 j=0;
			 do
			 {
				 if (pos[i]!=sourcePosList->GetElement(j) && sourcePosList->GetElement(j)!=dimensions[j])// inconsistency
				 {
                   inconsistency=true;
				   if (conditionalList!=NULL && conditionalList->findElement(varList->GetElement(j))!=NULL)
					   conditionalInconsistency=true;
				 }
				 j++;
			 }
			 while (j<getDimension() && conditionalInconsistency==false);
             if (inconsistency)
			 {
			 numerator=0;
			 denominator=getValue(pos)->getDenominator();
			 if (conditionalInconsistency) denominator=0;
             setValue(pos, prob(numerator, denominator));
			 zap(pos);
			 }
	  }
  }
   /*______________________________________________________*/

    ConditionalProbabilityTable* operator*(ConditionalProbabilityTable& source)
    {
     if (source.conditionalVarList!=NULL && !source.conditionalVarList!=*varList)
	 {
		 cout <<"Error in ConditionalProbabilityTable::operator*";
		 end();
	 }
	 int *pos=NULL, *pos2=NULL;
	 ConditionalProbabilityTable* cPT;
	 ProbabilityTable* marginal=NULL;
	 ProbabilityTable* joint=this->marginalize(varList);
	 if (conditionalList!=NULL)
	 {
	 marginal=this->marginalize(conditionalList);
     cPT=joint/marginal;
	 }
	 else 
	 {
		 cPT= new ConditionalProbabilityTable(*this);
		 for(int i=0;i<size;i++)
		 {
          pos=getPos(i);
		  pos2=new int[source.GetDimension()];
		  for (int j=0;j<source.GetDimension();j++)
            pos2[j]=pos[varList->GetPos(varList->findElement(source.varList->GetElement((unsigned int)j)))];
		  setValue(pos, getValue(pos)*source.getValue(pos2));
		  zap(pos);
		  zap(pos2);
		 }
	 }
	 zap(joint);
	 zap(marginal);
	 return cPT;
	 }
 /*______________________________________________________*/
/*
    ConditionalProbabilityTable* operator*(ConditionalProbabilityTable& source)
    {
     if (*source->conditionalVarList!=*varList)
	 {
		 cout <<"Error in ConditionalProbabilityTable::operator*";
		 end();
	 }
	 int*index1=new int[source.varList->GetSize()], *index2=new int[source.varList->GetSize()];
	 InitializeList(index1, source.varList->GetSize(), -1);
	 InitializeList(index2, source.varList->GetSize(), -1);

	 intList* varList2=new int();

	 intList::NodePointer p=source.conditionalList->GetFirst();
     int i=0, j=0;
	 while (p!=NULL)
	 {
	  if (conditionalList->findElement(source.conditionalList->GetElement(p))==NULL)
	  {
	   varList2->insertElement(source.conditionalList->GetElement(p));
	   index1[i]=i;
 	   index2[i]=source->varList->GetSize()-source->conditionalVarList->GetSize()+j;
  	   i++;
	  }
	  p=source.conditionalList->GetNext(p);
      j++;
	 }
	 int offset=i, j=0;
     p=source.varList->GetFirst();
     while (p!=NULL)
	 {
	  if (varList2->findElement(source.varList->GetElement(p))==NULL)
	  {
	   varList2->insertElement(source.varList->GetElement(p));
      index2[i]=j;
      i++;
	  }
	  j++;
  	  p=source.varList->GetNext(p);
	 }

	 ProbabilityTable*pT1=new probabilityTable();

	 ConditionalProbabilityTable* cPT=new ConditionalProbabilityTable(source.varList2, conditionalList, source.dimensionList);
	 zap(varList2);
	 int* pos, pos1, pos2;
	 for (i=0; i<cPT->size;i++)
		  {
			 pos=getPos(i);
             pos1=new int[varList->GetSize()];
			 for (j=0; j<cPT->varList->GetSize();j++)
			  if (index1[j]!=-1)
              pos1[index1[j]]=pos[j];
			 pos2=new int[cPT->varList->GetSize()];
			 for (j=0; j<cPT->varList->GetSize();j++)
              pos2[index2[j]]=pos[j];
			 setValue(pos, prob(source.getValue(pos1),source.totalCounts, alpha, getSize()));
			 zaparr(pos);
			 zaparr(pos1);
			 zaparr(pos2);
		  }
	}
	*/
};
  
  }
#endif
