/* File: PotentialList.cpp */


#ifndef __PotentialList_cpp__
#define __PotentialList_cpp__

using namespace std;

namespace BIOS
{

/*____________________________________________________________________________________ */

PotentialList::PotentialList():Container<PotentialTable, ListOfPointers>()
{
}
/*____________________________________________________________________________________ */

PotentialList::PotentialList(Container<PotentialTable, ListOfPointers> & s):Container<PotentialTable, ListOfPointers>(s)
{
}

/*____________________________________________________________________________________ */

PotentialList* PotentialList::simplify() 
{
try 
{
PotentialList* potentialTableList=new PotentialList(*this), *potentialTableList2;
PotentialTable* potentialTable, * potentialTable2;
int i=0;
SampleOfSets<Integer>* varSets=potentialTableList->getVarSets();
if (empty(varSets)) return potentialTableList;
//if (varSets==NULL) return potentialTableList;
Set<Integer, ListOfPointers>* varSet;
int blanket;
Container<IntegerSet, ListOfPointers>::NodePointer p=varSets->GetFirst();
bool reduced=false;
varSets->GetElement(p);
do
{
varSet=new Set<Integer, ListOfPointers>(*varSets->GetElement(p));
p=varSets->removeNode(p);
blanket=varSets->getOptimalBlanket(varSet);
if (blanket!=-1) 
{
reduced=true;
if (blanket>=i) blanket++;
potentialTable=potentialTableList->GetElement(blanket);
potentialTable2=*potentialTable*this->GetElement(i);
potentialTableList->removeNode(blanket);
if (blanket<i) i--;
potentialTableList->removeNode(i);
if (blanket>i) blanket--;
potentialTableList->insertElementAtPos(potentialTable2, blanket);
zap(potentialTable2);
i--;
}
else varSets->insertElementAtPointer(varSet, p);
i++;
zap(varSet);
}
while (!reduced && p!=NULL);
zap(varSets);
if (reduced) 
{
potentialTableList2=potentialTableList->simplify();
zap(potentialTableList);
potentialTableList=potentialTableList2;
}
//cout << *potentialTableList;

return potentialTableList;
}
   catch (NullValue nv)
    {
      nv.PrintMessage(string(nv.message+" called from PotentialList::simplify()").c_str());
    }
}
/*____________________________________________________________________________________ */

PotentialList* PotentialList::product(PotentialList* otherPotentialList, bool product)
{
SampleOfSets<Integer>* varSets, *otherVarSets=otherPotentialList->getVarSets();
int optimalBlanket, i=0; 
Container<IntegerSet, ListOfPointers>::NodePointer p=otherVarSets->GetFirst();
PotentialList* result=new PotentialList(*this), *result2;
PotentialTable* pt, *pt2, *pt3;
while (p!=NULL)
{
varSets=result->getVarSets();
optimalBlanket=varSets->getOptimalBlanket(otherVarSets->GetElement(p));
if (optimalBlanket==-1)
{
if (product)
result->insertElement(otherPotentialList->GetElement(i));
else
{
pt=new PotentialTable(*otherPotentialList->GetElement(i));
pt2=new PotentialTable(*pt);
pt2->initialize(1);
pt3=*pt2/pt;
zap(pt);
zap(pt2);
result->insertElement(pt3);
zap(pt3);
}
}
else
{
pt=result->GetElement(optimalBlanket);
pt2=pt->product(otherPotentialList->GetElement(i), product);
result->removeNode(optimalBlanket);
result->insertElementAtPos(pt2, optimalBlanket);
zap(pt2);
}
p=otherVarSets->GetNext(p);
i++;
zap(varSets);
}
zap(otherVarSets);
result2=result->simplify();
zap(result);
return result2;
}
/*____________________________________________________________________________________ */

SampleOfSets<Integer>* PotentialList::getVarSets()
{
SampleOfSets<Integer>* varSets= new SampleOfSets<Integer>();
PotentialList::NodePointer p=this->GetFirst();
IntegerSet *integerSet;
while (p!=NULL)
{
integerSet=GetElement(p)->varList->getIntegerSet();
varSets->insertElement(integerSet);
zap(integerSet);
p=GetNext(p);
}
return varSets;
}

/*____________________________________________________________________________________ */
 
PotentialList* PotentialList::operator/(PotentialList* otherPotentialList)
{
return product(otherPotentialList, false);
}
/*____________________________________________________________________________________ */
 
PotentialList* PotentialList::operator*(PotentialList* otherPotentialList)
{
return product(otherPotentialList, true);
}
/*____________________________________________________________________________________ */
/*
PotentialList* PotentialList::marginalize(intList* marginalList, intList* inputPattern, ListOfAttributes* listOfAttributes)
{
PotentialTable* marginal;
PotentialList* marginalPotentials=new PotentialList();
PotentialList::NodePointer p=GetFirst();
intList* adaptedMarginalList, *extendedVarlist;
//cout <<"\n\n\ncurrent number of pots is" << *this;
while (p!=NULL)
{
adaptedMarginalList=GetElement(p)->varList->copyElementsIn(marginalList);
//extendedVarlist=GetElement(p)->addMissingVarList(adaptedMarginalList, inputPattern, listOfAttributes);
//cout <<"extendedVarlist lis is: " << *extendedVarlist <<"and current vars are " << *GetElement(p)->varList <<"and adapted list is " << *adaptedMarginalList;
marginal=GetElement(p)->marginalize(adaptedMarginalList);
if (extendedVarlist->GetSize()>0)
marginalPotentials->insertElement(marginal);
//cout <<"\n\nmarginal is:" << *marginal;
zap(marginal);
zap(adaptedMarginalList);
//zap(extendedVarlist);
p=GetNext(p);
}
return marginalPotentials;
}
/*____________________________________________________________________________________ */

PotentialTable* PotentialList::productTable()
{
if (GetSize()==0) return NULL;
PotentialList::NodePointer p=this->GetFirst();
PotentialTable* result=new PotentialTable(*this->GetElement(p)), *temp;
p=this->GetNext(p);
while (p!=NULL)
{
 temp=*result*this->GetElement(p);
 zap(result);
 result=temp;
 p=this->GetNext(p);  
}
return result;
}
/*____________________________________________________________________________________ */

PotentialList* PotentialList::extractSubPotential(intList* posList)
{
/*
if (posList==NULL || posList->GetSize()==0) return NULL;
intList::NodePointer p=posList->GetFirst();
PotentialList* result=new PotentialList();
while (p!=NULL)
{
 result->insertElement(this->GetElement(posList->GetElement(p)));
 this->removeNode(this->GetNode(posList->GetElement(p)));
 p=posList->GetNext(p);
}
return result;
*/
Container<PotentialTable, ListOfPointers> *r=this->extractElementsWithPositionsIn(posList);
PotentialList* result=new PotentialList(*r);
zap(r);
return result;
}

/*____________________________________________________________________________________ */

PotentialList* PotentialList::marginalize(intList* marginalList)
{
//return new PotentialList(*this);
SampleOfSets<Integer>* varSets=this->getVarSets();
//zap(varSets);
//return new PotentialList(*this);
IntegerSet *commonNodes=varSets->getUnionOfIntersections(), *newSet, *unitSet=new IntegerSet();
intList* extendedMarginalList=commonNodes->getIntListFromPointerList(), *completeList=new intList(*marginalList), *newList=extendedMarginalList->copyElementsNotIn(marginalList), * blankets, *marginalVars;
completeList->copyPaste(newList);
PotentialList* result=this->marginalizeIncluded(completeList), *temp;
zap(varSets);
zap(commonNodes);
zap(extendedMarginalList);
zap(completeList);
intList::NodePointer pl=newList->GetFirst();
PotentialTable *PT, *PT2;
Integer* i;



while (pl!=NULL)
{
if (result->GetSize()<2) 
{
zap(newList);
zap(unitSet);
temp=result->marginalizeIncluded(marginalList);
zap(result);
return temp;
}
varSets=result->getVarSets();
i=new Integer(newList->GetElement(pl));
 unitSet->insertElement(i);
zap(i);
 blankets=varSets->getBlankets(unitSet);
 temp=result->extractSubPotential(blankets);
 PT=temp->productTable();
 marginalVars=new intList(*PT->varList);
 marginalVars->removeNode(marginalVars->findElement(newList->GetElement(pl)));
 PT2=PT->marginalize(marginalVars);
 result->insertElement(PT2);
 zap(PT2);
 zap(PT);
 zap(temp);
 zap(blankets);
 unitSet->Empty();
 zap(varSets);
 pl=newList->GetNext(pl);
 zap(marginalVars);
}; 
zap(unitSet);
zap(newList);
temp=result->marginalizeIncluded(marginalList);
zap(result);
return temp;
};
/*____________________________________________________________________________________ */

PotentialList* PotentialList::marginalizeIncluded(intList* marginalList)
{
PotentialTable* marginal;
PotentialList* marginalPotentials=new PotentialList();
PotentialList::NodePointer p=GetFirst();
intList* adaptedMarginalList;
while (p!=NULL)
{
adaptedMarginalList=GetElement(p)->varList->copyElementsIn(marginalList);
marginal=GetElement(p)->marginalize(adaptedMarginalList);
if (adaptedMarginalList->GetSize()>0)
marginalPotentials->insertElement(marginal);
zap(marginal);
zap(adaptedMarginalList);
p=GetNext(p);
};
return marginalPotentials;
}

/*____________________________________________________________________________________ */

void PotentialList::removeInconsistenciesWithEvidence(intList*
inputPattern)
{
 PotentialList::NodePointer p=GetFirst();
 PotentialTable* potential;
 intList* inputPattern2; 
       while (p!=NULL)
       {
       potential=GetElement(p);
       inputPattern2=inputPattern->copyElementsWithPositionsIn(potential->varList, false);
       potential->removeInconsistenciesWithEvidence(inputPattern2, 0);
       p=GetNext(p);
       zap(inputPattern2);
       }
}











};  // Fin del Namespace

#endif
