/* File: PotentialList.h */


#ifndef __PotentialList_h__
#define __PotentialList_h__

using namespace std;

namespace BIOS
{


typedef VarsTable<double> PotentialTable;
//typedef Container<PotentialTable, ListOfPointers> 

class PotentialList: public Container<PotentialTable, ListOfPointers>
{
public:
PotentialList* extractSubPotential(intList* posList);
PotentialList* product(PotentialList* otherList, bool product);
PotentialTable* productTable();
PotentialList* operator/(PotentialList* otherList);
PotentialList* operator*(PotentialList* otherList);
PotentialList* marginalize(intList *marginalList, intList* inputPattern, ListOfAttributes* listOfAttributes);
PotentialList* marginalize(intList *marginalList);
PotentialList* marginalizeIncluded(intList *marginalList);
PotentialList* simplify();
intSample* getVarSets();
PotentialList(Container<PotentialTable, ListOfPointers> & s);
void removeInconsistenciesWithEvidence(intList*
inputPattern);
PotentialList();
~PotentialList(){};

};



};  // Fin del Namespace

#endif
