/* File: PotentialTable.h */


#ifndef __PotentialTable_h__
#define __PotentialTable_h__


#include "../MLSample.h"

using namespace std;


namespace BIOS
{

  template <class T> class PotentialTable: public MultidimensionalTable<T> //
  {//
    // it is a 2D table with only the element at one side of a diagonal plus the diagonal

  private:
  
  int totalSample; 
     
  protected:
 
float alpha;
 
  public:
  intList *varList;
 
    ostream& operator<<(ostream& out);
    string print();
    //virtual void normalize();
    PotentialTable();
    PotentialTable(PotentialTable &source);
      PotentialTable(MultidimensionalTable<T> &source);
 
    PotentialTable(intMLSample*  sample, intList *varList, intList* dimensionList, float alpha,  intSample::NodePointer first=NULL, intSample::NodePointer last=NULL);
    PotentialTable(floatMLSample*  sample, intList *varList, intList* dimensionList, float alpha, floatSample::NodePointer first=NULL, floatSample::NodePointer last=NULL);
    void set(intMLSample*  sample, intList *varList, intList* dimensionList, float alpha, intSample::NodePointer first=NULL, intSample::NodePointer last=NULL);
    void set(intList *varList, float alpha);
    void set(PotentialTable *source);
    void set();
   // PotentialTable(MultidimensionalTable<T> &source);
    PotentialTable(intList *varList, intList* dimensionList, float alpha);
    ~PotentialTable();
  //  virtual void setTotalCounts();
    PotentialTable* marginalize(intList* sourceVarList);
    PotentialTable* operator*(PotentialTable* source);
    PotentialTable* product(PotentialTable* source, bool product);
    PotentialTable* operator/(PotentialTable* source);
    virtual Prob getProbability(int* values);
    //void addValue(int pos, double numerator, double denominator);
   // void setValue(int pos, double numerator, double denominator);
    void setValue(int pos, T);
    virtual void setProductValue(int pos, T numerator, T denominator, bool product);
  
    void empty();

  };
}
#endif
