/* File: PriorTable.h */


#ifndef __PriorTable_h__
#define __PriorTable_h__



using namespace std;


namespace BIOS
{
 
  class PriorTable: public ProbabilityTable 
  {//
    // it is a 2D table with only the element at one side of a diagonal plus the diagonal

  public:
  
      PriorTable(ListOfAttributes* listOfAttributes, intList *varList, intList* dimensionList, intList*conditionalVarList, float alpha, BayesType bayesType):ProbabilityTable(varList, dimensionList)
{
float alphaDenominator;
int size;
try
{
size=getSize();
//cout <<"alpha" << alpha <<"bayestype" << bayesType;
alphaDenominator=listOfAttributes->getAlphaDenominator(bayesType, alpha, varList, conditionalVarList); 
//cout <<"alphaden is:" <<alphaDenominator <<"size is " << size;
for (int i=0;i<size;i++)
 setValue(i, Prob(alphaDenominator/(double)size, alphaDenominator));
totalSample=(int)alphaDenominator;
//cout <<*this;
}
catch (NonProb n){cout <<"\nError, size is " << size << ", den is " << alphaDenominator; n.PrintMessage("PriorTable(ListOfAttributes* listOfAttributes, intList *varList, intList* dimensionList, intList*conditionalVarList, float alpha, BayesType bayesType)");};
}
/*__________________________________________________________________________________*/

PriorTable(PriorTable& sourceTable):ProbabilityTable((ProbabilityTable&)sourceTable)
{
}
PriorTable(intList *varList, intList* dimensionList):ProbabilityTable(varList, dimensionList)
{
}

  };



 /*______________________________________________________*/

    ostream& operator<<(ostream& out, PriorTable& p)
  {
     char posChar[2000];
    int *pos=NULL;
    int pv;
    for (int i=0; i<p.getSize();i++)
    {
      pos=p.getPositions(i);
      out << "\nPrior (";
      strcpy(posChar,"\0");

      for (int j=0; j<p.varList->GetSize();j++)
      {


        sprintf(posChar, "%d= %d, ", p.varList->GetElement(j), pos[j]);
       out << "var ";
        out << string(posChar);
      }

      out << ") = ";


     // out << tos(p.getValue(pos));
        out << "[" << p.getValue(pos).getNumerator() <<", " << p.getValue(pos).getDenominator() <<"]";

      zaparr(pos);
    };
  
    return out;
  }







}
#endif
