/* File: ProbabilityTable.cpp */


#ifndef __ProbabilityTable_cpp__
#define __ProbabilityTable_cpp__


#include "ProbabilityTable.h"

using namespace std;

namespace BIOS
{



  /*______________________________________________________*/

  ProbabilityTable::ProbabilityTable()
  {
   PotentialTable* 
    this->conditionalVarList=NULL;
    conditionalSize=0;
    };
  /*______________________________________________________*/
/*
  ProbabilityTable::ProbabilityTable(VarsTable<Prob> &source):VarsTable<Prob>::VarsTable(source)
  {
    this->alpha=0;
    this->conditionalVarList=NULL;
  }
 /*_______________________________________________________________*/

  ProbabilityTable* ProbabilityTable::operator/(ProbabilityTable* source)
  {
  return this->product(source, false);

  };
  /*_______________________________________________________________*/

  ProbabilityTable* ProbabilityTable::operator*(ProbabilityTable* source)
  {
  return this->product(source, true);

  };
  /*______________________________________________________*/

  ProbabilityTable::ProbabilityTable(ProbabilityTable &source):VarsTable<Prob>(source)
  {
     if (source.conditionalVarList==NULL)
      this->conditionalVarList=NULL;
    else this->conditionalVarList=new intList(*source.conditionalVarList);
 this->conditionalSize=source.conditionalSize;

  };
/*______________________________________________________*/

  ProbabilityTable::ProbabilityTable(VarsTable<Prob> &source):VarsTable<Prob>(source)
  {
       this->conditionalVarList=NULL;
  this->conditionalSize=0;

  }
  /*______________________________________________________*/

  void ProbabilityTable::set(intList *conditionalVarList)
  {
if (conditionalVarList==NULL)
{
cout <<"Error, list is null in ProbabilityTable::set(intList *conditionalVarList)";
end();
}
    this->conditionalVarList=NULL;
      if (!varList->includes(conditionalVarList))
      {
        cout <<"Error in ProbabilityTable::ProbabilityTable, varList : " << varList->print() <<" does not include conditionalList " << conditionalVarList->print();
        end();
     }
      ProbabilityTable* marginal=this->marginalize(conditionalVarList);

//cout <<"por:" << *this;
//cout <<"\n cond var is " << *conditionalVarList;
   //       cout <<"marginal is " <<*marginal;
//end();
        ProbabilityTable* cP=*this/marginal;
//cout <<"\ndiv is " << *cP;
      for (int i=0;i<this->getSize();i++)
       setValue(i,cP->getValue(i));
       
     
       
      zap(cP);
      this->conditionalVarList=new intList(*conditionalVarList);
      this->conditionalSize=marginal->size;
      zap(marginal);

  }
  /*______________________________________________________*/

  ProbabilityTable::ProbabilityTable(intMLSample*  sample, intList *varList, intList *conditionalVarList, intList* dimensionList, float alphaParam, intSample::NodePointer first, intSample::NodePointer last)
      :VarsTable<Prob>::VarsTable(sample, varList, dimensionList, alphaParam, first, last)
  {
 // cout <<"NN";
if (conditionalVarList!=NULL)
   set(conditionalVarList);
else conditionalVarList=NULL;
//cout <<"ENN";
  };
  /*______________________________________________________*/

  ProbabilityTable::ProbabilityTable(floatMLSample*  sample, intList *varList, intList *conditionalVarList, intList* dimensionList, float alphaParam, floatSample::NodePointer first, floatSample::NodePointer last):VarsTable<Prob>::VarsTable(sample, varList, dimensionList, alphaParam, first, last)
  {
  if (conditionalVarList!=NULL)
   set(conditionalVarList);
else conditionalVarList=NULL;
  };

  /*______________________________________________________*/

  ProbabilityTable::ProbabilityTable(intList *varList, intList *conditionalVarList, intList* dimensionList, float alpha):VarsTable<Prob>::VarsTable(varList, dimensionList, alpha)
  {
  
     if (conditionalVarList!=NULL)
{
      this->conditionalVarList=new intList(*conditionalVarList);
       this->conditionalSize=1;
      for (int i=0;i<conditionalVarList->GetSize();i++)
this->conditionalSize=this->conditionalSize*dimensionList->GetElement(i);
}
    else    
{
this->conditionalVarList=NULL;
 this->conditionalSize=0;
}

  };
  /*______________________________________________________*/

ProbabilityTable::~ProbabilityTable(){zap(conditionalVarList);};
  /*_______________________________________________________________*/

ProbabilityTable::ProbabilityTable(VarsTable<double>& source):VarsTable<Prob>(source.varList, source.dimensionList, source.alpha)
{

  
 
       for (int i=0;i<source.getSize();i++)
         this->setValue(i, source.getProbability(i));

this->conditionalVarList=NULL;
this->conditionalSize=0;
this->totalSample=source.totalSample;
   

//cout <<"\nvalue is" << d2->getProbability(i).print();
//cout <<"\norigvalue is" << d2->getValue(i);
}
  /*_______________________________________________________________*/


  ProbabilityTable* ProbabilityTable::marginalize(intList* sourceVarList)
  {
      if (this->conditionalVarList!=NULL)
    {
      cout << "Error in ProbabilityTable::marginalize()";
      end();
    }

  VarsTable<double>* d=new VarsTable<double>(*(VarsTable<Prob>*)this), *d2=d->marginalize(sourceVarList);
//cout <<"\nbefore is" << *d;


//cout <<"\nmarginalvar is" << *d2;
  ProbabilityTable* result=new ProbabilityTable(*d2);
      zap(d);
zap(d2);

    return result;
  }
    /*_______________________________________________________________*/


  MultidimensionalTable* ProbabilityTable::project(intList* sourcePosList)
  {
   VarsTable<double>* d=new VarsTable<double>(*(VarsTable<Prob>*)this);
   
   intList* newPosList=varList->copyPositionsWithElementsIn(sourceVarList);
 
   MultidimensionalTable *d2=d->project(sourceVarList);

  ProbabilityTable* result=new ProbabilityTable(*d2);
      zap(d);
zap(d2);

    return result;
}
 
  /*_______________________________________________________________*/

  Prob ProbabilityTable::getProbability(int* values, bool plain)
  {
   if (isCompletelyMissing(values))
      return Prob(0,0);
    Prob p=getValue(values), p2;
    
if (p.isUndefined()) p2=p;
    else
    {
if (plain) p2= Prob(p.getNumerator(), p.getDenominator());
else
if (conditionalVarList==NULL) 
p2= Prob(p.getNumerator(), p.getDenominator(), alpha, size);
      else 
p2= Prob(p.getNumerator(), p.getDenominator(), alpha, size, conditionalSize);

    
return p2;
   }
 
  /*_______________________________________________________________*/


  void ProbabilityTable::normalize()
  {
    if (conditionalVarList==NULL)
     VarsTable<Prob>::normalize();
    else
    {
      cout <<"Error in ProbabilityTable::removeInconsistenciesWithEvidence, not implemented yet";
      end();
    }

  }
 
  /*_______________________________________________________________*/

  ProbabilityTable* ProbabilityTable::product(ProbabilityTable* source, bool product=true)
  {
    // product is false when division
   if (!product)
{
    if (varList!=source->varList && !varList->includes(source->varList))
    {
      cout <<"Error in ProbabilityTable::division";
      end();
    }
    if (source->conditionalVarList!=NULL || conditionalVarList!=NULL)
    {
      cout <<"Error 2 in ProbabilityTable::division";
      end();
    }
}
else // product
{
 if (source->conditionalVarList==NULL || conditionalVarList!=NULL)
    {
      cout <<"Error 1 in ProbabilityTable::product";
      end();
    }
    if (!varList->includes(source->conditionalVarList))
    {
      cout <<"Error 2 in ProbabilityTable::product";
      end();
    }
   
}


  VarsTable<double>* d=new VarsTable<double>(*(VarsTable<Prob>*)this), *d2=new VarsTable<double>(*(VarsTable<Prob>*)source), *d3=d->product(d2, product);

  ProbabilityTable* result=new ProbabilityTable(*d3);
      zap(d);
zap(d2);
zap(d3);

  
   if (!product) 
{
result->conditionalVarList=new intList(*source->varList);
// result->conditionalSize=source->size;

}
else 
{
result->conditionalVarList=NULL;
//result->conditionalSize=0;
}

return result;
    }
     /*______________________________________________________*/

    void ProbabilityTable::setProductValue(int pos, Prob first, Prob second, bool product)
    {
    if (!product)
     if (first.getDenominator()!=second.getNumerator() && !first.isUndefined())
          {
            cout <<"Error in ProbabilityTable::setProductValues, trying to divide " <<first.print() <<" by " << second.print();
            end();
          }
      VarsTable<Prob>::setProductValue(pos, first, second, product);
    };

  /*______________________________________________________*/

  string ProbabilityTable::print()
  {
    string result=string("");
    char posChar[2000];
    int *pos=NULL;
    int pv;
    for (int i=0; i<size;i++)
    {
      pos=getPositions(i);
      result=result+"\nProb (";
      strcpy(posChar,"\0");

      for (int j=0; j<varList->GetSize();j++)
      {
        sprintf(posChar, "%d= %d, ", varList->GetElement(j), pos[j]);
        result=result+"var ";
        result=result+string(posChar);
      }

      if (conditionalVarList!=NULL)
      {
        result=result+(") | Prob (");
        for (int j=0; j<conditionalVarList->GetSize();j++)
        {
          pv=varList->GetPos(varList->findElement(conditionalVarList->GetElement(j)));
          sprintf(posChar, "%d: %d, ", conditionalVarList->GetElement(j), pos[pv]);
          result=result+"var "+string(posChar);
        }
      }

      result=result+ ") = ";

      result+=getProbability(pos).print();

      zaparr(pos);
    };
    return result;

  };

      /*______________________________________________________*/
/*
  ostream& operator<<(ostream& out, ProbabilityTable& p)
  {
    out << p.print();
    return out;
  }
*/
}
#endif
