/* File: ProbabilityTable.h */


#ifndef __ProbabilityTable_h__
#define __ProbabilityTable_h__




using namespace std;


namespace BIOS
{

  class ProbabilityTable: public VarsTable<Prob> //
  {//
  // it allows conditional probabilities, while MultidimensionalTable<Prob> do not.
  private:


  public:

  //  ostream& operator<<(ostream& out);
     intList *conditionalVarList;
    int conditionalSize;
    string print();
    void normalize();
    ProbabilityTable(ProbabilityTable &source);
  ProbabilityTable(VarsTable<Prob> &source);
 ProbabilityTable(VarsTable<double>&source);

    ProbabilityTable(intMLSample*  sample, intList *varList, intList *conditionalVarList, intList* dimensionList, float alphaParam, intSample::NodePointer first=NULL, intSample::NodePointer last=NULL);
    ProbabilityTable(floatMLSample*  sample, intList *varList, intList *conditionalVarList, intList* dimensionList, float alphaParam, floatSample::NodePointer first=NULL, floatSample::NodePointer last=NULL);
    void set(intMLSample*  sample, intList *varList, intList *conditionalVarList, intList* dimensionList, float alphaParam, intSample::NodePointer first=NULL, intSample::NodePointer last=NULL);
  //  ProbabilityTable(ProbabilityTable<Prob> &source);
    ProbabilityTable::ProbabilityTable(intList *varList, intList *conditionalVarList, intList* dimensionList, float alpha);
    ProbabilityTable();
     ~ProbabilityTable();
    ProbabilityTable* marginalize(intList* sourceVarList);
    Prob getProbability(int* values);
    void set(intList* conditionalVarList);
    ProbabilityTable* operator*(ProbabilityTable* source);
    ProbabilityTable* product(ProbabilityTable* source, bool product);
    ProbabilityTable* operator/(ProbabilityTable* source);
    void setProductValue(int pos, Prob first, Prob second, bool product);
    MultidimensionalTable<Prob>* project(intList* sourcePosList);

  //  void setProductValue(int pos, T numerator, T denominator, bool product);


  };
}
#endif
