#ifndef Selection_cpp
#define Selection_cpp



#include "Selection.h"//
//////

//using namespace UTILS;


namespace BIOS {


  /*____________________________________________________________________________________________*/

  Selection::~Selection()
  {
zap(allAttributes);
zap(correlation);
zap(discSample);
  };
   /*____________________________________________________________________________________________*/

  Selection::Selection(floatMLSample* sample, int classNum, VerbosityClass verbosity)
  {
selModeClass=NULL;
this->verbosity=verbosity;
   this->classNum=classNum;
 //  this->listOfAttributes=sample->listOfAttributes; 
this->sample=sample;
allAttributes=new intList(sample->listOfAttributes->size());
discSample=sample->getDiscreteSample();
  }
   /*____________________________________________________________________________________________*/

  intList* Selection::getSelection(SelMode selMode, AlgType algType, LossFunction* lossFunction, floatList* selectionParameters, char* selectionFile, floatList* algorithmParameters)
  {
  try{
  int m, K;
  double threshold;
//intList *selectionList=NULL;
selModeClass= new SelModeClass(selMode, selectionParameters);
//if (positions==NULL) this->positions=NULL;
//else this->positions=positions;
intList *selectedAttributes=NULL, *selectedAttributes2=NULL;
  // listOfAttributes->removeSelection();

correlation=NULL; 
double* qualities;
if (selMode==forwardHillclimbingCorrelation)
correlation=new Correlation<int>(classNum, discSample); 

   switch (selMode)
    {
    case todos: sample->listOfAttributes->selectAll(); break;
    case forwardHillclimbingSRM: 
    case forwardHillclimbingERM: 
    case forwardHillclimbingMDL:
    case forwardHillclimbingBayesScore: 
    case forwardHillclimbingEntropy: 
    case forwardHillclimbingCorrelation:
    case forwardHillclimbingWrapper: 
  	selectedAttributes=hillClimbingSelection(selMode, true,  algType, algorithmParameters, lossFunction); 
//listOfAttributes->select(selectedAttributes); 
	break;
    case oneByOneBayesScore: 
    case oneByOneEntropy:
    case oneByOneMDL:
     selectedAttributes=classAssociationSelection(selMode, selectionParameters);
break;
    case oneByOneAndConditionalBayesScore: 
    case oneByOneAndConditionalEntropy:
    case oneByOneAndConditionalMDL:
     selectedAttributes=classAssociationSelection(selMode, selectionParameters);
     selectedAttributes=classAssociationSelection(selMode, selectionParameters, selectedAttributes);     
break;
    case oneByOneAndPairsBayesScore: 
    case oneByOneAndPairsMDL:
     selectedAttributes=classAssociationSelection(selMode, selectionParameters);
     selectedAttributes2=classAssociationByPairsSelection(selMode, selectionParameters, selectedAttributes);     
     selectedAttributes->paste(selectedAttributes2);
break;
case oneByOneWrapper:
selectedAttributes=oneByOneWrapperSelection(selMode, algType, algorithmParameters, lossFunction);
    break;  
    case manual: 
	if (selectionParameters==NULL) 
	{cout <<"Error 1 in manual selection"; exit(0);}; 
        selectedAttributes= selectionParameters->getIntList();
	//sample->listOfAttributes->select(selectedAttributes); 
       // selectedAttributes=new intList(*selectionList);
//zap(listOfAttributes);
        break;
    case treeWrapper: selectedAttributes=treeWrapperSelection(lossFunction, algType, algorithmParameters);break;
    case reliefF: 
    m=discSample->sample->size(), K=10;
    if (selectionParameters->size()>0 && selectionParameters->getElement(0)!=0) m= (int)selectionParameters->getElement(0);
    if (selectionParameters->size()>1) K= (int)selectionParameters->getElement(1);
    threshold=1/sqrt((double)m);
    if (selectionParameters->size()>2) threshold= selectionParameters->getElement(2);
    qualities=discSample->getAttributesQualityUsingReliefF(m, K, classNum);
    selectedAttributes=new intList();
   // cout <<"thres:" << threshold;
    for (int i=0;i<discSample->listOfAttributes->size();i++)
    {
    if (qualities[i]>threshold) selectedAttributes->insertElement(i);
    //cout <<"\n quant:" << qualities[i];
    }
    zaparr(qualities);
    break;
    case manualFromFile: 
        SelSubmodeClass selSubmodeClass=SelSubmodeClass((SelSubmode)(int)selectionParameters->getFirstElement(), selectionFile);
        if (selectionFile==NULL) 
	{cout <<"Error 2 in manual selection"; exit(0);}; 
 	switch (selSubmodeClass.selSubmode)
	{
	case rows: // lines
        selectedAttributes=selSubmodeClass.rowSelectionStartingAt1(classNum);
	break;
	case rowsStartingAt0: // lines
        selectedAttributes=selSubmodeClass.rowSelection(classNum);
	break;
	case blocks: // blocks
        selectedAttributes=selSubmodeClass.blockSelection(classNum);
	}
        break;
// case filterKernel: selectedAttributes=filterKernelSelection();break;
      }

zap(selModeClass);
return selectedAttributes;
}
catch (ZeroValue zv){zv.PrintMessage("Selection::getSelection");end();}

};

/*____________________________________________________________________________________________*/

intList*  Selection::classAssociationSelection(SelMode selMod, floatList* selectionParameters, intList *originalSelectedAttributes)
{
bool conditional=false;
if (originalSelectedAttributes!=NULL) conditional=true;
sample->listOfAttributes->selectAll(); 
intList *selectedAttributes;
intList* vars=new intList(), *vars2=NULL, *vars3=NULL, *allVars=new intList();

if (!conditional) 
{
selectedAttributes=new intList(); selectedAttributes->insertElement(classNum);
allVars->insertElement(classNum);
vars3=new intList();
vars3->insertElement(1);
}
else 
{
selectedAttributes=new intList(*originalSelectedAttributes);
allVars->copyPaste(originalSelectedAttributes);
vars2=new intList();
vars2->insertElement(originalSelectedAttributes->size());
vars3=new intList(originalSelectedAttributes->size()+1);
vars3->removeNode(0);
} 
vars->insertElement(0);

intMLSample* narrowSample=NULL;
DependenceMeasure<int>* dependenceMeasure=NULL;
float alpha=0;
BayesType bayesType=MLE;
if (selectionParameters->size()>=1) bayesType=(BayesType)(selectionParameters->getElement(0));
if (selectionParameters!=NULL && selectionParameters->size()>=2) alpha=selectionParameters->getElement(1);
//cout <<"bayesType:" << bayesType <<", alpha: " << alpha;
double measureOnlyClass;
switch(selMod)
{
case oneByOneEntropy: 
case oneByOneAndConditionalEntropy: dependenceMeasure=new Entropy<int>(bayesType, alpha); break;
case oneByOneBayesScore:  
case oneByOneAndPairsBayesScore: 
case oneByOneAndConditionalBayesScore: dependenceMeasure=new BayesScore<int>(bayesType, alpha); break;
case oneByOneMDL:  
case oneByOneAndConditionalMDL:
case oneByOneAndPairsMDL:
dependenceMeasure=new MDL<int>(bayesType, alpha); break;
default: cout <<"Selection::classAssociationSelection not implemented yet"; end();
}


for (int i=0;i<sample->listOfAttributes->size();i++)
if ((!conditional && i!=classNum) || (conditional && originalSelectedAttributes->findElement(i)==NULL))
{
allVars->insertElement(i);
narrowSample=discSample->copyColumns(allVars, false);

//narrowSample->removeMissingPatterns();// not needed, as it is done by the DependenceMeasure class
measureOnlyClass=dependenceMeasure->getMeasure(narrowSample, vars, vars2);




if (dependenceMeasure->better(dependenceMeasure->getMeasure(narrowSample, vars, vars3),  measureOnlyClass))
selectedAttributes->insertElement(i);
allVars->Pop();
zap(narrowSample);
}
zap(allVars);
zap(vars);
zap(vars2);
zap(vars3);
zap(originalSelectedAttributes);
return (selectedAttributes);
}
/*____________________________________________________________________________________________*/

intList*  Selection::classAssociationByPairsSelection(SelMode selMod, floatList* selectionParameters, intList *originalSelectedAttributes)
{
sample->listOfAttributes->selectAll(); 
intList *selectedAttributes;
intList* vars=new intList(), *vars2=NULL, *allVars=new intList();

selectedAttributes=new intList(); 
allVars->insertElement(classNum);
vars2=new intList();
vars2->insertElement(0);
vars2->insertElement(2);
vars->insertElement(1);

intMLSample* narrowSample=NULL;
DependenceMeasure<int>* dependenceMeasure=NULL;
float alpha=0;
BayesType bayesType=MLE;
if (selectionParameters->size()>=1) bayesType=(BayesType)(selectionParameters->getElement(0));
if (selectionParameters!=NULL && selectionParameters->size()>=2) alpha=selectionParameters->getElement(1);
double measureOnlyVar;
switch(selMod)
{
case oneByOneAndPairsBayesScore: dependenceMeasure=new BayesScore<int>(bayesType, alpha); break;
case oneByOneAndPairsMDL: dependenceMeasure=new MDL<int>(bayesType, alpha); break;
default: cout <<"Selection::classAssociationByPairsSelection not implemented yet"; end();
}
bool first, second;

for (int i=0;i<sample->listOfAttributes->size();i++)
if (i!=classNum)
{
allVars->insertElement(i);
first=false;
if (originalSelectedAttributes!=NULL && originalSelectedAttributes->findElement(i)!=NULL)
 first=true; 
for (int j=i+1;j<sample->listOfAttributes->size();j++)
if (j!=classNum)
{
second=false;
if (originalSelectedAttributes!=NULL && originalSelectedAttributes->findElement(j)!=NULL) 
second=true;
if (!first || !second)
{
allVars->insertElement(j);
narrowSample=discSample->copyColumns(allVars, false);
//narrowSample->removeMissingPatterns();// not needed, as it is done by the DependenceMeasure class
measureOnlyVar=dependenceMeasure->getMeasure(narrowSample, vars);
if (dependenceMeasure->better(dependenceMeasure->getMeasure(narrowSample, vars, vars2),  measureOnlyVar))
{
if (!first && selectedAttributes->findElement(i)==NULL) selectedAttributes->insertElement(i);
if (!second && selectedAttributes->findElement(j)==NULL) selectedAttributes->insertElement(j);
}
//end();
allVars->Pop();
zap(narrowSample);
}
}
allVars->Pop();
}
zap(allVars);
zap(vars);
zap(vars2);
return (selectedAttributes);
}
 /*____________________________________________________________________________________________*/

intList* Selection::treeWrapperSelection(LossFunction* lossFunction, AlgType algType, floatList* algorithmParameters)
{
// It only has sense whenever attributes are ordered, so .pos must exists.
// It returns a list with the set of consecutive input attributes with the highest accuracy.
// It uses a binary-search selection beginning with the sets of attributes with less and more of half of the total distance to the class.

floatList* currentVars=new floatList();
float currentDistanceThreshold=sample->listOfAttributes->getMaxBasicDistance(classNum);
Pair<int>  extremes=sample->listOfAttributes->getExtremes(classNum, currentDistanceThreshold);
for (int i=extremes.First; i<=extremes.Second;i++)
 currentVars->insertElement((float)i);



ClassifierTest* classifierTest=new ClassifierTest(sample, NULL, NULL, tCrossValidation, 2, verbosity, classNum, lossFunction);
ClassificationResults cr=classifierTest->getAveragedAccuracy(algType, NoDiscretization, algorithmParameters, NULL, manual, currentVars, NULL);


treeWrapperSelection(lossFunction, currentDistanceThreshold/2, currentDistanceThreshold, currentVars, algType, algorithmParameters, cr, classifierTest);

zap(classifierTest);
//if (currentVars==NULL) cout <<"null"; else cout <<"nonull";
//cout <<"\n\nresults:\n" << *currentVars <<"\n";
intList* currentIntList=currentVars->getIntList();

zap(currentVars);
//cout <<*currentIntList <<"\n";
//end();
return currentIntList;
}

  /*____________________________________________________________________________________________*/

void Selection::treeWrapperSelection(LossFunction*& lossFunction, float newDistanceThreshold, float currentDistanceThreshold, floatList*& currentVars, AlgType& algType, floatList*& algorithmParameters, ClassificationResults currentResult, ClassifierTest*& classifierTest)
{
// It only has sense whenever attributes are ordered, so .pos must exists.
// It returns a list with the set of consecutive input attributes with the highest accuracy.
// It uses a binary-search selection beginning with the sets of attributes with less and more of half of the total distance to the class.


floatList* newVars=new floatList();
Pair<int>  extremes=sample->listOfAttributes->getExtremes(classNum, newDistanceThreshold);
for (int i=extremes.First; i<=extremes.Second;i++)
 newVars->insertElement((float)i);


if (*currentVars!=*newVars)
{
//cout <<"\ncurrentVars:" << *currentVars;
//cout <<"\newVars:" << *newVars;
ClassificationResults newResults;
newResults=classifierTest->getAveragedAccuracy(algType, NoDiscretization, algorithmParameters, NULL, manual, newVars, NULL);
//cout <<"\nacc currentResults:" << currentResult.set.averageAccuracy;
//cout <<"\nacc newResults:" << newResults.set.averageAccuracy;

int prod=1;
if (abs(currentVars->size()-newVars->size())>1)
if (newResults.set.averageAccuracy!=currentResult.set.averageAccuracy) 
if (newResults.set.averageAccuracy>currentResult.set.averageAccuracy) 
{
if (currentVars->size()<newVars->size()) prod=3;
zap(currentVars);
currentVars=new floatList(*newVars);
treeWrapperSelection(lossFunction, newDistanceThreshold*prod/2, newDistanceThreshold, currentVars, algType, algorithmParameters, newResults, classifierTest);
}
else // worse
{
if (currentVars->size()>newVars->size()) prod=3;
treeWrapperSelection(lossFunction, newDistanceThreshold*prod/2, currentDistanceThreshold, currentVars, algType, algorithmParameters, currentResult, classifierTest);
}
}
zap(newVars);
}
  /*____________________________________________________________________________________________*/

intList*  Selection::oneByOneWrapperSelection(SelMode selMod, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction)
{
intList *selectedAttributes=NULL;
bool reachedThreshold=false;
int newSelection;
float currentThreshold=maxreal;

selectedAttributes=new intList();
selectedAttributes->insertElement(classNum);


newSelection=findAttribute(selectedAttributes, selMod, true, currentThreshold, algType, algorithmParameters, lossFunction);
//cout <<"HOLA2\natt list is :" << *listOfAttributes;
selectedAttributes->insertElement(newSelection);

//end();
return selectedAttributes;
}
  /*____________________________________________________________________________________________*/

intList*  Selection::hillClimbingSelection(SelMode selMod, bool forward, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction)
{
intList *selectedAttributes=NULL;
bool reachedThreshold=false;
int newSelection;
float currentThreshold=maxreal;
if (!forward) 
selectedAttributes=new intList(*allAttributes);
else 
{
selectedAttributes=new intList();
selectedAttributes->insertElement(classNum);
}
int iteration=0;
do
{
newSelection=findAttribute(selectedAttributes, selMod, forward, currentThreshold, algType, algorithmParameters, lossFunction);
//cout <<"HOLA2\natt list is :" << *listOfAttributes;
if (newSelection==-1) reachedThreshold=true;
else if (forward) selectedAttributes->insertElement(newSelection);
else selectedAttributes->removeNode(selectedAttributes->findElement(newSelection)); 
iteration++;
//cout <<"\nit: " << iteration <<"\n";
}
while ((iteration<(sample->listOfAttributes->size()-1)) && !reachedThreshold);

//end();
return selectedAttributes;
}
  /*____________________________________________________________________________________________*/

int Selection::findAttribute(intList* selectedAttributes, SelMode selMod, bool forward, float &currentThreshold, AlgType algType, floatList* algorithmParameters, LossFunction* lossFunction)
{
intList* newList=NULL, *remainingAttributes=allAttributes->copyElementsNotIn(selectedAttributes);
int remaining=remainingAttributes->size(), att, selectedAttribute=-1;
float newThreshold; //, partialThreshold=maxreal;
if (!forward) remaining=selectedAttributes->size()-1;

for (int i=0; i<remaining; i++)
{
newList=new intList(*selectedAttributes);
if (forward)
{
 att=remainingAttributes->getElement(i);
 newList->insertElement(att);
}
else if (att!=classNum) att=newList->removeNode(i);
sample->listOfAttributes->select(newList);
newThreshold=getThreshold(selMod, newList, algType, lossFunction, algorithmParameters);
if (currentThreshold>newThreshold)
{
currentThreshold=newThreshold;
selectedAttribute=att;
}
//cout <<"\nFind attributs:\nSelected attrs:" << *selectedAttributes << ", PLUS" << selectedAttribute;

//cout <<"\nFind attributs :\n" << * listOfAttributes;

sample->listOfAttributes->removeSelection();
zap(newList);
}
return selectedAttribute;
}
  /*____________________________________________________________________________________________*/

double Selection::getThreshold(SelMode selMode, intList* selectedAtts, AlgType algType, LossFunction* lossFunction, floatList* algorithmParameters)
{
MeasureType measureType;
ClassificationResults result;
intList *conditionalList=NULL, *varList=NULL;
ClassifierTest* classifierTest=NULL;
//MLSample<float>* trainingSample=NULL, *testSample=NULL;
//intList* indexVector=NULL;
//Sampling* sampling=NULL;

switch (selMode)
{
case forwardHillclimbingSRM: measureType=mSRM; break;
case forwardHillclimbingERM: measureType=mERM; break;
case forwardHillclimbingMDL: measureType=mMDL; break;
case forwardHillclimbingEntropy: measureType=mEntropy; break;
case forwardHillclimbingBayesScore: measureType=mBayesianScore; break;
case forwardHillclimbingCorrelation: measureType=mCorrelation; break;
}
floatList* selectedAtts2=NULL;



float measure;
switch (selMode)
{
case forwardHillclimbingSRM: 
case forwardHillclimbingERM: 
case forwardHillclimbingMDL: 
case forwardHillclimbingEntropy: 
case forwardHillclimbingBayesScore:
conditionalList=new intList(*selectedAtts);
varList=new intList();
conditionalList->removeNode(conditionalList->findElement(classNum));
varList->insertElement(classNum);

//float alpha;
//if (algorithmParameters->getFirst()==NULL) alpha=0;
//else alpha=(float)algorithmParameters->getFirstElement();

measure=discSample->getMeasure(measureType, varList, conditionalList);
zap(varList);
zap(conditionalList);
if (forwardHillclimbingBayesScore) measure=-measure;
return measure;
break;
case forwardHillclimbingCorrelation:
varList=new intList(*selectedAtts);
varList->removeNode(varList->findElement(classNum));
measure=correlation->getMeasure(varList);
zap(varList);
return -measure;
break;
case forwardHillclimbingWrapper: 
classifierTest=new ClassifierTest(sample, NULL, NULL, tCrossValidation, 2, verbosity, classNum, lossFunction);
//if (sample->listOfAttributes->isDiscretized()) cout <<"disct"; else cout <<"no disc";
selectedAtts2=selectedAtts->getFloatList();
result=classifierTest->getAveragedAccuracy(algType, NoDiscretization, algorithmParameters, NULL, manual, selectedAtts2, NULL);

zap(classifierTest);
zap(selectedAtts2);
//zap(trainingSample);
//zap(testSample);
return 1-result.set.averageAccuracy;
break;
default: cout <<"Error in Selection::getThreshold"; end();
break;
}
}
  /*____________________________________________________________________________________________*/
/*
intList*  Selection::wrapperSelection()
{
// Returns a list with the set of consecutive input attributes with the highest accuracy.
// It uses a forward selection beginning with the attribute in the middle.
 
bool encontrado;
unsigned int TotalInputAttributes=listOfInputAttributes->size(), i;
ListOfInputAttributes *listOfSelectedAttributes, *copyListOfInputAttributes;
*copyListOfInputAttributes=*listOfInputAttributes;
listOfSelectedAttributes= new ListOfInputAttributes();
ListOfInputAttributes::iterator pA;
Attribute attribute;
do 
{
encontrado=false;
pA=copyListOfInputAttributes->getFirst;
while (pA!=NULL)
{
 listOfSelectedAttributes->InsertElement(copyListOfInputAttributes->getElement(pA));
 texto2=ProjectSample(texto, listOfSelectedAttributes);
 classifier=new Classifier(texto2, dependiente, parameters);
 TasaAciertos=classifier->GetAveragedAccuracy(testMethod);  
 attribute=listOfSelectedAttributes->PopElement();
 if (TasaAciertos>MaxTasa) 
 { 
  MaxTasa=TasaAciertos; 
  encontrado=true;
  attNumber=copyListOfInputAttributes->GetPos(pA);
 } 
 pA=copyListOfInputAttributes->getNext(pA);  
}  
 if (encontrado) 
{
 listOfSelectedAttributes->InsertElement(copyListOfInputAttributes->getElement(GetNode(attNumber));
 copyListOfInputAttributes->RemoveElement(copyListOfInputAttributes->getElement(GetNode(attNumber));
}
}
 while (encontrado); //
};

/*____________________________________________________________________________________________*/

  
}
#endif
