/***************************************************************************
 *   Copyright (C) 2005 by M. Mar Abad Grau 				   *
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef __InputMI_UI_cpp__
#define __InputMI_UI_cpp__



#include "InputMI_UI.h"//



namespace BIOS
{

  /*____________________________________________________________________*/
/*
  void InputMI_UI::printHelp(char* programName)


  {
    cout << "\nUsage: " << programName <<" <INPUTFILE> [<OPTION>] ...";
    //cout <<"\nINPUTFILE:\t
    cout <<"\n\nOPTIONS:";
    cout <<"\n -h\t help";
    cout <<"\n\n -a=[0..2]\tMISSING IMPUTATION ALGORITHM \n\t\t";
    cout << "0 (default): NB1  \n\t\t";
    cout <<"1: c4.5, \n\t\t2: continuous c4.5";

 cout <<"\n\n -v=[char,...]\t VERBOSITY\n\t\twith char having the following values: \n\t\ta: accuracies, \n\t\tc: configuration, \n\t\td: attribute description, \n\t\tD: attribute discretization, \n\t\tS: selected attributes\n\t\ts: structure, \n\t\tp: parameters, \n\t\ti: individual test results, \n\t\tt: true/predicted value table, \n\t\te: Euclidean distance, \n\t\tr: Selection scores, \n\t\to: Show progress (default) \n\t\tm: Complete sample (default)";
    cout <<"\n";
    cout <<"\n";

  }

  /*____________________________________________________________________*/

  void InputMI_UI::readInputFile()
  {
 strcpy(filename, argv[1]);
}
 /*____________________________________________________________________*/

  void InputMI_UI::readClassPosition()
  {
selectedClassPosition=-1;

}
 /*____________________________________________________________________*/
/*
  void InputMI_UI::readVerbosity()
  {

verbosity.verbosityR.progress=true;
}

 /*____________________________________________________________________*/
/*
  void InputMI_UI::readLossFunction()
  {
useFileForLossFunction=false;
}

 /*____________________________________________________________________*/
/*
  void InputMI_UI::readSelection()
  {
selection->insertElement(325);//
}
/*____________________________________________________________________*/
/*
  void InputMI_UI::readDiscretization()
  {
discretization->insertElement((float)7);//Fayyad and Irani
}
/*____________________________________________________________________*/

  void InputMI_UI::readTestMode()
  {
 test->insertElement(3);//training

}

/*____________________________________________________________________*/
/*
  void InputMI_UI::readAlgorithm()
  {
int a=getArgument('a');
if (a==nil || a==0) 
{
algorithmParameters->insertElement(0);//naive bayes
algorithmParameters->insertElement(0); // no direct method
algorithmParameters->insertElement(1); // Bayes
algorithmParameters->insertElement(1); // alpha
}
else
if (a==1) algorithmParameters->insertElement(4);//discrete C4.5
else if (a==2) algorithmParameters->insertElement(5);//continuous c4.5
else
{
     cout <<"Error in argument for -a. It should be 0, 1 or 2. \n";
            printHelp("InputMI_UI");
            end();
}
}
 /*____________________________________________________________________*/

  void InputMI_UI::readMetadata()
  {
metadata=1;
}

 /*____________________________________________________________________*/
/*
  void InputMI_UI::readDecision()
  {
stochastic=1;
}


  /*_________________________________________________________________________*/

  bool InputMI_UI::isAModifier(char* c)
  {
    if (strlen(c)<2) return false;

    if (c[0]=='-' && (c[1]=='a' || c[1]=='h' || c[1]=='D') && c[2]=='=')
      return true;
    else return false;
  }
   
  /*_________________________________________________________________________*/

  InputMI_UI::InputMI_UI(int argc, char *argv[], char* programName)
  {
discretization=new floatList();
selection=new floatList();
test=new floatList();
algorithmParameters=new floatList();
verbosity=VerbosityClass();
this->programName=programName;
if (argc==1 || (argc>=2 && isAModifier(argv[1])) || (argc>=2 && argv[1][0]=='-'))
    {
      printHelp(programName);
      exit(0);
    };



this->argc=argc;
this->argv=argv;
readInputFile();
readDiscretization();
readSelection();
readAlgorithm();
readTestMode();

readVerbosity();
//cout << verbosity;
readClassPosition();
readLossFunction();
readDecision();
//cout << stochastic" 
 discMode=(DiscMode) (int) discretization->removeNode((int)0);
     selMode=(SelMode) (int) selection->removeNode((int)0);
     algType= (AlgType) (int) algorithmParameters->removeNode((int)0);
     testMode=(TestMode) (int) test->removeNode((int) 0);
    if (test->getFirst()!=NULL)
      numberOfFolds=(TestMode) (int) test->removeNode((int) 0);
     algTypeClass=new AlgTypeClass(algType, algorithmParameters);
     testModeClass=new TestModeClass(testMode, numberOfFolds);
     discModeClass=new DiscModeClass(discMode);
     selModeClass=new SelModeClass(selMode, selection);


if (verbosity.verbosityR.configuration)
{
if (stochastic) cout <<"Decision: \t\t\tStochastic";
else cout <<"Decision: \t\t\tDeterministic";
       cout << *algTypeClass;
      cout << testModeClass->print();
      cout << discModeClass->print();
 	cout << *selModeClass;// << ", params: " << *selection;
if (selModeClass->selMode==manualFromFile) cout << selSubmodeClass;
cout << verbosity;
cout <<"\n";
cout <<"Class attribute: \t\t";
switch(selectedClassPosition)
{
 case -3: cout <<"All attributes except the last used as classes"; break;
case -2: cout <<"Only the last attribute used as class"; break;
case -1: cout <<"All attributes used as classes"; break;
 default: cout << selectedClassPosition; break;
 }
}
}
 /*_________________________________________________________________________*/

  InputMI_UI::~InputMI_UI()
  {
}
}

#endif




