/***************************************************************************
 *   Copyright (C) 2005 by M. Mar Abad Grau 				   *
 *   mabad@ugr.es  						           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
/* File: ClassClassAttribute.cpp */


#ifndef __InputTUI_h__
#define __InputTUI_h__



//using namespace UTILS;

namespace BIOS {


class InputTUI {

public:


int argc;
char** argv;

char filename[256];
bool useFileForLossFunction;
floatList* discretization, *test, *algorithmParameters;
floatList * selection;
VerbosityClass* verbosity;
int selectedClassPosition;
int metadata;
unsigned int haplotypes, salida;
int foldbase;
int stochastic;


    string programName;
    DiscMode discMode;
    SelMode selMode;
    AlgType algType;
    TestMode testMode;  
    int numberOfFolds;
    AlgTypeClass* algTypeClass;
    TestModeClass* testModeClass;
    DiscModeClass* discModeClass;
    SelModeClass* selModeClass;
    SelSubmodeClass *selSubmodeClass;
//void lectura_argumentos(int argc, char *argv[]);

char* readFileName(); 

unsignedIntVector* GetSelected(char* filename, unsigned int cm, unsigned int totalmuestras);

public:

//InputTUI(){};
InputTUI(int argc, char *argv[], const char* programName);
~InputTUI();
int getTotalArguments(char a);
bool isAModifier(char* c);
virtual void printHelp(const char* programName);
bool isAValue(char* c);
bool isHelp(char* c);
void readDecision();
void readInputFile();
void readClassPosition();
void readVerbosity();
void readSelection();
void readDiscretization();
void readTestMode();
void readAlgorithm();
void readLossFunction();
void readMetadata();
int getArgument(char a);
string getStringArgument(char a);
int getArgumentPosition(char a);
//void readPositions(char* filename);


};

ostream& operator<<(ostream& out, InputTUI& p);


}


#endif





