#ifndef Sample_cpp//
#define Sample_cpp//

#include "Sample.h"

namespace BIOS 
{

/*_________________________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>::Sample(Sample<SuperCont, Cont, T> &source, typename Sample<SuperCont, Cont, T>::iterator first, typename Sample<SuperCont, Cont, T>::iterator last):SuperCont(source, first, last){};


/*_________________________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>::Sample(Sample<SuperCont, Cont, T> &source, Sampling* sampling):SuperCont(source, sampling){};

/*_________________________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>::Sample(const char* filename, const char* tokens, char outputSeparator, char leftDelimiter, char rightDelimiter):SuperCont( outputSeparator, leftDelimiter, rightDelimiter)
{
    this->getInfo(filename, tokens);
};
/*_________________________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>::Sample(Sample<SuperCont, Cont, T> &source):SuperCont(source){};

/*________________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>* Sample<SuperCont, Cont, T>::clone()
{
   return new Sample((Sample&)*this);
};

/*___________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>* Sample<SuperCont, Cont, T>::copyColumns(intList* posList, bool orderedByThis)//
{
   Sample<SuperCont, Cont, T>* sample2=new Sample();
   typename Sample<SuperCont, Cont, T>::iterator p=this->getFirst();
   Cont* pattern, *sourcePattern;
   while (p!=this->end())
   {
      sourcePattern=this->getElement(p);
      pattern=sourcePattern->copyElementsWithPositionsIn(posList, orderedByThis);
      sample2->insertElement(pattern);
      p=this->getNext(p);
   }
   return sample2;
};

/*___________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>* Sample<SuperCont, Cont, T>::copyColumns(intSet* posSet, bool orderedByThis)//
{
intList *posList=new intList(*posSet);
   Sample<SuperCont, Cont, T>* sample=this->copyColumns(posList, orderedByThis);
zap(posList);
   return sample;
};
/*___________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>* Sample<SuperCont, Cont, T>::copyColumns(int* pos, int size)//
{
intList *posList=new intList(pos, size);
   Sample<SuperCont, Cont, T>* sample=this->copyColumns(posList, true);
zap(posList);
   return sample;
};

/*_________________________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Cont* Sample<SuperCont, Cont, T>::flatSample()
{
Cont* result=new Cont();
for (typename Sample<SuperCont, Cont, T>::iterator it=this->begin(); it!=this->end(); it++)
result->copyPaste(*it);
return result;
};

/*_________________________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
void Sample<SuperCont, Cont, T>::insertElement(Cont* element, typename Sample<SuperCont, Cont, T>::iterator it)
{
insert(it, element);
};




/*_________________________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
void Sample<SuperCont, Cont, T>::insertElement(Cont* element)
{
insertElement(element, this->end());
};

	/*____________________________________________________________ */
	
	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>::~Sample()
			{
			for (typename Sample<SuperCont, Cont, T>::iterator it=this->begin(); it!=this->end(); ++it)
                         zap(this->getElement(it));
			};

	/*____________________________________________________________ */
	/*
	template< class SuperCont, class Cont, class T>
 void Sample<SuperCont, Cont, T>::order(bool ascendant)
	{
Container<SuperCont, Container<Cont, T, STL2B >*, STL2 >::order(ascendant);

	}

    	/*___________________________________________________________________________________*/
/*
  	template< class SuperCont, class Cont, class T> typename Sample<SuperCont, Cont, T>::iterator  Sample<SuperCont, Cont, T>::findElementContainingInternalElement(typename Cont<T, STL2B<T> >::iterator element)//
  {
typename Sample<SuperCont, Cont, T>::iterator p=this->GetFirst();
 Cont<T, STL2B<T> > * secondContainer;
 while (p!=this->end())
{
	 secondContainer=getElement(p);
  if (secondContainer->findElement(element)!=secondContainer->end()) return p;
p=this->GetNext(p);
}
return end();

  };

  /*___________________________________________________________________________________*/
/*
	template< class SuperCont, class Cont, class T>
intList* Sample<SuperCont, Cont, T>::getOptimalBlanket (Container<Cont, T>* otherSet)
{

  Sample<SuperCont, Cont, T>* temporal=Sample<SuperCont, Cont, T>(*this);
  typename Sample<SuperCont, Cont, T>::iterator p;
  Container<Cont, T>* newSet, *temporalArgument=new Container<Cont, T>(*otherSet), *foundElements;
  int max;
  intList* result=new intList();
  while (temporalArgument->size()>0)
  {
     max=temporal->getOptimalSingleBlanket(temporalArgument);
     result->insertElement(max);
     foundElements=temporalArgument->copyElementsIn(temporal->getElement(max));
     temporalArgument->removeElementsIn(temporal->getElement(max));
     p==this->GetFirst();
     while (p!=this->end())
     {
        temporal->getElement(p)->removeElementsIn(foundElements);
        p=this->getNext(p);
     }
     zap(foundElements);
  }
  zap(temporalArgument);
  zap(temporal);
  return result;
}
  
/*___________________________________________________________________________________*/
/*
	template< class SuperCont, class Cont, class T>
int Sample<SuperCont, Cont, T>::getOptimalSingleBlanket (Container<Cont, T>* simpleContainer)
{
  // it returns the instance position in the sample with the shortest size that cointains all values in simpleContainer
  typename Sample<SuperCont, Cont, T>::iterator p=this->GetFirst();
  int max, i=0;
  Container<Cont, T>* newSet, *currentMaxSet;
 
  while (p!=this->end())
  {
    newSet=this->getElement(p)->copyElementsIn(simpleContainer);
    if (newSet->size()>currentMaxSet->size() || (newSet->size()==currentMaxSet->size() && this->getElement(p)->size()<this->getElement(max)->size()))
    {
      max=i;
      zap(currentMaxSet);
      currentMaxSet=new Container<Cont, T*>(*newSet);
    }
    zap(newSet);
    p=this->getNext(p);
    i++;
  }
  zap(currentMaxSet);
  return i;
}

Sample<
Container<vector<Container<vector<T>, T>*>,Container<vector<T>, T>*>,
Container<vector<T>, T>, 
T
>



/*_____________________________________________________________*/

	template< class SuperCont, class Cont, class T>
int Sample<SuperCont, Cont, T>::getOptimalBlanket (Cont* simpleContainer)

 // returns the position in the sample which better covers otherSet, -1 if none
  {
  if (simpleContainer==NULL || simpleContainer->size()==0) return -1;
  int minSize=MAXINT, chosenPos=-1;
  Cont* newSet=NULL;
//cout <<"\nOptimal blanket of " << *otherSet << " in " << *this;
//cout <<"FIN";
  int i=0;
  for (typename Sample<SuperCont, Cont, T>::iterator p=this->begin(); p!=this->end(); p++)
  {
   newSet=this->getElement(p)->copyElementsIn(simpleContainer, false);
   if (newSet->includes(simpleContainer) && newSet->size()< minSize )
    {
    minSize=newSet->size();
    chosenPos=i;
    }
   zap(newSet);
   i++;
  }
  return chosenPos;
  }

/*___________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Container<Cont, T>* Sample<SuperCont, Cont, T>::getColumn(int pos)//
{
   Container<Cont, T>* result=new Container<Cont, T>();
   typename Sample<SuperCont, Cont, T>::iterator p=this->GetFirst();
   Container<Cont, T>* pattern;
   int i=0;
   while (p!=this->end())
   {
      pattern=this->getElement(p);
      if (pattern->size()<=pos)
      {
         cout <<"Error, row " << i <<" has only " << pattern->size() <<" elements and should have at least" << pos+1;
      }
      result->insertElement(pattern->getElement(pos));
      p=this->getNext(p);
      i++;
   }

   return result;

  };
/*___________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>* Sample<SuperCont, Cont, T>::transpose()//
{
   Sample<SuperCont, Cont, T>* result=new Sample<SuperCont, Cont, T>();
   int totalColumns=this->GetFirstElement()->size();
   Container<Cont, T>* column, *reverseColumn;
   int totalRows=this->size();
   for (int i=0;i<totalColumns;i++)
   {
      column=this->getColumn(i);
      if (column->size()!=totalRows)
      {
         cout <<"Error, column " << i <<" has only " << column->size() <<" and should have " << totalRows;
      }
      reverseColumn=column->reverse();
      result->insertElement(reverseColumn);
      delete column;
     // delete reverseColumn;
   }
   return result;

};
/*___________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
void Sample<SuperCont, Cont, T>::removeMissingPatterns(ListOfAttributes* listOfAttributes)//
{
  Container<vector<T>, T> *pattern;
  typename Sample<SuperCont, Cont, T>::iterator p=this->getFirst();
//cout <<"attlis:" << *listOfAttributes <<"\n";

    try
    {
  while (p!=this->end())
  {

      pattern=this->getElement(p);
      if (listOfAttributes->isMissing(pattern)) 
{
         this->removeNode(p);
p=this->getFirst();
}
else p++;
    }
}
    catch (BadSize & bs) {bs.PrintMessage("Sample::removeMissingPatterns"); };
	
};

/*___________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>* Sample<SuperCont, Cont, T>::extractRowsWithPositionsIn(intList* posList)//
{
throw NonImplemented("Sample<SuperCont, Cont, T>::extractRowsWithPositionsIn(intList* posList)");
/*
intSet* posSet=new intSet(*posList);
Sample<SuperCont, Cont, T>* result= (Sample<SuperCont, Cont, T>*)this->extractElementsWithPositionsIn(posSet);
zap(posSet);
return result;
*/
};


/*___________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
long int Sample<SuperCont, Cont, T>::GetAbsoluteFrequency(AttPatternVector* attList) throw (OutOfBounds)
{
    // Given a list of AttPatterns (Attribute position and range) it returns the number of members with values in the same range for the whole set of attribute positions

    long int frequency=0;
    typename Sample<SuperCont, Cont, T>::iterator p=this->getFirst();
    typename AttPatternVector::iterator pA;
    Container<Cont, T>* pattern;
    bool inconsistent;
    int position;
    T minValue, maxValue, value;
    AttPattern* attPattern;
    bool continuous;

    while(p!=this->end())
    {
      pattern=(Container<Cont, T>*)getElement(p);
      pA=attList->getFirst();
      inconsistent=false;
      while(pA!=attList->end() && !inconsistent)
      {
        attPattern=attList->getElement(pA);
	if (attPattern->GetPos()>=pattern->size())throw OutOfBounds(attPattern->GetPos(), pattern->size());
	
        value=pattern->getElement(attPattern->GetPos());
        if (attPattern->GetMinValue()==attPattern->GetMaxValue())
        {
         if (value!=attPattern->GetMinValue()) inconsistent=true;
        } 
        else
        if (attPattern->GetMinValue()>=value || attPattern->GetMaxValue()<value)
          inconsistent=true;
        pA=attList->getNext(pA);
      }
      if (!inconsistent) frequency++;
      p=getNext(p);
    }

//    return frequency;
};
 
/*___________________________________________________________________________________*/


 template< class SuperCont, class Cont, class T>  void Sample<SuperCont, Cont, T>::setOutputSeparatorForInternalContainers(char outputSeparator)
{
for (typename Sample<SuperCont, Cont, T>::iterator p=this->begin(); p!=this->end(); p++)
this->getElement(p)->setOutputSeparator(outputSeparator);
}

/*___________________________________________________________________________________*/


 template< class SuperCont, class Cont, class T>  void Sample<SuperCont, Cont, T>::setDelimitersForInternalContainers(char left, char right)
{
for (typename Sample<SuperCont, Cont, T>::iterator p=this->begin(); p!=this->end(); p++)
this->getElement(p)->setDelimiters(left, right);

}


/*___________________________________________________________________________________*/

	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>*  Sample<SuperCont, Cont, T>::moveColumn(int oldPos, int newPos)
{
  Sample<SuperCont, Cont, T>* sample2=new Sample<SuperCont, Cont, T>(*this);

  if (oldPos!=newPos)
  {
     Container<Cont, T>* pattern;
     typename Sample<SuperCont, Cont, T>::iterator p=sample2->GetFirst();
     while (p!=sample2->end())
     {
        pattern=sample2->getElement(p);
        pattern->moveElement(oldPos, newPos);
        p=sample2->getNext(p);
     }
  }
  return sample2;
};


/*____________________________________________________________ */
/*
	template< class SuperCont, class Cont, class T>
Sample<SuperCont, Cont, T>*  Sample<SuperCont, Cont, T>::mergeWith(Sample<SuperCont, Cont, T>* secondList)
{
   Sample<SuperCont, Cont, T>* result=new  Sample<SuperCont, Cont, T>();
   typename Sample<SuperCont, Cont, T>::iterator p=this->GetFirst(), p2=secondList->GetFirst();
   //Container<T,Cont>* newList=NULL;
   while (p!=this->end() || p2!=secondList->end())
   {
      while (p!=this->end() && (p2!=secondList->end() && this->getElement(p)>=secondList->getElement(p2)) || (p2==secondList->end() && p!=this->end()))
      {
         // newList=new Container<T,Cont>(*getElement(p));
         if (result->size()==0 || !(result->GetLastElement()==getElement(p)))
            result->insertElement(getElement(p));
         p=this->getNext(p);
      }
      while (p2!=secondList->end() && (p!=NULL && this->getElement(p)<secondList->getElement(p2)) || (p==this->end() && p2!=secondList->end()))
      {
         //newList=new Container<T,Cont>(*secondList->getElement(p2));
         if (result->size()==0 || !(result->GetLastElement()==secondList->getElement(p2)))
            result->insertElement(secondList->getElement(p2));
         p2=secondList->getNext(p2);
      }

      // p=this->getNext(p);
      //p2=secondList->getNext(p2);
   }
   return result;
}


  /* _____________________________________________________*/


	template< class SuperCont, class Cont, class T>
Cont*  Sample<SuperCont, Cont, T>::readElement(ifstream * source, const char* tokensSource, int* pos, int size) throw (NullValue)
{
  char * genotypebuf=CaptureLine(source);
  string s=string(genotypebuf);
  T val;
  stringList* l=getStringVector(genotypebuf, tokensSource);
  zap(genotypebuf);
  if (l==NULL) return NULL;
  Container<Cont, T>* lline;
  lline=new Container<Cont, T>();
  stringList::iterator p=l->getFirst();
  while (p!=l->end())
  {
    s=l->getElement(p);
    lline->insertElement(fromString(val, s));
    p=l->getNext(p);
  }
  zap(l);
  return lline;
};
/* _____________________________________________________*/

template<> stringList*  stringSample::readElement (ifstream * source, const char* tokensSource, int*pos, int size) throw (NullValue)
{
   char* genotypebuf=CaptureLine(source);
 string s=string(genotypebuf);
   stringList* lline=getStringVector(genotypebuf, tokensSource);
   zaparr(genotypebuf);
   return lline;

};

  /* _____________________________________________________*/

/*

template <> Container<vector, int, std::allocator>*  Sample<vector, vector, int, std::allocator>::readElement(ifstream * source, const char* tokensSource, int* pos, int size)
{
  char * genotypebuf=CaptureLine(source);
  

  stringList* l=getStringVector(genotypebuf, tokensSource);
  zap(genotypebuf);
  //return NULL;
  if (l==NULL) return NULL;
  intList* lline;
  lline=new intList();
  stringList::iterator p=l->getFirst();
  string s;
  while (p!=l->end())
  {
    s=l->getElement(p);
    if (isAnInteger(s.c_str()))
      lline->insertElement(atoi(s.c_str()));
    else
    {
      cout <<"Error in Sample<int>::ReadElement, " << s <<" is not an integer";
      end();
    }
      p=l->getNext(p);
  }
  zap(l);
  return lline;
};

/* _____________________________________________________*/
/*
template <> floatList*  floatSample::readElement (ifstream * source, const char* tokensSource, int*pos, int size)
{
  char * genotypebuf=CaptureLine(source);

  stringList* l=getStringVector (genotypebuf, tokensSource);
  zap(genotypebuf);
  if (l==NULL) return NULL;

  floatList* lline;
  lline=new floatList();
  vector<string>::iterator p=l->getFirst();
  string s;

  while (p!=l->end())
  {
    s=l->getElement(p);
    if (strcmp(s.c_str(), "?")==0)
       lline->insertElement(maxreal);
    else 
       if (isANumber(s.c_str()))
          lline->insertElement(fromString(val, s));
       else
       {
          cout <<"Error in Sample<float>::ReadElement" << s;
          end();
       }
    p=l->getNext(p);
   }
   zap(l);
     
   return lline;
};



 
/* _____________________________________________________*/

template<> int  stringSample::getTotalMissingValues ()
{
   int totalMissing=0;
   iterator p=this->getFirst();
   stringList* row, *newRow, *pattern=new stringList(); pattern->insertElement(string("?"));

   while (p!=this->end())
   {
      row=getElement(p);
      newRow=row->copyElementsIn(pattern);
      totalMissing=totalMissing+newRow->size();
      zap(newRow);
      p=getNext(p);
   };

   return totalMissing;

}

/*______________________________________________________*/
// this function has to be overloaded because otherwise 
// operator<<(ostream& out, Container<Cont, T>& l) instead of
// operator<<(ostream& out, Container<Cont, T*>& l)
// will be calleD
/*
	template< class SuperCont, class Cont, class T>
ostream& operator<< ( ostream& out, Sample<SuperCont, Cont, T>& lista )
{
cout <<"LLLL\n";
 out << (Container<SuperCont, Cont*>&)lista;
   return out;
}

	template< class SuperCont, class Cont, class T>
ostream& operator<< ( ostream& out, Sample<SuperCont, Cont, T*>& lista )
{
cout <<"NNNNNN\n";
 out << (Container<SuperCont, Cont*>&)lista;
   return out;
}
*/

   
} // end namespace
#endif
