#ifndef Sample_h//
#define Sample_h//



namespace BIOS
{
class ListOfAttributes;
class AttPattern;
//template <template <class, class> class Cont, class T, template<class> class STL2=std::allocator> 

//R/	template< template<class> class SuperCont, template <class> class Cont, class T>
	template< class SuperCont, class Cont, class T>
	class Sample: public SuperCont // it would be better if instead of a class it would be just a set of methods with requires Container of Containers to be applied but is not possible partial instantiation so far
	{
		protected:

			Cont* readElement ( ifstream * source, const char* tokens, int* pos=NULL, int size=0)  throw (NullValue);


		public:

 //void  readInfo (ifstream * is, char* tokens);
// void order(bool ascendant);

			int getTotalMissingValues();
		 void insertElement (Cont* element, typename Sample<SuperCont, Cont, T>::iterator it);

		 void insertElement (Cont* element);

		//	Sample<SuperCont, Cont, T>* mergeWith ( Sample<SuperCont, Cont, T>* secondList );


			Sample(char outputSeparator=' ', char leftDelimiter='\0', char rightDelimiter='\n') :SuperCont(outputSeparator, leftDelimiter, rightDelimiter) {};

//	Sample() :SuperCont() {throw NonImplemented("Sample()") ;};


			Sample (Sample<SuperCont, Cont, T> &source, typename Sample<SuperCont, Cont, T>::iterator first, typename Sample<SuperCont, Cont, T>::iterator last);

			Sample ( Sample<SuperCont, Cont, T> &source);

			Sample(Sample<SuperCont, Cont, T> &source, Sampling* sampling);

			Sample(const char* filename, const char* tokens="\t ,\n", char outputSeparator='\n', char leftDelimiter='\0', char rightDelimiter='\n');

			Sample<SuperCont, Cont, T>* clone();

	//		void insertElement(Cont);

			Sample<SuperCont, Cont, T>* extractRowsWithPositionsIn ( intList* posList );


			Sample<SuperCont, Cont, T>* copyColumns ( intList* posList, bool orderedByThis=true );

			Sample<SuperCont, Cont, T>* copyColumns ( intSet* posSet, bool orderedByThis=true );
			
		  Sample<SuperCont, Cont, T>* copyColumns(int* pos, int size);

   Cont* flatSample();

			~Sample(); 

   void setOutputSeparatorForInternalContainers(char outputSeparator);

   void setDelimitersForInternalContainers(char left, char right);


			Sample<SuperCont, Cont, T>*  moveColumn ( int oldPos, int newPos );

			void removeMissingPatterns ( ListOfAttributes* listOfAttributes );





			long int GetSampleSize();



			long int GetAbsoluteFrequency (  Vector<AttPattern*>::Class* attList ) throw ( OutOfBounds );



			Container<Cont, T>* getColumn ( int index );//
			Sample<SuperCont, Cont, T>* transpose();//


//typename Sample<SuperCont, Cont, T, STL2, STL2B>::iterator findElementContainingInternalElement(typename Cont<T, STL2B<T> >::iterator value);

			//intList* getOptimalBlanket ( Container<Cont, T>* otherSet );

			int getOptimalBlanket (Cont* otherSet );


	};

	/*______________________________________________________*/

	//R/template<class T, template <class T> class Cont,template <class Cont> class SuperCont>


	//template< class SuperCont, class Cont, class T>         ostream& operator<< ( ostream& out, Sample<SuperCont, Cont, T>& lista );



  template <class T> 
  struct VectorSample
  {
    typedef Sample<
Container<vector<Container<vector<T>, T>*>,Container<vector<T>, T>*>,
Container<vector<T>, T>, 
T> Class;
  };


  template <class T> 
  struct SetSample
  {
    typedef Sample<
Container<vector<Container<set<T>, T>*>,Container<set<T>, T>*>,
Container<set<T>, T>, 
T> Class;
  };







/*
typedef Container<vector<boolList*>, boolList*> boolBasicSample;
typedef Container<vector<intList*>, intList*> intBasicSample;
typedef Container<vector<floatList*>, floatList*> floatBasicSample;
typedef Container<vector<doubleList*>, doubleList*> doubleBasicSample;
typedef Container<vector<stringList*>, stringList*> stringBasicSample;


	typedef Sample<boolBasicSample, boolList, bool> boolSample;
	typedef Sample<intBasicSample, intList, int> intSample;
	typedef Sample<floatBasicSample, floatList, float> floatSample;
	typedef Sample<doubleBasicSample, doubleList, double> doubleSample;
	typedef Sample<stringBasicSample, stringList, string> stringSample;
*/


	typedef VectorSample<bool>::Class boolSample;
	typedef VectorSample<int>::Class intSample;
	typedef VectorSample<float>::Class floatSample;
	typedef VectorSample<double>::Class doubleSample;
	typedef VectorSample<string>::Class stringSample;

typedef SetSample<string>::Class stringSetSample;



 
 


} // end namespace
#endif
