/* File: Attribute.cpp */


#ifndef __Attribute_cpp__
#define __Attribute_cpp__


#include "Attribute.h"


namespace BIOS
{



  /************************/
  /* Attribute DEFINITION */
  /***********************f*/


  /**
          @memo Attribute for SNPs
   
  	@doc
     
   
      @author Maria M. Abad Grau
  	@version 1.0
  */

/* _____________________________________________________*/

   template <> Attribute* Container<vector<Attribute*>, Attribute*>::readElement (ifstream * source, const char* tokens, int* pos, int size)
{
cout << "Attribute* Container<vector, Attribute*>::readElement not implemented  yet";
end();
};

  /*********************************************************************/
  /***     ASSOCIATED FUNCTIONS     ***/
  /*********************************************************************/

  void Attribute::set(string name, stringList* modalidades, distanceType tipo_distancia, unsigned int selected, floatList * puntos)
  {
    attribute.name=name;
	if (modalidades!=NULL)
{
    attribute.modalidades=new Modalidades(*modalidades);
 // attribute.modalidades->setOutputSeparator(',');
}
	else attribute.modalidades=NULL;
    attribute.tipo_distancia=tipo_distancia;
    attribute.selected=selected;
	if (puntos!=NULL)
    attribute.puntos=new Valores(*puntos);
	else attribute.puntos=NULL;


  };
  /*________________________________________________________________________*/

  Attribute::Attribute(string name, stringList* modalidades, distanceType tipo_distancia, unsigned int selected, floatList *puntos)
  {
    //Attribute();

    
    set(name, modalidades, tipo_distancia, selected, puntos);
   //   if (verbosity->getFirstElement()>=1)
   //   cout << this;

  }
  /*________________________________________________________________________*/

  Attribute::Attribute()
  {
    set();
  }

  /*________________________________________________________________________*/

   bool Attribute::operator==(Attribute & e)//{cout <<"Attribute::operator== Not implemented"; exit(0);};
{
  return e.getName()==getName();
}
  /*________________________________________________________________________*/

  void Attribute::set()
  {
    attribute.modalidades=NULL;
    attribute.tipo_distancia=ordinal;
    attribute.puntos=NULL;
    attribute.selected=true;
  //if (verbosity->getFirstElement()>=1)
    //  cout <<"\n Attribute: " << this;

   }
 
  /*________________________________________________________________________*/

  Attribute::Attribute(Attribute & source)
  {
    set();
set(source.attribute.name, source.attribute.modalidades, source.attribute.tipo_distancia, source.attribute.selected, source.attribute.puntos);
//    *this=Source;

  }

  /*________________________________________________________________________*/

  Attribute::~Attribute()
  {
    zap(attribute.modalidades);
    zap(attribute.puntos); //else cout <<"P";
   };

  /*_____________________________________________________________________________*/
/*
  int Attribute::getOrderedValue(float value)
  {
    if (attribute.tipo_distancia!=1) //
    {
      cout <<"not an ordered attribute in Attribute::getOrderedValue";
      exit(0);
    }
    else return atoi(attribute.modalidades->getElement((int) value).c_str());

  }
  */
  /*________________________________________________________________________*/

  void Attribute::checkValue(string valor)
  {
  if (valor!=string("?"))
      switch (attribute.tipo_distancia)
    {
    case categorical:
    case ordinal: 
		getPosition(valor); break;
    case continuous: 
    case discretized: 
    if (isNAN(atof(valor.c_str()))) throw NanValue("Attribute::checkValue");
break;
}
}

  /*________________________________________________________________________*/

  void Attribute::checkValue(float valor)
  {
      switch (attribute.tipo_distancia)
    {
    case categorical:
    case ordinal: 
		if (valor>=getTotalModalidades() || valor<0) throw BadFormat("Attribute::checkValue(float valor)"); break;
    case discretized: 
    if (valor>=getTotalIntervals()) throw NanValue("Attribute::checkValue(float)");
break;
default: break;
}
}
  /*________________________________________________________________________*/

  float Attribute::getValue(string valor)
  {
    // returned value can be a float for continuous attributes
   // if is missing, return maxreal for no discretized or the number of dimensions otherwise
try
{
checkValue(valor);
  if (valor==string("?")) return true;


    float val=atof(valor.c_str());
    switch (attribute.tipo_distancia)
    {
    case categorical:
    case ordinal: 
		if (valor==string("?")) return  getTotalModalidades();     
		return getPosition(valor); break;
    case continuous: return val; break;
    case discretized: // continuous discretized
    if (attribute.puntos==NULL) throw NullValue("Attribute::GetValue");}
    
	  if (val==maxreal) return getTotalModalidades();
      floatList::iterator p=attribute.puntos->getFirst();
      float posicion=0;
      while (p!=attribute.puntos->end())
      {
        if (val < *p)
          return posicion;
        p=attribute.puntos->getNext(p);
        posicion=posicion+1;
      }
      return posicion;
}
catch (BadFormat & bf) {bf.addMessage("\ncalled from Attribute::getValue(string valor)"); throw;};
  }
 /*________________________________________________________________________*/
/*
  float Attribute::getPureValue(string valor)
  {
    // returned value can be a float for continuous attributes
   // if is missing, return maxreal for no discretized or the number of dimensions otherwise
   float v;
    switch (attribute.tipo_distancia)
    {
    case categorical:
    case ordinal: return getPosition(valor); break;
    case continuous: return atof(valor.c_str()); break;
    case discretized: // continuous discretized
    try{  if (attribute.puntos==NULL) throw NullValue();}
      catch (NullValue nv)
      {
        nv.PrintMessage(" Attribute::GetValue. Attribute is continuous but there are not intervals");
      };
	  if (valor=="?") return getTotalModalidades();
	  v=atof(valor.c_str());
      floatList::iterator p=attribute.puntos->getFirst();
      float posicion=0;
      while (p!=attribute.puntos->end())
      {
        if (v < *p)
          return posicion;
        p=attribute.puntos->getNext(p);
        posicion=posicion+1;
      }
      return posicion;
    }
  }
  /*________________________________________________________________________*/
/*
  float Attribute::GetValue(float valor)
  {
    // returned value can be a float for continuous attributes
    // if missing, error
    float value=GetPureValue(valor);
    try
    {
      switch (attribute.tipo_distancia)
      {
      case categorical:
      case ordinal: 
      case discretized: if ((int)value==getTotalModalidades()) throw MissingValue();return value; break;
      case continuous: if (value==maxreal) throw MissingValue(); return value; break;
     }
     }
    catch (MissingValue & mv)
    {
      mv.PrintMessage(" Attribute::GetValue. Missing value", -1, GetName());
    }
   
  //  return value;
  }
  /*________________________________________________________________________*/

  bool Attribute::isMissing(float value)
  {
  
   switch (attribute.tipo_distancia)
      {
      case categorical:
      case ordinal: 
      case discretized: 
if (value>getTotalModalidades()) throw BadFormat("Attribute::isMissing(float value)"); 
if (value==getTotalModalidades()) return true; else return false; break;
      case continuous: if (value==maxreal) return true; else return false; break;
     }
  };
 /*________________________________________________________________________*/

  bool Attribute::isMissing(string valor)
  {
  if (valor==string("?")) return true;
  else return isMissing(getValue(valor));
  }
  /*________________________________________________________________________*/

  float Attribute::getLowerBound(float valor)
  {
    if (attribute.tipo_distancia==2)
    {
      cout <<"Error, attribute is continuous, in Attribute::GetLowerBound";
      exit(0);
    }

    if (attribute.tipo_distancia<2)// return 0;//val;
      return(valor);

    else // continuous discretized
      if (valor==0) return -maxreal; // first interval
    return attribute.puntos->getElement((int)valor-1);
  }
  /*________________________________________________________________________*/

  float Attribute::getUpperBound(float valor)
  {
    if (attribute.tipo_distancia==2)
    {
      cout <<"Error, attribute is continuous, in Attribute::GetLowerBound"; exit(0);
    }


    if (attribute.tipo_distancia<2) return valor;
    else
      if (valor==(getTotalIntervals()-1)) return maxreal; // last interval
      else return attribute.puntos->getElement((int)valor);
  }

  /*________________________________________________________________________*/

  string Attribute::getStringValue(float valor)
  {
    if (getTipoDistancia()!=continuous)
    {
      if (getTotalModalidades()==(int)valor)
        return string("?");
      else return attribute.modalidades->getElement((int)valor);
    }
    else // continuous
    {
      if (maxreal==valor) return string("?");
      else return tos(valor);
    }
  }
  /*________________________________________________________________________*/

  distanceType Attribute::getTipoDistancia()
  {
    return attribute.tipo_distancia;
  }
  /*________________________________________________________________________*/

  void Attribute::setDistanceType(distanceType tipo_distancia)
  {
    attribute.tipo_distancia=tipo_distancia;
  }
  /*________________________________________________________________________*/

  void Attribute::setIntervals(Valores* values)
  {
    if (values!=NULL) 
{
attribute.puntos=new Valores(*values);
 attribute.tipo_distancia=discretized;

}
    else removeIntervals();
    
  
  }
  /*________________________________________________________________________*/

  void Attribute::removeIntervals()
  {
  if (attribute.tipo_distancia==discretized)
     attribute.tipo_distancia=continuous;
  
      zap (attribute.puntos);
   
   
  }
  /*________________________________________________________________________*/

  void Attribute::removeSelection()
  {
    attribute.selected=false;

  }
  /*________________________________________________________________________*/

  void Attribute::select()
  {
    attribute.selected=true;

  }
  /*________________________________________________________________________*/

  void Attribute::setModalidades(Modalidades* modalidades)
  {
	  zap (attribute.modalidades);
    if (modalidades==NULL) attribute.modalidades=NULL;

    else 
attribute.modalidades=new Modalidades(*modalidades);
  }
  /*________________________________________________________________________*/

  void Attribute::setName(string name)
  {
      attribute.name=name;
  }

  /*________________________________________________________________________*/

  bool Attribute::isDiscretized()
  {
    return attribute.tipo_distancia==discretized;
  }


  /*________________________________________________________________________*/

  string Attribute::getName()
  {
    return attribute.name;
  }
  /*______________________________________________________________*/

  bool Attribute::isTheClass()
  {
    if (attribute.name=="class") return true; else return false;
  }
  /*______________________________________________________________*/

  int Attribute::getTotalModalidades()
  {
    if (attribute.tipo_distancia==categorical || attribute.tipo_distancia==ordinal)
      return attribute.modalidades->size();
    else if (attribute.tipo_distancia==discretized)
      return attribute.puntos->size()+1;
  else return 0;
  }
  /*______________________________________________________________*/

  int Attribute::getTotalIntervals()
  {
    if (attribute.tipo_distancia!=discretized || attribute.puntos==NULL) return 0;
      else return attribute.puntos->size()+1;
  //  else return 0;
  }
  /*______________________________________________________________*/

  Modalidades* Attribute::getModalidades()
  {
       return attribute.modalidades;
   }

  /*______________________________________________________________*/

  Valores* Attribute::getIntervals()
  {
    return attribute.puntos;
  }

  /*______________________________________________________________*/

  int Attribute::getPosition(string cadena)
  {
    if (cadena==string("?")) return getTotalModalidades();
    unsigned int  posicion=0;
    stringList::iterator p=attribute.modalidades->getFirst();
    while (p!=attribute.modalidades->end())
    {
      if (cadena.compare(*p)==0)
        return posicion;
      posicion=posicion+1;
      p=attribute.modalidades->getNext(p);
    }
    cout <<"\n" << cadena << " is not any value in list " << *getModalidades() <<"\n";
    throw BadFormat("Attribute::getPosition(string cadena)");
/*
    if (cadena.compare(string("?"))!=0)
    {
    string s=string()+GetName()+string("  value ")+cadena+string("Attribute::GetPosition(string cadena), it is a new value");
    throw OutOfBounds (atoi(cadena.c_str()), -1, s.c_str());
    end();
    }
*/
// missing (=?) returns totalModalidades
  }


  /*____________________________________________________________ */
/*
  Attribute& Attribute::operator=(Attribute & Source)
  {
    //   

//cout <<"LLL:";
//exit(0);
    if (&Source!=NULL)
    {

      if (this!=&Source)
      {
      //  attribute.puntos=new Valores(*Source.GetIntervals());

        this->SetName(Source.attribute.name);
        this->setModalidades(Source.attribute.modalidades);
	//	cout <<this->attribute.modalidades->print();
    //        exit(0);
        this->setDistanceType(Source.attribute.tipo_distancia);
        this->SetIntervals(Source.attribute.puntos);
        this->attribute.selected=Source.attribute.selected;
       }
      //   exit(0);
   	return *this;
 }

  }

  /*____________________________________________________________ */


  bool Attribute::isSelected()
  {
    return attribute.selected;
  }
  
  
  
   /*___________________________________________________________ */

float Attribute::getDistance(string  e1, string e2, NumericalAttributeDistanceMethod numericalAttributeDistanceMethod, bool useMissing, int e1Class, int e2Class, CPT* const probs)
{
return getDistance(getValue(e1), getValue(e2), numericalAttributeDistanceMethod, useMissing, e1Class, e2Class, probs);
}

/*___________________________________________________________ */

float Attribute::getDistance(float  e1, float e2, NumericalAttributeDistanceMethod numericalAttributeDistanceMethod, bool useMissing, int e1Class, int e2Class, CPT* const probs)
{
float distance=0;
float range=1;
int pos, pos2;
	if (!isMissing(e1))
	if (!isMissing(e2))
{
        if (getTipoDistancia()==ordinal)
        if (numericalAttributeDistanceMethod==normalizedAbsoluteDifference)
   	range=getValue(attribute.modalidades->getLastElement())-getValue(attribute.modalidades->getFirstElement()); 

	switch (getTipoDistancia())
	{
	case categorical: return 1-(e1==e2); break;
	default: 
	switch (numericalAttributeDistanceMethod)
	{
	case absoluteDifference: return fabs(e1-e2); break;
        case normalizedAbsoluteDifference: fabs(e1-e2)/range; break;
	case squareDifference: return std::pow((float)(e1-e2), 2); break;
        }
	}
}
if (!useMissing) return 0;
else // used in ReliefF
{
int totalClasses=probs->getMarginals()->getSize();
int totalMods=probs->getConditionals()->getSize()/totalClasses;

if (isMissing(e1) && isMissing(e2))
{
for (int i=0; i < totalMods; i++)
{
pos=totalClasses*i+e1Class;
pos2=totalClasses*i+e2Class;
distance=distance+(float)probs->getValue(pos).convert()*(float)probs->getValue(pos2).convert();
return 1-distance;
}
if (isMissing(e1)) pos=totalClasses*(int)e2+e1Class;
if (isMissing(e2)) pos=totalClasses*(int)e1+e2Class;
return 1-(float)probs->getValue(pos).convert();
}
}
};
   /*___________________________________________________________ */

 ostream& operator<<(ostream& out, Attribute& att)
  {
   
        out << "Att: " << att.attribute.name;
    
 if (att.attribute.selected==true)
{
    switch (att.attribute.tipo_distancia)
    {
    case categorical: out <<", type: categorical"; break;
    case ordinal: out <<", type: ordinal"; break;
    case continuous: out << ", type: continuous"; break;
    case discretized: out << ", type: discretized"; break;
    }
	//return string(line);
	
	if (att.isContinuous())
	{
	if (att.attribute.puntos!=NULL) out << ", cut points:  " << *att.attribute.puntos;
	}
	else 
{
	if (att.attribute.modalidades!=NULL)
{
//att.attribute.modalidades->setOutputSeparator(',');
	out <<", values: " << *att.attribute.modalidades;
}
	}
	 
}
else    out << " not selected";
    
       return out;
  }
  
  /*______________________________________________________*/
/*
template <> ostream& operator<<(ostream& out, Container<vector<Attribute*>, Attribute*>& l)
{
    for (Container<vector<Attribute*>, Attribute*>::iterator p = l.begin(); p != l.end(); p++)
{
       out << *p; 
   if (l.size()>1) if (p!= l.end()-1 && l.outputSeparator!='\0') out <<l.outputSeparator; 
//if (p==l.end()-1) out <<")";
}
return out;
}
*/
   
  
}
;  // Fin del Namespace

#endif

/* Fin Fichero: Attribute.cpp */
