/* File: Attribute.h */


#ifndef __Attribute_h__
#define __Attribute_h__

//#include <string>

//using namespace UTILS;


namespace BIOS {

class CPT;
 
/************************/
/* Attribute DEFINITION */
/************************/


/**
        @memo Attribute for SNPs

	@doc
   

    @author Maria M. Abad
	@version 1.0
*/

typedef stringList Modalidades;
typedef floatList Valores;


  enum distanceType {
    categorical=0,
    ordinal=1,
    continuous=2,
    discretized=3
    };


class Attribute   {

 public:
    /** @name Implementation of class Attribute
        @memo Private part.
    */
struct atributo 
{ //
string name; //
Modalidades *modalidades; //
distanceType tipo_distancia; // 0: categorical, 1: ordinal, 2: continuous, 3: continuous discretized
bool selected;
Valores *puntos; // if 0, it contains 1 to the total number of categories; if continuous, it contain discretization intervals
}; 

atributo attribute;

 void set(string name, stringList* modalidades, distanceType tipo_distancia, unsigned int selected=1, floatList *puntos=NULL);
 
void set();

public:

//  string getNonMissingOriginalDiscreteValue(float value);
//  string getNonMissingOriginalDiscreteValue(int value);

 // float GetPureValue(float valor);

  Attribute* clone(){return new Attribute(*this);};
  float getValue(string valor);

  Attribute(string name,  stringList* modalidades, distanceType tipo_distancia, unsigned int selected=1, floatList *puntos=NULL);

void setAttribute(Attribute *attribute);

Attribute(); 

Attribute(Attribute & Source); 

~Attribute();

void checkValue(string v);

void checkValue(float v);

Modalidades* getModalidades();

//float GetValue(float valor); 

bool isMissing(float valor); 

bool isMissing(string valor); 

float getLowerBound(float valor); 

float getUpperBound(float valor); 

bool isTheClass();

int getTotalModalidades();

int getTotalIntervals();

distanceType getTipoDistancia(); 

 
 inline bool isContinuous() {return attribute.tipo_distancia==discretized || attribute.tipo_distancia==continuous; }

bool isDiscretized(); 

bool isOrdinal() {return attribute.tipo_distancia==ordinal;};

bool isCategorical(){return attribute.tipo_distancia==categorical;};

string getName();

string getStringValue(float valor); 

void setModalidades(Modalidades* modalidades);

int getPosition(string cadena);

void setDistanceType(distanceType tipo_distancia);

void setIntervals(Valores* values); 


void removeIntervals();

Valores* getIntervals(); 

void setName(string name); 

//Attribute& operator=(Attribute & Source);

virtual bool operator>(Attribute & e){cout <<"Attribute::operator> Not implemented"; exit(0);};

virtual bool operator<(Attribute & e){cout <<"Attribute::operator< Not implemented"; exit(0);};

virtual bool operator==(Attribute & e);//{cout <<"Attribute::operator== Not implemented"; exit(0);};

virtual bool operator!=(const Attribute & e){cout <<"Attribute::operator!= Not implemented"; exit(0);};

void select();

void removeSelection();

bool isSelected();

//string print();

//int getOrderedValue(float value);

float getDistance(string  e1, string e2, NumericalAttributeDistanceMethod numericalAttributeDistanceMethod, bool useMissing=false, int e1Class=-1, int e2Class=-1, CPT* const probs=NULL);

float getDistance(float  e1, float e2, NumericalAttributeDistanceMethod numericalAttributeDistanceMethod, bool useMissing=false, int e1Class=-1, int e2Class=-1, CPT* const probs=NULL);

/*
int GetSize()
{
cout <<"no sense";
return 0;
}
*/
};
  
  //{
   //cout <<"Container<Cont, T>::readElement (ifstream * source, char* tokens) not implemented yet\n";
//end();
  //};
//template <> Attribute vector<Attribute*>::ReadElement (ifstream * is, int size){};

/*______________________________________________________*/

  ostream& operator<<(ostream& out, Attribute& att);
  
  /*______________________________________________________*/



  
};  // Fin del Namespace

#endif

//#include "Attribute.cpp"

/* Fin Fichero: Attribute.h */


/* Fin Fichero: Attribute.h */
