/* File: ListOfAttributes.cpp */


#ifndef __ListOfAttributes_cpp__
#define __ListOfAttributes_cpp__



#include "ListOfAttributes.h"


//using namespace UTILS;


namespace BIOS
{



  /**********************************/
  /* DEFINITIONS OF THE FUNCTIONS */
  /**********************************/

ListOfAttributes* ListOfAttributes::clone()
{
return new ListOfAttributes(*this);
}
 /*___________________________________________________________*/

string ListOfAttributes::getName()
{
return string("ListOfAttributes");
}
 /*___________________________________________________________*/

 ListOfAttributes::ListOfAttributes():Container<vector<Attribute*>,Attribute*>()
  {
  };
  /*___________________________________________________________*/

  ListOfAttributes::ListOfAttributes(ListOfAttributes & vectorOfAttributes):Container<vector<Attribute*>, Attribute*>(vectorOfAttributes)
  {
};
/*___________________________________________________________*/

 ListOfAttributes::ListOfAttributes(int totalAtts, int totalMods):Container<vector<Attribute*>,Attribute*>()
{
intList* vals=new intList(totalMods, 0, 1);
Modalidades *mods=vals->toStringList();


for (int i=0; i<totalAtts;i++)
 insertElement(new Attribute(string("att")+tos(i+1),  mods, categorical));
zap(mods);
zap(vals);
}

   /*___________________________________________________________*/
 
  unsigned int ListOfAttributes::GetTotalAttributes()
  {
    return size();
  }
  
    /*___________________________________________________________*/

  void ListOfAttributes::setDistance(Attribute* attribute, char* buffer)
  {
    char* cad;
/*
, *copyBuf;
   copyBuf=new char[strlen(buffer)];
   strcpy(copyBuf, buffer);
*/
  
   if ((cad = strtok (buffer, " "))==NULL) throw BadFormat(); // name
   int distance=atoi(cad);
  // buffer=origBuf;
  //  zaparr(copyBuf);
    switch (distance)
    {
    case 0: attribute->setDistanceType(categorical); break;
    case 1: attribute->setDistanceType(ordinal); break;
    case 2: attribute->setDistanceType(continuous); break;
    default:
      {
        cout <<"Error in .mas file (ListOfAttributes::setDistance), distance in " << buffer <<" is " << distance;
        exit(0);
      }
    }

  }
  /*___________________________________________________________*/

  void ListOfAttributes::setName(Attribute* attribute, char* buffer)
  {
     char* cad;
     if ((cad = strtok (buffer, ":"))==NULL) throw BadFormat(); // name
     attribute->setName(cad);
    }
  /*___________________________________________________________*/

  void ListOfAttributes::setModalidades(Attribute* attribute, char* buffer)
  {
    char *cad;
    Modalidades* modalidades=new stringList();
//cout <<"mods:" << buffer <<"\n";
     if (!attribute->isContinuous())
    {
      modalidades=new stringList();
      if ((cad = strtok (buffer, ", "))==NULL) 
        throw BadFormat();
      while (cad!=NULL && cad[0]!='.' && cad[0]!='/' && cad[0]!='\n')
      {
        modalidades->insertElement(string(cad));
        cad = strtok (NULL, ", \n");
      };
      attribute->setModalidades(modalidades);
 //     zap(modalidades); 

    }
    else attribute->setModalidades(NULL);

  }
  /*___________________________________________________________*/

  void ListOfAttributes::readAttributes(char* fileMas, bool verbosity)
  {
    char *cad=NULL, *buffer=NULL;
    ifstream  is;
    Attribute* attribute=NULL;
    int distance;
    int total_attribs=getTotalLines(fileMas);
    OpenInput(fileMas, &is);
    for (int i=0;i<total_attribs;i++)
    {
        buffer=CaptureLine(&is);
        attribute=new Attribute();
         setDistance(attribute, buffer);
         setName(attribute, NULL);
         setModalidades(attribute, NULL);
         insertElement(attribute);
 if (verbosity)
      cout <<"\n " << *attribute;

     // zap(attribute);
          zaparr(buffer);

    } // end for//
    is.close();
 if (verbosity)
      cout <<"\n ";

}
  /*___________________________________________________________ */

  ListOfAttributes::ListOfAttributes(char* texto):Container<vector<Attribute*>, Attribute*>()
  {

   // hasID=false;
    char fileFormat[256];
  //  strcpy(fileFormat, texto);
   // char ext[4];
   // strcpy(ext, "mas\0");

    changeExtension (texto, fileFormat, "mas");

    if (fileExists(fileFormat))
    this->readAttributes(fileFormat);
   else 
    {
  if (!fileExists(fileFormat))
 //   if (metadata==2 || (metadata==1 && !existFile(fileFormat)))
{
readAttributesFromData(texto);
crearFicheroMas (fileFormat);
}
else
{
cout <<"Error, file " << fileFormat << " does not exist";
end();
}
 }

//readPositions(texto);
  }


   /*___________________________________________________________ */

  void ListOfAttributes::readAttributesFromData(char* texto)
  {
  Modalidades *modalidades=new Modalidades();
  TextFile* textFile=new TextFile(texto);
  int totalRows=textFile->getTotalLines();
  stringList* pattern;
  Attribute* attribute;
  string value;
  for (int i=0;i<totalRows;i++)
  {
  pattern=textFile->readLine();
  if (i==0)
  for (int j=0;j<pattern->size();j++)
  {
    attribute=new Attribute();
    if (isAFloat(pattern->getElement(j).c_str())) 
    attribute->setDistanceType(continuous);
    else  
    {
    attribute->setDistanceType(ordinal);
    attribute->setModalidades(modalidades);
    }
    insertElement(attribute);
    }
  for (int j=0;j<pattern->size();j++)
  {
   attribute=getElement(j);
   value=pattern->getElement(j);
   if (!attribute->isContinuous()) 
   if (attribute->getModalidades()->findElement(value)==attribute->getModalidades()->end())
    if (value!=string("?"))
    attribute->getModalidades()->insertElement(value);
    attribute->getModalidades()->sort();
  }

  }
  zap(modalidades);
  }
 
  /*___________________________________________________________ */

  ListOfAttributes::~ListOfAttributes()
  {
    };

  /*___________________________________________________________ */
/*
float ListOfAttributes::getDistance(Container<vector<int>, int> * pattern1, Container<vector<int>, int> * pattern2, bool useMissing, bool noclass, DistanceMethodClass *distanceMethodClass, int classPosition, doubleList* weights)
{
throw NonImplemented("ListOfAttributes::getDistance");
}
*/

float ListOfAttributes::getDistance(Container<vector<string>, string> * pattern1, Container<vector<string>, string> * pattern2, bool useMissing, bool noclass, DistanceMethodClass *distanceMethodClass, int classPosition, doubleList* weights)
{
floatList* p1= getValues(pattern1);
floatList* p2= getValues(pattern2);
float result= getDistance(p1, p2, useMissing, noclass, distanceMethodClass, classPosition, weights);
zap(p1); zap(p2);
return result;
}
  /*___________________________________________________________ */


float ListOfAttributes::getDistance(Container<vector<float>, float> * pattern1, Container<vector<float>, float> * pattern2, bool useMissing, bool noclass, DistanceMethodClass* distanceMethodClass, int classPosition, doubleList* weights)
{
      if (weights!=NULL && weights->size() != pattern1->size()) throw BadFormat("ListOfAttributes::getDistance");
			if (size()!=(pattern1->size()+noclass)) {cout <<"error 1 in ListOfAttributes::getDistance for pattern: " << *pattern1; exit(0);};
			if (pattern1->size()!=pattern2->size()) {cout <<"error 2 in ListOfAttributes::getDistance"; exit(0);};
			iterator p=getFirst();
			Attribute *attribute;
			float e1, e2, distance=0, partialDistance;
      int pos2=0;
try
{
	for (int pos=0; pos<this->size(); pos++)
				if (!noclass || classPosition!=pos)
	{
				attribute=this->getElement(pos);
				if (attribute->isSelected())
					if (!attribute->isMissing(pattern1->getElement(pos2)))
						if (!attribute->isMissing(pattern2->getElement(pos2)))
		{
		e1=pattern1->getElement(pos2);
					e2=pattern2->getElement(pos2);
    partialDistance=attribute->getDistance(e1, e2, distanceMethodClass->numericalAttributeDistanceMethod, useMissing);
			if (weights!=NULL) partialDistance=partialDistance*weights->getElement(pos2);
        distance=distance+partialDistance;
				}
pos2++;
			}
}
catch (OutOfRange<int>& ore){ore.addMessage("\ncalled from ListOfAttributes::getDistance"); throw;}

		if (distanceMethodClass->distanceMethod==SqRoot) return sqrt(distance);
		else  return distance;  //  return (-1);
	
		};
		/*___________________________________________________________ */

  template <class T> bool ListOfAttributes::isMissing(Container<vector<T>, T>* l) throw (BadSize)
  {
//try{
if (l->size()!=size()) 
{
cout << *this<<"\nversus:\n" << *l;
throw BadSize("ListOfAttributes::isMissing", l->size(), size());

}
typename vector<T>::iterator pL=l->getFirst();
    iterator p=getFirst();
 bool missing=false;
    while (p!=end())
    {
 if (getElement(p)->isMissing((float)*pL)) return true;
  //   if (((Attribute*)*p)->isMissing((float)*pL)) return true;
     // getElement(p)->removeSelection();
      p=getNext(p);
pL=l->getNext(pL);
    }
//}
//catch (BadSize bs) {bs.PrintMessage("ListOfAttributes::isMissing", l->size(), size()); };
return false;
  }
     /*___________________________________________________________ */

  void ListOfAttributes::removeSelection()
  {
    iterator p=getFirst();
    while (p!=end())
    {
      getElement(p)->removeSelection();
      p=getNext(p);
    }
  }
  /*___________________________________________________________ */

  bool ListOfAttributes::allSelected()
  {
    iterator p=getFirst();
    while (p!=end())
    {
      if (getElement(p)->isSelected()==false) return false;
      p=getNext(p);
    }
    return true;
  }
  /*___________________________________________________________ */

  unsigned int ListOfAttributes::getTotalSelectedAttributes()
  {
    int t=0;
    iterator p=getFirst();
    while (p!=end())
    {
      if (getElement(p)->isSelected()==true) t++;
      p=getNext(p);
    }
    return t;
  }
  /*___________________________________________________________ */

  bool ListOfAttributes::isDiscretized()
  {
    iterator p=getFirst();
    Attribute* a;
    while (p!=end())
    {
      a=getElement(p);
      if (a->isContinuous() && !a->isDiscretized())
{
//cout <<"\natt " << a <<" is cont";
        return false;
}
      p=getNext(p);
    }
    return true;
  }
  /*___________________________________________________________ */

  bool ListOfAttributes::isContinuous()
  {
    iterator p=getFirst();
    Attribute* a;
    while (p!=end())
    {
      a=*p;
      if (a->isContinuous())
        return true;
      p=getNext(p);
    }
    return false;
  }
  /*___________________________________________________________ */

  intList* ListOfAttributes::convertToDiscretePositions(floatList* attPattern)
  {
  intList* positions=new intList();
      floatList::iterator pP=attPattern->getFirst();
      iterator p=getFirst();
      while (pP!=attPattern->end() && p!=end())//pP!=NULL &&
      {
 if (getElement(p)->isContinuous() &&  !getElement(p)->isDiscretized()) throw BadFormat("in ListOfAttributes::getDiscretePositions, attributes must be first discretized");
//cout << attPattern->getElement(pP);
            positions->insertElement((int)*pP);
pP=attPattern->getNext(pP);
p=getNext(p);
      }

   return positions;
  }
  /*___________________________________________________________ */

  intList* ListOfAttributes::getDiscretePositions(floatList* attPattern)
  {
  if (!allAttributesAreOrdinalOrCategorical())
  throw BadFormat("ListOfAttributes::getDiscretePositions(floatList* attPattern)"); 
  intList* positions=new intList();
      floatList::iterator pP=attPattern->getFirst();
      iterator p=getFirst();
      while (pP!=attPattern->end() && p!=end())//pP!=NULL &&
      {
            positions->insertElement((int)*pP);
pP=attPattern->getNext(pP);
p=getNext(p);
      }

   return positions;
  }
  
  /*___________________________________________________________ */
/*
  intList* ListOfAttributes::getDiscretePositions(stringList* attPattern)
  {
   
    try
    {
      if (!this->isDiscretized()) throw BadFormat();
      floatList* fPositions=getPositions(attPattern);
      intList* positions=getDiscretePositions(fPositions);
      zap(fPositions);  
      return positions;
     }
      catch (BadFormat bF)
    {
      bF.PrintMessage("in ListOfAttributes::getDiscretePositions, attributes must be first discretized");
    }
  }
 
 /*___________________________________________________________ */

template<class T>  stringList* ListOfAttributes::getStringPattern(Container<vector<T>,T>* attPattern)
  {
string nul= "?";
stringList *result=new stringList();
    iterator pL=getFirst();
    typename Container<vector<T>,T>::iterator p=attPattern->begin();
while (p!=attPattern->end() && pL!=end())
{
  if (getElement(pL)->isMissing(*p))
  result->insertElement(nul);
 else result->insertElement(tos(attPattern->getElement(p)));
p=attPattern->getNext(p);
pL=getNext(pL);
}

      return result;
     }
    
 
  /*___________________________________________________________ */

  floatList* ListOfAttributes::getValues(stringList* attPattern)
  {
try
{
       if (attPattern->size()!=size()) throw BadSize(size(), attPattern->size(), "ListOfAttributes::getValues(stringList* attPattern)");
Attribute* att;
       floatList* positions=new floatList();
      stringList::iterator pP=attPattern->getFirst();
      for (ListOfAttributes::iterator p=this->getFirst();p!=end(); p++) 
      {
       att=*p; 
        positions->insertElement(att->getValue(*pP));
        pP++;
      }
         return positions;
}
catch (BadFormat & bf) {bf.addMessage("\ncalled from ListOfAttributes::getValues(stringList* attPattern)"); throw;};

 
  }
  /*___________________________________________________________ */

  void ListOfAttributes::selectAll()
  {
    iterator p=getFirst();
    while (p!=end())
    {
      getElement(p)->select();
      p=getNext(p);
    }
  }
  /*___________________________________________________________ */
  // select attributes at attList
  void ListOfAttributes::select(intList* attList)
  {
    removeSelection();
    intList::iterator p=attList->getFirst();
    while (p!=attList->end())
    {
      getElement(attList->getElement(p))->select();
      p=attList->getNext(p);
    }
  }
   /*___________________________________________________________ */
   
   ListOfAttributes* ListOfAttributes::select()
  {
  ListOfAttributes* newList=new ListOfAttributes();

     ListOfAttributes::iterator p=getFirst();

    while (p!=end())
    {
      if (getElement(p)->isSelected()) newList->insertElement(new Attribute(*getElement(p)));
      p=getNext(p);
    }
    return newList;
  }
 /*___________________________________________________________ */
  // get a vector of selected attributes
  ListOfAttributes* ListOfAttributes::getSelection(intList* attList)
  {

 ListOfAttributes* selectedAtts=new ListOfAttributes(*this);
 selectedAtts->select(attList);
 ListOfAttributes *result=selectedAtts->select();
 zap(selectedAtts);
return result;
}

 /*___________________________________________________________ */
  // get a vector of selected attributes
  intList* ListOfAttributes::getSelection()
  {
 intList* selectedAtts=new intList();
  for (int i=0;i<size();i++)
  if (getElement(i)->isSelected()) selectedAtts->insertElement(i);
return selectedAtts;
}

  /*___________________________________________________________ */
  // select attributes at attList
  bool* ListOfAttributes::getSelected()
  {
    bool* selected=new bool[GetTotalAttributes()];
    iterator p=getFirst();
    int i=0;
    while (p!=end())
    {
      if (getElement(p)->isSelected())
        selected[i]=true;
      else selected[i]=false;
      p=getNext(p);
      i++;
    }
    return selected;
  }
  /*___________________________________________________________ */
  // select attributes at attList
  bool* ListOfAttributes::getDiscrete()
  {
    bool* discrete=new bool[GetTotalAttributes()];
    iterator p=getFirst();
    int i=0;
    while (p!=end())
    {
      if (getElement(p)->isContinuous())
        discrete[i]=false;
      else discrete[i]=true;
      p=getNext(p);
      i++;
    }
    return discrete;
  }

 /*___________________________________________________________ */


bool ListOfAttributes::allAttributesAreOrdinalOrCategorical()
{
   for (ListOfAttributes::iterator p=getFirst(); p!=end(); p++)
     if(!((Attribute*)*p)->isCategorical() && !((Attribute*)*p)->isOrdinal()) return false;
   return true;
}
 /*___________________________________________________________ */

  void ListOfAttributes::getDiscreteListOfAttributes(ListOfAttributes* vectorOfDiscreteAttributes)
  {
unsigned int i=0;
    Attribute *attribute, *sourceAttribute;
    stringList* modalidades;
    char val[256];
    for (iterator p=getFirst(); p!=end(); p++)
    {
      sourceAttribute=this->getElement(p);
      attribute=new Attribute(*sourceAttribute);
      if (sourceAttribute->isContinuous())
if (!sourceAttribute->isDiscretized()) throw NonDiscrete("ListOfAttributes::getDiscreteListOfAttributes()");
else
      {
        modalidades=new stringList();
//cout <<"TOTITNS:" << attribute->GetTotalIntervals();
        for (int i=0;i<attribute->getTotalIntervals();i++)
{
sprintf(val, "%d", i);
         modalidades->insertElement(string(val));
}
        attribute->setDistanceType(ordinal);// ordered
        attribute->setModalidades(modalidades);
attribute->removeIntervals();
        zap(modalidades);
      

      }
      vectorOfDiscreteAttributes->insertElement(attribute);
    //  zap(attribute);
    }
 }
  /*___________________________________________________________ */

  int ListOfAttributes::getTotalModalidades(int att)
  {
return getElement(att)->getTotalModalidades();
  }
  /*___________________________________________________________ */
/*
  ListOfAttributes* ListOfAttributes::getDiscreteListOfAttributes()
  {
    ListOfAttributes* vectorOfDiscreteAttributes;
    vectorOfDiscreteAttributes=new ListOfAttributes();
getDiscreteListOfAttributes(vectorOfDiscreteAttributes);
return vectorOfDiscreteAttributes;
  }
  /*___________________________________________________________ */

  void ListOfAttributes::removeIntervals()
  {
    iterator p=getFirst();
    while (p!=end())
    {
      if (getElement(p)->isContinuous())
        getElement(p)->removeIntervals();
      p=getNext(p);
    }
  }
  /*___________________________________________________________ */

  intList* ListOfAttributes::getDimensionList(intList* varList)
  {
   intList::iterator p=varList->getFirst();
    intList* dimensionList=new intList();
    Attribute *attribute;
    while (p!=varList->end())
    {
      attribute=getElement(varList->getElement(p));
if (attribute->isContinuous() && attribute->getTipoDistancia()!=discretized) throw NonDiscrete("ListOfAttributes::getDimensionList");
      dimensionList->insertElement(attribute->getTotalModalidades());
if (1==0)
      if (attribute->getTotalModalidades()<=1)
      {
        cout <<"Error in ListOfAttributes::getDimensionList, att " << attribute->getName() << " has only " << attribute->getTotalModalidades() <<" value: ";
 if (attribute->getTipoDistancia()==categorical || attribute->getTipoDistancia()==ordinal)
 cout << *attribute->getModalidades();
else if (attribute->getTipoDistancia()==discretized) cout << *attribute->getIntervals();
        end();
      }
      p=varList->getNext(p);
    }
//cout <<"dimvector is" << *dimensionList <<"\n";
    return dimensionList;
  }


  /*___________________________________________________________________*/

  void ListOfAttributes::crearFicheroMas (char texto[256])
  {//
  //  int TotalAttributes, cont=0;
  //  TotalAttributes=GetTotalAttributes();
    int i=0, i2;
    Attribute *attribute;
    ofstream fichero_salida1;
    fichero_salida1.open(texto);

 //   fichero_salida1 << TotalAttributes << " \n"; //

   iterator pA=getFirst();
    while (pA!=end())
    {
      i++;
      attribute=ListOfAttributes::getElement(pA);
      if (attribute->getTipoDistancia() == discretized) fichero_salida1 << 1; //changed to ordinal
      else fichero_salida1 << attribute->getTipoDistancia();
      if (attribute->getName().size()!=0) fichero_salida1 << " " << attribute->getName() << ": ";
      else fichero_salida1 << " Att" << i << ": ";
        if (attribute->getTipoDistancia() != continuous)
        {
          if (attribute->getTipoDistancia() != discretized)
	  fichero_salida1 << *attribute->getModalidades();
	  else 
	  for (int i=0; i<attribute->getTotalModalidades();i++) 
	  {
	  fichero_salida1 << i;
	  if (i<(attribute->getTotalModalidades()-1))
	   fichero_salida1 << ",";
	   }
         }
        else fichero_salida1 << "continuous\n";
       pA=ListOfAttributes::getNext(pA);
    }
    fichero_salida1.close();

  };//

  /*_______________________________________________________________________________*/

  void ListOfAttributes::CrearFicheroNombres (char texto[128], int classNumber, bool isDiscretized, bool select)
  {//
int totalModalities;
    if (classNumber==-1) classNumber=GetTotalAttributes()-1;
    int i=0, i2;
    iterator pA=ListOfAttributes::getFirst();
    Attribute *inputAttribute, *classAttribute;
    ofstream fichero_salida1;
    fichero_salida1.open(texto);
    classAttribute=ListOfAttributes::getElement(classNumber);
    stringList::iterator pm=classAttribute->getModalidades()->getFirst();
vector<float>::iterator pm2;
    i2=0;
    while (pm!=classAttribute->getModalidades()->end())
    {
      fichero_salida1 << i2;//pm->element;
      pm=classAttribute->getModalidades()->getNext(pm);
      if (pm!=classAttribute->getModalidades()->end())
        fichero_salida1  << ", ";
      else
        fichero_salida1 << ".\n";
      i2++;
    }
    pA=getFirst();
    while (pA!=end())
    {
      inputAttribute=ListOfAttributes::getElement(pA);

      if (i!=classNumber && (!select|| inputAttribute->isSelected()))
      {
        fichero_salida1 << inputAttribute->getName() << ": ";
        if (!isDiscretized &&  ((inputAttribute->getTipoDistancia() == discretized) || inputAttribute->getTipoDistancia() == continuous))
          fichero_salida1 << "continuous.\n";
        else
        for(int i2=0;i2< inputAttribute->getTotalModalidades();i2++)
{
         fichero_salida1 << i2;
if (i2<inputAttribute->getTotalModalidades()-1) fichero_salida1  << ", ";
else fichero_salida1 << ".\n";
      }
}
      i++;

      pA=ListOfAttributes::getNext(pA);
    }


    fichero_salida1.close();

  }

  /*______________________________________________________*/

float ListOfAttributes::getAlphaDenominator(BayesType bayesType, float alpha, intList *varList, intList *conditionalVarList)
{
float alphaDenominator=alpha;

switch (bayesType)
{
	case UBalpha: alphaDenominator=alpha; break; 
	case BDistanceUniform: 
alphaDenominator=alpha; 
if (conditionalVarList!=NULL && conditionalVarList->size()==1)
alphaDenominator=alpha*getDistance(varList->getFirstElement(), conditionalVarList->getFirstElement());
else alphaDenominator=alpha;
break;
default:break;
}
return alphaDenominator;
}
 /*______________________________________________________*/

ListOfAttributes* ListOfAttributes::copyAttributesWithPositionsIn(intList* columns, bool isThis)
{

ListOfAttributes* res= new ListOfAttributes();

intList::iterator p=columns->getFirst();
while(p!=columns->end())
{
res->insertElement(this->getElement(columns->getElement(p)));
p=columns->getNext(p);
}
return res;
}

  /*___________________________________________________________ */
/*
  floatList* ListOfAttributes::getPositions(stringList* attPattern)
  {
 
    try
    {
       floatList* positions=new floatList();

      Attribute * attribute;
      float value;
      stringList::iterator pP=attPattern->getFirst();
      iterator p=this->getFirst();

      if (attPattern->size()!=size())
        throw BadSize();
      while (p!=end() && pP!=attPattern->end())
      {
        attribute=this->getElement(p);
	value=attribute->GetPureValue(attPattern->getElement(pP));
        positions->insertElement(value);
        p=getNext(p);
        pP=attPattern->getNext(pP);
      }
         return positions;
    }
    catch (BadSize bs)
    {
      bs.PrintMessage(" ListOfAttributes::getPositions", size(), attPattern->size());
    }
 
  }

/*______________________________________________________*/

ostream& operator<<(ostream& out, ListOfAttributes& vectora)
{
   ListOfAttributes::iterator p=vectora.getFirst();
   out <<"\n";
   while (p!=vectora.end())
   {
     out << *vectora.getElement(p);
     p=vectora.getNext(p); 
     out <<"\n";
   }
   
   return out;
}


};  // Fin del Namespace

#endif

/* Fin Fichero: ListOfAttributes.h */
