#ifndef Dv2d_HPP
#define Dv2d_HPP 1

// header file for double precision dvector and matrix classes
// doublevec - double dvector indexed from 0
// dvector - double dvector indexed from offset, can't remember what it does
// dv2d - double matrix indexed from 0, supports matrix arithmetic
// dsvd - set of three matrices forming singular value decomposition of source matrix
// rank_table - not distributing this code yet

namespace BIOS {


class dv2d{
double **rv;
int wide,high,max_h;
public:
dv2d(int h=0,int w=0);
dv2d(dv2d const &);
dv2d* clone();
~dv2d();
double **vec() { return rv; }
bool zeroInverse();
int get_width(void) const {return wide;}
int get_height(void) const {return high;}
long size(void){return long(wide)*high;}
dv2d& operator=(dv2d const &);
dv2d operator+(dv2d const &);
dv2d operator*(dv2d const &);
dv2d operator*(double);
dv2d& operator*=(dv2d const &);
dv2d& operator+=(dv2d const &);
dv2d& operator*=(double);
dv2d operator-(dv2d const &);
DBLPOINTER operator[](int i) {return rv[i];}
// double determ();
dv2d inv();
// int dsvdcmp(dv2d&,dv2d&);
dv2d transpose();
int add_row(int rownum=-1);
int del_row(int rownum=-1);
int add_col(int colnum=-1);
int del_col(int colnum=-1);
void sort_rows(int,int);
int resize(int,int);
void fprintf(FILE *fp=stdout,char *form= "%3.2g  ");
void fscanf(FILE *fp=stdin);
void print(char *form= "%3.2g  ") { fprintf(stdout,form); }
friend class dsvd;
void normal(int);
friend ostream& operator<<(ostream& out, dv2d& l);
};

}
#endif

