#ifndef DependenceMeasure_cpp//
#define DependenceMeasure_cpp//



namespace BIOS 
{



/*______________________________________________________*/

template<class T> DependenceMeasure<T>::DependenceMeasure(BayesType bayesType, float alpha): Measure<T>(bayesType, alpha)
{
};
/*______________________________________________________*/

template<class T> 
double DependenceMeasure<T>::getMeasure(typename VectorSample<T>::Class* sample, ListOfAttributes* listOfAttributes, intList* varList, intList* conditionalVarList)
{
cout <<"Error in DependenceMeasure<T>::getMeasure, not implemented yet";
end();
}

/*______________________________________________________*/


template<> double DependenceMeasure<int>::getMeasure(intSample* sample, ListOfAttributes* listOfAttributes, intList* varList, intList* conditionalVarList)
{
intList* allVars=new intList(*varList), *dimensionList=NULL;
if (conditionalVarList!=NULL)
allVars->copyPaste(conditionalVarList);
dimensionList=listOfAttributes->getDimensionList(allVars);
CPT* sampleSet=new CPT(sample, allVars, conditionalVarList, dimensionList, MLE, 0, listOfAttributes);


PriorTable *priors=new PriorTable(listOfAttributes, allVars, dimensionList, conditionalVarList, alpha, bayesType);
zap(dimensionList);
zap(allVars);

CPT*pr=new CPT(conditionalVarList, priors);
zap(priors);


double result=getMeasure(sampleSet, pr);


zap(pr);
zap(sampleSet);
return result;
};
/*______________________________________________________*/

template<> double DependenceMeasure<int>::getLDMeasure(intSample* sample, ListOfAttributes* listOfAttributes, intList* varList, intList* conditionalVarList)
{ // only for genotype data and 2 var maximum
intList* allVars=new intList(*varList), *dimensionList=NULL;
if (conditionalVarList!=NULL)
allVars->copyPaste(conditionalVarList);
dimensionList=listOfAttributes->getDimensionList(allVars);

CPT* sampleSet=new AlleleCPT(sample, allVars, conditionalVarList, dimensionList, MLE, 0, listOfAttributes);
zap(dimensionList);

intList* newDimensionList=new intList();
for (int i=0;i<allVars->size();i++)
 newDimensionList->insertElement(2);
PriorTable *priors=new PriorTable(listOfAttributes, allVars, newDimensionList, conditionalVarList, alpha, bayesType);
zap(newDimensionList);
zap(allVars);
CPT*pr=new AlleleCPT(conditionalVarList, priors);

double result=getMeasure(sampleSet, pr);
zap(pr);
zap(sampleSet);
return result;



}
/*______________________________________________________*/

template<class T> bool DependenceMeasure<T>::betterPair(HeteroPair<float, int>m1,     HeteroPair<float, int>m2)
{
return this->better(m1.first(), m2.first());
}

/*______________________________________________________*/

template<class T> double DependenceMeasure<T>::getLDMeasure(typename VectorSample<T>::Class* sample, ListOfAttributes* listOfAttributes, intList* varList, intList* conditionalVarList)
{
cout <<"Error in DependenceMeasure<T>::getLDMeasure, not implemented yet";
end();
}
/*______________________________________________________*/

template<class T> ostream& operator<<(ostream& out, DependenceMeasure<T>& lista)
{
 
out << *lista.sample;

return out;
  }


} // end namespace
#endif
