#ifndef EmpiricalRisk_cpp//
#define EmpiricalRisk_cpp//



namespace BIOS 
{

/*______________________________________________________*/

template <class T> EmpiricalRisk<T>::EmpiricalRisk(BayesType bayesType, float alpha): DependenceMeasure<T>()
{
if (alpha==0) alpha=1;
this->bayesType=bayesType;
}

/*______________________________________________________*/

template<class T> bool EmpiricalRisk<T>::better(double m1, double m2)
{
if (m1<m2) return true; else return false;
}

/*______________________________________________________*/

template <class T> double EmpiricalRisk<T>::getMeasure(CPT *s1, CPT* priors)
{
cout <<"EmpiricalRisk<T>::getMeasure not defined yet";
end();
}

/*______________________________________________________*/

template<> double EmpiricalRisk<int>::getMeasure(CPT *pt, CPT* s2)
{
// it computes empirical risk of var at s1->varList->GetElement(0) given other (possible) variables

ProbabilityTable* s1=pt->getProbabilityTable();

int xTotalMods=s1->dimensionList->getElement(0);
double risk=0, *conditionalFrequencies=NULL;
Prob p;
int* pos=NULL;
for (int j=0;j<s1->getSize()/xTotalMods;j++)
 {
  pos=s1->getPositions(j);
 conditionalFrequencies=new double[xTotalMods];
  for (int k=0;k<xTotalMods;k++)
{
    pos[0]=k;
    conditionalFrequencies[k]=s1->getValue(pos).getNumerator();
  }
pos[0]=xTotalMods;
p=Prob(s1->getValue(pos).getDenominator(),s1->getTotalSample());
risk=risk+p.convert()*GetMax(conditionalFrequencies, xTotalMods)/(double)s1->getTotalSample();
zap(pos);
}
return risk;
 }

/*______________________________________________________*/

template<class T> ostream& operator<<(ostream& out, EmpiricalRisk<T>& lista)
{
 
//out << *lista.sample;

return out;
  }

  
} // end namespace
#endif
