/* File: MultipleSamplesRateResults.h */

#ifndef __MultipleSamplesRateResults_cpp__
#define __MultipleSamplesRateResults_cpp__





namespace BIOS
{

 MultipleSamplesRateResults:: MultipleSamplesRateResults():MeasureResults()
   {
   rates=NULL;
   alpha=NULL;
   pVals=NULL;
   returnPVals=false;
   }
   
       /*________________________________________________________________________*/

    MultipleSamplesRateResults:: MultipleSamplesRateResults(MultipleSamplesRateResults& other):MeasureResults()
   {
   this->rates=other.rates->clone();
	 this->alpha=other.alpha;
	 this->pVals=other.pVals->clone();
	 this->returnPVals=other.returnPVals;
   }
     /*________________________________________________________________________*/

/*
   MultipleSamplesRateResults:: MultipleSamplesRateResults(doubleList* rates, PairOfDoublesVector* alpha):MeasureResults()
   {
   this->rates=rates;
   this->alpha=alpha;
   if (alpha->size()!=rates->size())
   throw BadFormat("MultipleSamplesRateResults:: MultipleSamplesRateResults(doubleList* rates,...");
   };
        /*________________________________________________________________________*/


   MultipleSamplesRateResults:: MultipleSamplesRateResults(MeasureResults** mrArray, int size, PairOfDoublesVector* alpha, bool returnPVals):MeasureResults()
   {
   double totalMultiTest, trueSize=0;
   this->alpha=alpha;
   this->returnPVals=returnPVals;
   if (size<1) throw ZeroValue("MultipleSamplesRateResults:: MultipleSamplesRateResults(MeasureResults** mrArray, int size, PairOfDoublesVector* alpha)");
   rates=new doubleList();
   pVals=new doubleList();
   double rate;
   double lowerBound, upperBound;
   for (PairOfDoublesVector::iterator it=alpha->begin(); it<alpha->end(); it++)
   {
   trueSize=0;
   rate=0;
   lowerBound=alpha->getElement(it)->getFirst();
   upperBound=alpha->getElement(it)->getSecond();
   for (int i=0; i<size; i++)
   if (mrArray[i]!=NULL) 
   {
    trueSize++;
   totalMultiTest=mrArray[i]->getTotalMultiTest();
   if (totalMultiTest>0)
   {
   lowerBound=1-std::pow((1-lowerBound),(1/totalMultiTest));
   upperBound=1-std::pow((1-upperBound),(1/totalMultiTest)); 
   }
    if (mrArray[i]->getMainResult() >=lowerBound && mrArray[i]->getMainResult()<upperBound) rate++;
      }
   rates->insertElement(rate/trueSize);
   };
   
    for (int i=0; i<size; i++)
    if (mrArray[i]!=NULL) pVals->insertElement(mrArray[i]->getMainResult()); 
   }
   
     /*________________________________________________________________________*/


   doubleList* MultipleSamplesRateResults::getPVals()
   {
   return pVals;
  }
        /*________________________________________________________________________*/

/*
   MultipleSamplesRateResults:: MultipleSamplesRateResults(MultipleSamplesRateResults** mrArray, int size, PairOfDoublesVector* alpha, bool returnPVals):MeasureResults()
   {
   rates=new doubleList();
   this->alpha=alpha;
   this->returnPVals=returnPVals;
   this->pVals=new doubleList();
   double rate;
   int pos;
   double pVal;
   double lowerBound, upperBound;
   for (PairOfDoublesVector::iterator it=alpha->begin(); it<alpha->end(); it++)
   {
   pos=alpha->getPosition(it);
   rate=0;
   lowerBound=alpha->getElement(it)->getFirst();
   upperBound=alpha->getElement(it)->getSecond();
   for (int i=0; i<size; i++)
   {
    if (mrArray[i]->rates->getElement(pos) >=lowerBound && mrArray[i]->rates->getElement(pos)<=upperBound) rate=rate+1/(double)size;
      }
   rates->insertElement(rate);
   };
   
   for (int i=0; i<size; i++)
    {
     pVal=0;
     for (int j=0; j<mrArray[i]->getPVals()->size(); j++)
     pVal=pVal+mrArray[i]->getPVals()->getElement(j); 
     pVals->insertElement(pVal/mrArray[i]->getPVals()->size());
     }
   }
   
   /*________________________________________________________________________*/
   
    MultipleSamplesRateResults::~MultipleSamplesRateResults()
    {
    zap(rates);
    };
    
      /*________________________________________________________________________*/
  
    void MultipleSamplesRateResults::set()
    {
    this->rates=NULL;
    this->alpha==NULL;
    };
          /*________________________________________________________________________*/
  
    void MultipleSamplesRateResults::empty()
    {
    zap(this->rates);
    };
    
      /*________________________________________________________________________*/
  
    MultipleSamplesRateResults* MultipleSamplesRateResults::clone()
    {
    return new MultipleSamplesRateResults(*this);
    };

  /*________________________________________________________________________*/
  
   
void MultipleSamplesRateResults::addResult(MeasureResults*m, int size)
{
try
{
if (alpha==NULL) alpha=((MultipleSamplesRateResults*)m)->alpha;
if (rates==NULL) 
{
rates=new doubleList();
for (int i=0; i<((MultipleSamplesRateResults*)m)->rates->size(); i++)
if (size>0)
rates->insertElement(((MultipleSamplesRateResults*)m)->rates->getElement(i)/(double)size);
else
rates->insertElement(0);

}
else
{
if (rates->size()!=((MultipleSamplesRateResults*)m)->rates->size()) throw OutOfBounds(rates->size(), ((MultipleSamplesRateResults*)m)->rates->size(), "void MultipleSamplesRateResults::addResult(MeasureResults*m, int size)");
for (int i=0; i<((MultipleSamplesRateResults*)m)->rates->size(); i++)
if (size>0)
rates->changeElementAtPos((((MultipleSamplesRateResults*)m)->rates->getElement(i)/(double)size)+rates->getElement(i), i);
//throw BadFormat("StatisticalTestResults::addResult(),nonsense");
}
if (pVals==NULL) 
pVals=new doubleList();

double pVal=0;
     for (int i=0; i<((MultipleSamplesRateResults*)m)->getPVals()->size(); i++)
     pVal=pVal+((MultipleSamplesRateResults*)m)->getPVals()->getElement(i); 
     pVals->insertElement(pVal/((MultipleSamplesRateResults*)m)->getPVals()->size());

}
    catch (BasicException& be) {be.addMessage ("\ncalled from void MultipleSamplesRateResults::addResult(MeasureResults*m, int size)"); throw;};
}


          /*________________________________________________________________________*/
  
  double MultipleSamplesRateResults::getMainResult()
  {
  return rates->getFirstElement();
  }


/*________________________________________________________________________*/

void MultipleSamplesRateResults::printHeading(ostream& out)
{
try
{
double lowerBound, upperBound;
if (returnPVals)
{
out <<"_pVal";
}
else
for (int i=0; i<alpha->size(); i++)
{
lowerBound=alpha->getElement(i)->getFirst();
upperBound=alpha->getElement(i)->getSecond();
if (lowerBound>-MAXFLOAT) out << lowerBound << ":";
if (upperBound<MAXFLOAT) out << upperBound;
if (i<(alpha->size()-1)) out <<"\t";
}
}
    catch (BasicException& be) {be.addMessage ("\ncalled from void MultipleSamplesRateResults::printHeading(ostream& out)"); throw;};
}
/*________________________________________________________________________*/

/*________________________________________________________________________*/

void MultipleSamplesRateResults::printHeadingPlus(string s, ostream& out)
{
try
{
double lowerBound, upperBound;
if (returnPVals)
{
out << s << "_pVal";
}
else
for (int i=0; i<alpha->size(); i++)
{
lowerBound=alpha->getElement(i)->getFirst();
upperBound=alpha->getElement(i)->getSecond();


if (upperBound<MAXFLOAT) out << "" << s << "." << upperBound << "\t";

}
}
    catch (BasicException& be) {be.addMessage ("\ncalled from void MultipleSamplesRateResults::printHeading(ostream& out)"); throw;};
}
/*________________________________________________________________________*/


void MultipleSamplesRateResults::print(ostream& out, bool verticalPrint)
{
try
{
double lowerBound, upperBound;

if (!returnPVals)
for (int i=0; i<alpha->size(); i++)
{
if (!verticalPrint)
{
lowerBound=alpha->getElement(i)->getFirst();
upperBound=alpha->getElement(i)->getSecond();
if (lowerBound>-MAXFLOAT) out << lowerBound << ":";
if (upperBound<MAXFLOAT) out << upperBound;
out <<":\t";
}

out << rates->getElement(i);
if (i<(alpha->size()-1))
if (!verticalPrint) out <<"\n";
else  out <<"\t";
}
else
{
if (verticalPrint) pVals->setOutputSeparator('\n');
out <<*pVals;
}
}
    catch (BasicException& be) {be.addMessage ("\ncalled from void MultipleSamplesRateResults::print(ostream& out, bool verticalPrint)"); throw;};
}


};  // Fin del Namespace

#endif

/* Fin Fichero: TestModeClass.h */
