#ifndef __ContingencyTable_cpp__
#define __ContingencyTable_cpp__

//#define _PRINT_EXPECTED_VALUES_

namespace BIOS
{

	template <class T>
	ContingencyTable<T>::ContingencyTable()
	{

		for(int i=0; i<2; i++)
			for(int j=0; j<2; j++)
				table[i][j]=(T)0;

	}

	template <class T>
	T ContingencyTable<T>::total()
	{ 
		return (T)(table[0][0] + table[0][1] + table[1][0] + table[1][1]); 
		
	}

	template <class T>
	T 	ContingencyTable<T>::marginalTotalRow(int row)
	{
		return (T) ( table[row][0] + table[row][1] ) ;
	}

	template <class T>
	T 	ContingencyTable<T>::marginalTotalColumn(int col)
	{
		return (T) ( table[0][col] + table[1][col] ) ;
	}

	template <class T>
	T ContingencyTable<T>::statisticSameMarginalRows_1()
	{
		float E[2][2]; // Expected values
		E[0][0] = E[1][0] = ( a() + c() ) / 2;		
		E[0][1] = E[1][1] = ( b() + d() ) / 2;


			#ifdef _PRINT_EXPECTED_VALUES_
				cout << endl << "*(CT)  Expected values: "; 
					for (int i=0; i<2; i++){
						cout << endl;
						for (int j=0; j<2;j++)
							cout << E[i][j] << ",  ";
					}
				cout << endl << endl;
			#endif

		T statistic = (T)0; 

		for ( int i=0; i<2; i++)
			for( int j=0; j<2; j++)
				statistic += std::pow( (table[i][j] - E[i][j]) ,2 ) / E[i][j];

		return statistic;

	}

	template <class T>
	T ContingencyTable<T>::statisticSameMarginalRows()
	{


		T statistic;

		statistic =  std::pow( a() - c() , 2) / ( a() + c() );
		statistic += std::pow( b() - d() , 2) / ( b() + d() );


		return statistic;

	}

}


#endif
