#ifndef __ContingencyTable_h__
#define __ContingencyTable_h__

namespace BIOS
{


	/**
	* Contingency table 2x2
	*	a	b	
	*	c	d
	*/
	template <class T> class ContingencyTable
	{

		private:
		public:	
			//! 2x2 Table including totals
			T table[2][2];


			/**
			* Constructor
			*/
			ContingencyTable();

			/**
			*	Total count
			*/
			T total();

			/**
			*	fist row, first column
			*/
			T a(){ return table[0][0]; };

			/**
			*	fist row, second column
			*/
			T b(){ return table[0][1]; };

			/**
			*	second row, second column
			*/
			T c(){ return table[1][0]; };

			/**
			*	second row, second column
			*/
			T d(){ return table[1][1]; };

			/**
			* marginal total for a row
			* @param row Row to sum
			* @return Marginal total 
			*/
			T marginalTotalRow(int row);			

			/**
			* marginal total for a column
			* @param col Column to sum
			* @return Marginal total 
			*/
			T marginalTotalColumn(int col);

			/**
			* statistic calculated when same marginal rows
			*/
			T statisticSameMarginalRows_1();

			/**
			* statistic calculated when same marginal rows. Simplified version of statisticSameMarginalRows_1
			*/
			T statisticSameMarginalRows();
			
			/**
			* Prints the current values of the table
			* @param output Output stream
			* @param c Table to print
			*/		
			friend ostream& operator<<(ostream& output, ContingencyTable<T>& c){

				output << c.table[0][0] << "\t" << c.table[0][1] << "\t| " << c.marginalTotalRow(0) << endl;
				output << c.table[1][0] << "\t" << c.table[1][1] << "\t| " << c.marginalTotalRow(1) << endl;
				output << "--------------------" << endl;				
				output << c.marginalTotalColumn(0) << "\t" << c.marginalTotalColumn(1) << "\t| " << c.total() << endl;
    

				return output;
			}
	};


};

#endif
