/* File: Block.h */


#ifndef __Block_h__
#define __Block_h__



namespace BIOS {


/************************/
/* block SNP*/
/************************/


/**
        @memo block

	@doc
        Definition:
        An array SampleValues of Size values

        Memory space: O(size). 

        @author Maria M. Abad
	@version 1.0
*/
 struct Block{

      /**
      @memo Initial Pos of a block
      @doc  
      */
      SNPPos IniPos;

      /**
      @memo Last+1 pos of the block
      @doc 
      */
      SNPPos LastPos;

Block(SNPPos iniPos, SNPPos lastPos)
{
IniPos=iniPos;
LastPos=lastPos;
}
Block* clone()
{
return new Block(*this);
}

void set(SNPPos iniPos, SNPPos lastPos)
{
IniPos=iniPos;
LastPos=lastPos;
}

bool comparison(struct Block & other, ComparisonType type)
{
switch(type)
{
case equal: return *this==other;
case lower: return IniPos<other.IniPos;
case greater: return IniPos>other.IniPos;
}
}
bool operator==(struct Block& other) {return comparison(other, equal);};
bool operator>(struct Block& other) {return comparison(other, greater);};
bool operator<(struct Block& other) {return comparison(other, lower);};


	};  // end structure block


ostream& operator<<(ostream& out, Block& p);
}// end namespace

#endif

/* End of file: block.h */
