#ifndef __CommandLineParserWindows_h__
#define __CommandLineParserWindows_h__

namespace BIOS {

	/** 
	* 	Class used to read command line arguments for TrioSample programs
	*	Only one file will be specified. Example program to use this class: linkageAnalysis.cpp
	*/

	class CommandLineParserWindows{

		public:
		bool parsingOK;

		int argc; 
		char**argv;

		//! File name including path
		string path;
		//! File name without path
		string fileName;
		//! File name without path and without extension
		string fileNameNoExtension;
		//!Allele order type. Default 2 which indicates that haplotypes are knwon
		AlleleOrderType alleleOrderType;
		//! Sliding windows width
		int window_width;
		//! Sliding windows offset
		int window_offset;
		//! Total number of files from which to create samples
		int totalSamples;

		//! test name, extracted from input sample name
		string test;
		//! model name, extracted from input sample name
		string model;
		//! Relative risk, extracted from input sample name
		string RR;
		//! recombination fraction, extracted from input sample name
		string recombination;

		CommandLineParserWindows(int argc, char*argv[]);

		~CommandLineParserWindows();

		void parse();

		string ithSampleFileName(int i);

		bool splitFileName();
	};


};


#endif



