/* File: GWAS.h */


#ifndef __GWAS_h__
#define __GWAS_h__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo GWAS

	@doc
        Definition:
									IT decomposes a region of regionLength snps, starting at snp "firstSNP" in slinding windows of size "windowSize" and offset "offset"        

        Memory space:

        @author Maria M. Abad Grau
	@version 1.0
*/

//typedef TestMode;
 
class GWAS {


protected:
    /** @name Implementation of class Genotype
        @memo Private part.
    */
	
TestModeClass* testModeClass;
HapExtractionConfiguration* hapExtractionConfiguration;
GenericMLTest** genericMLTests;
PairOfDoublesVector* alpha;
SlidingWindows* sw;
int totalSamples;
MeasureResults*** resultsForWindows;// first pointer is for each measure, second pointer is for window index
MeasureResults*** averageResults;// first pointer is for each measure, second pointer is for SNP index
ListOfGenericMeasures* measures;
int totalUsedSNPs, totalWindows, totalMeasures;
char* fileSample;
bool measureFiles;
char resultsDir[512];
bool returnPVals;
   
private:

void setResults();
void set(ListOfGenericMeasures* measures, char* fileSample, const char* resultsDir, int totalSamples, TestMode testMode, int numberOfFolds, bool testModeForInsideMeasure, int width, int offset, int totalPermutations, int iniPos, int length, bool measureFiles, bool useOnlyHetero, bool returnPVals,
AlleleOrderType genotypeOrder, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction,   intList* alpha);


public:





GWAS();
void set();
//void setMeasureFiles(bool measureFiles=true);
GWAS(ListOfGenericMeasures* measures, char* fileSample, const char* resultsDir=NULL, int totalSamples=1, TestMode testMode=tTraining, int numberOfFolds=5, bool testModeForInsideMeasure=true, 
int width=10, int offset=1, int totalPermutations=100, int iniPos=0, int length=-1, bool measureFiles=false, bool useOnlyHetero=true, bool returnPVals=false,
AlleleOrderType genotypeOrder=LeftRight, PhaseAlg phaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction,   intList* alpha=NULL);
//GWAS(GenericMLTest** genericMLTest, char* fileSample, int totalSamples, TestModeClass *testMod, bool useOnlyHetero, int iniPos, int length, int width, int offset, ListOfGenericMeasures* measures, PairOfDoublesVector* alpha);
MeasureResults** getResultsForWindowsForMeasure(int measureIndex);// results for a measure
MeasureResults*** getResultsForWindows();// results for all windows
MeasureResults** getAverageResultsForMeasure(int measureIndex);// results for a SNP
MeasureResults*** getAverageResults();// results for all SNPs
~GWAS();
void  printAverageResults(bool verticalOutput=true, const char* extension=NULL);
void  printResultsForWindows(bool verticalOutput=true, bool oneFile=true, const char* extension=NULL, stringList* firstPartHeading=NULL, stringList* rowHeading=NULL);
Container<vector<ofstream*>,ofstream*>*    getWindowsStreams(bool oneFile, const char* extension);
};
} // end namespace
#endif


