
/* File: GenomaSample.cpp */



#ifndef __GenomaSample_cpp__
#define __GenomaSample_cpp__





namespace BIOS {


GenomaSample* GenomaSample::clone()
{
return new GenomaSample((GenomaSample&)*this);
} 


/*____________________________________________________________ */
/*
GenomaSample* GenomaSample::copyElementsWithPositionsIn(intSet* positions, bool inThis)
{
PhenotypeSample* rP=(PhenotypeSample*)this->phenotypeSample->copyElementsWithPositionsIn(positions, inThis);
GenotypeSample* gP=(GenotypeSample*)this->genotypeSample->copyElementsWithPositionsIn(positions, inThis);
GenomaSample* result= new  GenomaSample(*rP, *gP);
//result->PrintPhenotypes();
if (this.Marked!=NULL) {cout <<"\nIndividuals cannot be marked in the source sample when selection of individuals is to be performed"; throw BadFormat("");}
result.Marked=NULL;
result.currentIc=currentIc;
result.currentGender=currentGender;
result.currentAffectation=currentAffectation;
zap(rP);
zap(gP);
return result;
}
/*____________________________________________________________ */

GenomaSample::GenomaSample()
{
phenotypeSample=NULL;
genotypeSample=NULL;
currentIc=nobody;
currentGender=everyGender;
currentAffectation=allAffectation;
Marked=NULL;
};
/*____________________________________________________________ */
/*
GenomaSample::GenomaSample(GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling)
{
cout << "GenomaSample(GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling) non implemented. Try GenomaSample(GenomaSample& source, Container<set<SNPPos>, SNPPos>* SNPSampling)";
exit(0);
};
/*____________________________________________________________ */

GenomaSample::GenomaSample(GenomaSample& source, Container<set<SNPPos>, SNPPos>* SNPSampling, bool selectInds)
{
copy(source, SNPSampling, selectInds);
};

/*____________________________________________________________ */

GenomaSample::GenomaSample(GenomaSample& source, Container<set<string>, string>* selectedPositions, char* filePos)
{
if (selectedPositions==NULL)
{
copy(source);
return;
}
stringList* sourcePositions=new stringList(filePos, "", '\n');
intSet*selectedFilePositions=sourcePositions->copyPositionsWithElementsInSet(selectedPositions);
copy(source, selectedFilePositions);
zap(selectedFilePositions);
}
/*____________________________________________________________ */

GenomaSample::GenomaSample(PhenotypeSample& sourceP, GenotypeSample& sourceG)
{
phenotypeSample=new PhenotypeSample(sourceP);
genotypeSample=new GenotypeSample(sourceG);
currentIc=nobody;
currentGender=everyGender;
currentAffectation=allAffectation;
Marked=NULL;
};
/*____________________________________________________________ */

void GenomaSample::copy(GenomaSample& source, Container<set<SNPPos>, SNPPos>* SNPSampling, bool selectInds)
{
if ((source.genotypeSample==NULL) || (source.phenotypeSample==NULL))
 throw NullValue("GenomaSample::copy");
phenotypeSample=NULL;
genotypeSample=NULL;
Marked=NULL;
currentIc=source.currentIc;
currentGender=source.currentGender;
currentAffectation=source.currentAffectation;
if (selectInds) 
{
phenotypeSample=(PhenotypeSample*)source.phenotypeSample->copyElementsWithPositionsIn(SNPSampling);
genotypeSample=(GenotypeSample*)source.genotypeSample->copyElementsWithPositionsIn(SNPSampling);
} 
else
{
Marked=NULL;
currentIc=source.currentIc;
currentGender=source.currentGender;
currentAffectation=source.currentAffectation;
phenotypeSample=new PhenotypeSample(*source.phenotypeSample);
genotypeSample=new GenotypeSample(*source.genotypeSample, SNPSampling); 
//cout <<"genotypes are:" << *this <<"\n";
};
if (currentIc!=nobody) 
setMarked(currentIc); 
}

/*____________________________________________________________ */

GenomaSample::GenomaSample(char* filename, int*pos, int size, IndCategory ic, AlleleOrderType AlleleOrderMod)
{
try
{
phenotypeSample=new PhenotypeSample(filename);

genotypeSample=new GenotypeSample(filename, pos, size, AlleleOrderMod);
currentIc=ic;	
currentGender=everyGender;
currentAffectation=allAffectation;
Marked=NULL;				
if (currentIc!=nobody) 
setMarked(ic); 
//cout <<"genomaSample ended\n";
}
catch (BasicException& be){be.addMessage("\ncalled from GenomaSample::GenomaSample (char * filename, int*pos..."); throw;};
}
/*____________________________________________________________ */

void GenomaSample::setAffectationRandomly ()
{
phenotypeSample->setAffectationRandomly();
}

/*____________________________________________________________ */

GenomaSample* GenomaSample::setTransmissionRandomly (SNPPos firstSNP, SNPPos nextLastSNP)
{
GenomaSample* genomaSample=this->clone();
GenotypeSample* genotypeSample2=genomaSample->genotypeSample->setTransmissionRandomly(firstSNP, nextLastSNP);
//zap(genotypeSample2);
zap(genomaSample->genotypeSample);
//cout << "gg\n";
genomaSample->genotypeSample=genotypeSample2;
return genomaSample;
}

/*____________________________________________________________ */

GenomaSample* GenomaSample::permute ()
{
GenomaSample*  genomaSample=this->clone();
PhenotypeSample* phenotypeSample2=phenotypeSample->permute();
zap(phenotypeSample);
phenotypeSample=phenotypeSample2;
return genomaSample;
}
/*____________________________________________________________ */

void GenomaSample::setMarked(IndCategory ic, int gender, int affectation)
{
 if ((Marked!=NULL && (ic!=currentIc || gender!=currentGender || affectation != currentAffectation)) || Marked==NULL)
{
 if (Marked!=NULL) zaparr(Marked);
 Marked=Initialize(phenotypeSample->size(), true);
phenotypeSample->SetMarked(Marked, ic, gender, affectation);
// this has to be done because current marked settings have to be stored
currentIc=ic;
currentGender=gender;
currentAffectation=affectation;
}
//if (Marked!=NULL)
//for (int i=0; i<genotypeSample->size(); i++)
//cout <<" \n i:" << i << " is " << Marked[i];
}
/*____________________________________________________________ */

stringSample* GenomaSample::ExportForMLC (bool orderedByValue)
{
return ExportForMLCAndMLCHAP(MLC, ut, orderedByValue);
}
/*____________________________________________________________ */
/*
HeteroListPair<long long int, double>* GenomaSample::getHapCounts (const SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation,Transmission transmission, AlleleOrderType alleleOrderMode, int phaseMethod, MultidimensionalTable<double>* hapFreqs)
{

// It returns a map with those haplotypes existing in the sample (key is double) and their frequencies (an integer)
longLongList* haps=NULL;
long long int key;
longLongList::iterator it;
doubleList::iterator it2;
IndPos TotalInds=0; //=genotypeSample->GetHap(FirstSNP, LastSNP, IsMajor1, IsMajor2, Marked);
HeteroListPair<long long int, double>* result=new HeteroListPair<long long int, double>();
longLongList * keys=result->First;
doubleList* freqs=result->Second;
Container<vector, Genotype*>::iterator GenoPos=genotypeSample->getFirst();
Container<vector, Phenotype*>::iterator PhenoPos=phenotypeSample->getFirst();
Genoma* G;
Phenotype* phen;
int current=0;

while (GenoPos!=genotypeSample->end())
{
phen=phenotypeSample->getElement(PhenoPos); 
if (ic==offspring && phen->IsAChild() || ic==father && phen->IsAFather() || ic==mother && phen->IsAMother() || ic==everybody || (ic==parent && phen->IsAParent()))
if (phen->GetPhenotype().Gender==gender || gender==everyGender)
if (phen->getAffectation()==affectation || affectation==allAffectation)
{
haps=genotypeSample->getElement(GenoPos)->getHapCounts(pos, totalPos, genotypeSample->allAlleles, genotypeSample->totalAlleles, transmission, alleleOrderMode);  
int i;
for (int c=0; c<haps->size(); c++)// for each pair
{
key=haps->getElement(c);
if (key!=-1)
{
it=keys->findElement(key);
 if (it!=keys->end()) 
{
i=keys->getPosition(it);
if (transmission==ut & haps->size()==2)// EM or no ambiguous
(*freqs)[i]=(*freqs)[i]+1;
else // Zhao et al 2000 AJHG
if (transmission==ut)
(*freqs)[i]=(*freqs)[i]+2/(double)haps->size();
else (*freqs)[i]=(*freqs)[i]+2/(double)haps->size();
}
else 
{
keys->(key);
if (transmission==ut & haps->size()==2)// EM or no ambiguous
freqs->insertElement(1);
else 
if (transmission==ut)
freqs->insertElement(2/(double)haps->size());
else
freqs->insertElement(2/(double)haps->size());
}
}
}
zap(haps);
TotalInds=TotalInds+current;
delete G;
}
GenoPos=genotypeSample->getNext(GenoPos);
PhenoPos=phenotypeSample->getNext(PhenoPos);
}
return result;
}

/*____________________________________________________________ */

stringSample* GenomaSample::ExportForMLCAndMLCHAP (FormatType alg, Transmission trans, bool orderedByValue=false)
{
cout <<"Exporting to ML\n";
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
stringSample* l;
if (alg==MLCHAP) l=genotypeSample->ExportForMLHAP(trans);
else l=genotypeSample->ExportForML(orderedByValue);//ML
stringList* row;
char value;
string s;
PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst(); 
stringSample::iterator pList=l->getFirst();
Phenotype *p;
while (IndPhenotype!=phenotypeSample->end())
{
 row=l->getElement(pList);
 p=phenotypeSample->getElement(IndPhenotype);	
 if (p->IsAffected()) s= string("1"); else s= string("0");
 row->insertElement(s);
 pList=l->getNext(pList);
 IndPhenotype=phenotypeSample->getNext(IndPhenotype);
}

return l;
}
/*____________________________________________________________ */

stringSample* GenomaSample::ExportForMLCHAP (Transmission t)
{
return ExportForMLCAndMLCHAP(MLCHAP, t);
}

/*____________________________________________________________ */

stringSample* GenomaSample::ExportMetaForMLCAndMLCHAP (FormatType alg)
{
stringSample* l;
if (alg==MLCHAP) l=genotypeSample->ExportMetaForMLHAP();
else l=genotypeSample->ExportMetaForML();
stringList* row=new stringList();
string s=string("0 Class: 0, 1");
row->insertElement(s);
l->insertElement(row);
return l;
}
/*____________________________________________________________ */

stringSample* GenomaSample::ExportMetaForMLC ()
{
return ExportMetaForMLCAndMLCHAP(MLC);
}
/*____________________________________________________________ */

stringSample* GenomaSample::ExportMetaForMLCHAP ()
{
return ExportMetaForMLCAndMLCHAP(MLCHAP);
}
/*____________________________________________________________ */

SNPPos GenomaSample::GetTotalAllele (SNPPos SNP, allele allele1, const IndCategory ic, int gender, int affectation)
{
 setMarked(ic, gender, affectation);
 return genotypeSample->GetTotalAllele(SNP, allele1, Marked);
};
/*____________________________________________________________ */

allele GenomaSample::getMajorAllele (SNPPos SNP, const IndCategory ic, int gender, int affectation)
{
 setMarked(ic, gender, affectation);
 return genotypeSample->getMajorAllele(SNP, Marked);
};
/*____________________________________________________________ */

allele GenomaSample::getMinorAllele (SNPPos SNP, const IndCategory ic, int gender, int affectation)
{
 setMarked(ic, gender, affectation);
 return genotypeSample->getMinorAllele(SNP, Marked);
};


/*____________________________________________________________ */

void GenomaSample::WriteResults (char* filename, bool PrintPhenotypes, IndCategory ic, SNPPos first,SNPPos last, bool markUnphased)
 {
 if (genotypeSample->size()!=0) 
{
  PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst(); 
  GenotypeSample::iterator IndGenotype=genotypeSample->getFirst();
  Genotype* genotype;

  SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
  OpenOutput(filename, &OutputFile);
Phenotype *P;
while (IndPhenotype!=phenotypeSample->end() && IndGenotype!=genotypeSample->end())
  {
	P=phenotypeSample->getElement(IndPhenotype);
	 if ((ic==offspring && P->IsAChild ()) || (ic==parent && P->IsAParent ()) 
		|| (ic==everybody) || (ic==father && P->IsAFather()) || (ic==mother && P->IsAMother()))
	 {

	if (PrintPhenotypes==true) 
	OutputFile << P->PrintPhenotype() <<" ";
    genotype=genotypeSample->getElement(IndGenotype);
    OutputFile << genotype->print(first, last, markUnphased);
    OutputFile << "\n";
	 }
  IndGenotype=genotypeSample->getNext(IndGenotype);
  IndPhenotype=phenotypeSample->getNext(IndPhenotype);
  }
  OutputFile.close();
//cout << "\nInformation about phased genotype has been saved in file " << filename <<"\n";
}
 }


/*____________________________________________________________ */

void GenomaSample::RemoveByCategory (IndCategory ic=parent)
 {
  PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst(); 
  GenotypeSample::iterator IndGenotype=genotypeSample->getFirst();
  Genotype* genotype;
  Phenotype* P;

  SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
  while (IndPhenotype!=phenotypeSample->end() && IndGenotype!=genotypeSample->end())
  {
	P=phenotypeSample->getElement(IndPhenotype);
	 if ((ic==offspring && P->IsAChild ()) || (ic==parent && P->IsAParent ()) 
	 || (ic==everybody) || (ic==father && P->IsAFather()) || (ic==mother && P->IsAMother()))
	 {
	 genotypeSample->removeNode(IndGenotype);
 	 phenotypeSample->removeNode(IndPhenotype);
	 }
	
   IndGenotype=genotypeSample->getNext(IndGenotype);
   IndPhenotype=phenotypeSample->getNext(IndPhenotype);
	 
  }
 }


/*____________________________________________________________ */

Trio* GenomaSample::GetTrioMembers (PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype)
{
 Trio *T=new Trio(phenotypeSample, genotypeSample);
  if (phenotypeSample->getElement(IndPhenotype)->IsAChild())
  {
  T->trioPhenotype->SetChildPhenotype(IndPhenotype);
  T->trioGenotype->SetChildGenotype(IndGenotype);
  T->trioPhenotype->SetFatherPhenotype(phenotypeSample->GetFather(IndPhenotype));
  T->trioGenotype->SetFatherGenotype(genotypeSample->getNode(phenotypeSample->getPosition(T->getFatherPhenotype())));
  T->trioPhenotype->SetMotherPhenotype(phenotypeSample->GetMother(IndPhenotype));
  T->trioGenotype->SetMotherGenotype(genotypeSample->getNode(phenotypeSample->getPosition(T->getMotherPhenotype())));

//cout <<"written trio with child:"<< T <<"\n ";
  }
  if (phenotypeSample->getElement(IndPhenotype)->IsAFather()) 
  {
//cout <<"p\n";
  T->trioPhenotype->SetFatherPhenotype(IndPhenotype);
//cout <<"f\n";
  T->trioGenotype->SetFatherGenotype(IndGenotype);
//cout << "d\n";
//cout << "indp:" << **IndPhenotype <<"\n";
//cout << "firstchild: " << **phenotypeSample->getFirstChild(IndPhenotype) <<"\n";
  T->trioPhenotype->SetChildPhenotype(phenotypeSample->getFirstChild(IndPhenotype));
//cout << "ll\n";
//cout <<"child phenotype before:"<< *phenotypeSample->getFirstChild(IndPhenotype) << "\n";
  T->trioGenotype->SetChildGenotype(genotypeSample->getNode(phenotypeSample->getPosition(T->getChildPhenotype())));
//cout <<"child phenotype position:" << phenotypeSample->getPosition(T.getChildPhenotype()) <<"\n";
//cout <<"child phenotype after:" << phenotypeSample->getElement(phenotypeSample->getPosition(T.getChildPhenotype())) <<"\n";

//cout <<"child gentoypea after:" << *genotypeSample->getElement(phenotypeSample->getPosition(T.getChildPhenotype())) <<"\n";
//cout <<"child gentoypea afterfff:" << *genotypeSample->getElement(T.trioGenotype->GetChildGenotype());
  T->trioPhenotype->SetMotherPhenotype(phenotypeSample->GetCouple(IndPhenotype));
  T->trioGenotype->SetMotherGenotype(genotypeSample->getNode(phenotypeSample->getPosition(T->getMotherPhenotype())));
//cout <<"written trio with father:"<< T <<"\n ";
//end();

  }
  if (phenotypeSample->getElement(IndPhenotype)->IsAMother())
  {
//cout <<"m\n";
  T->trioPhenotype->SetMotherPhenotype(IndPhenotype);
  T->trioGenotype->SetMotherGenotype(IndGenotype);
  T->trioPhenotype->SetChildPhenotype(phenotypeSample->getFirstChild(IndPhenotype));
  T->trioGenotype->SetChildGenotype(genotypeSample->getNode(phenotypeSample->getPosition(T->getChildPhenotype())));
  T->trioPhenotype->SetFatherPhenotype(phenotypeSample->GetCouple(IndPhenotype));
  T->trioGenotype->SetFatherGenotype(genotypeSample->getNode(phenotypeSample->getPosition(T->getFatherPhenotype())));
//cout <<"written trio with mother:"<< T <<"\n ";

  }
  return T;
}
/*____________________________________________________________ */

IndPos GenomaSample::getTotalMarked ()
{
SNPPos total=0;
if (Marked!=NULL)
for (int i=0; i<phenotypeSample->size();i++)
 if (Marked[i]) total++;
return total;
}
/*____________________________________________________________ */

GenotypeSample::iterator GenomaSample::GetGenotype (PhenotypeSample::iterator p)
{
	return genotypeSample->getNode(phenotypeSample->getPosition(p));

}
/*____________________________________________________________ */

GenomaSample::~GenomaSample ()
{
zaparr(Marked);
zap(genotypeSample);
zap(phenotypeSample);
}

/*______________________________________________________*/

void GenomaSample::print(ostream& out)
       {
out << *phenotypeSample <<"\n";
out << *genotypeSample <<"\n";
};

};  // Fin del Namespace

#endif

/* Fin Fichero: GenomaSample.h */
