
/* File: GenomaSample.h */



#ifndef __GenomaSample_h__
#define __GenomaSample_h__


namespace BIOS {

class GenericSample;

class GenomaSample: public GenericSample {
	 
       //  public:


    /** @name Implementation of class GenomaSample
        @memo Private part.
    */

public:

PhenotypeSample* phenotypeSample;
GenotypeSample* genotypeSample;


GenomaSample* clone();

 void setMarked(IndCategory ic,  int gender=everyGender, int affectation=allAffectation);


  /* PUBLIC FUNCTIONS (INTERFACE) */

public:

virtual void print(ostream&);

  IndCategory currentIc;

//AlleleOrderType AlleleOrderMode;

  int currentGender, currentAffectation;

  bool *Marked;
    /**
	 @memo Destructor
	 @doc
           Deallocate memory used by individual.
           Time complexity O(1).

      */
	   ~GenomaSample ();

	  Trio* GetTrioMembers (PhenotypeSample::iterator IndPhenotype, GenotypeSample::iterator IndGenotype);

	   /**7
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */

  /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */

	  GenomaSample();

	
      GenomaSample(PhenotypeSample& sourceP, GenotypeSample& sourceG); 

      GenomaSample(GenomaSample& source, Container<set<SNPPos>, SNPPos>* SNPSampling=NULL, bool selectInds=false); 
      //GenomaSample(GenomaSample& source, Container<vector<SNPPos>, SNPPos>* SNPSampling); 

	GenomaSample(GenomaSample& source, Container<set<string>, string>* selectedPositions, char* filePos);
 /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */

//		GenomaSample(char* filename, unsigned short int ReduceSample, bool CompleteMissing, AlleleOrderType AlleleOrderMode);

		GenomaSample(char* filename, int*pos=NULL, int size=0, IndCategory ic=parent, AlleleOrderType AlleleOrderMode=MajorFirst);

void copy(GenomaSample& source, Container<set<SNPPos>, SNPPos>* SNPSampling=NULL, bool indPos=false); 


		GenotypeSample::iterator GetGenotype (PhenotypeSample::iterator p);

		void WriteResults (char* filename, bool PrintPhenotypes=true, IndCategory ic=everybody, SNPPos first=0,SNPPos last=-1, bool markUnphased=false);

		void RemoveByCategory (IndCategory ic);

		stringSample* ExportForMLC (bool);

		stringSample* ExportForMLCHAP (Transmission t);

		stringSample* ExportForMLCAndMLCHAP (FormatType alg, Transmission t, bool orderedByValue);

		stringSample* ExportMetaForMLCAndMLCHAP (FormatType alg);

		stringSample* ExportMetaForMLC ();

		stringSample* ExportMetaForMLCHAP ();

  int* countAlleles(const SNPPos *pos, int totalPos, IndCategory ic, int gender=everyGender, int affectation=allAffectation){	
	    	setMarked(ic, gender, affectation); return genotypeSample->countAlleles (pos, totalPos, Marked);};
; 

		SNPPos GetTotalAllele (SNPPos SNP, allele allele1, IndCategory ic, int gender=everyGender, int affectation=allAffectation);

		allele getMajorAllele (SNPPos SNP, const IndCategory ic, int gender=everyGender, int affectation=allAffectation);

		allele getMinorAllele (SNPPos SNP, const IndCategory ic, int gender=everyGender, int affectation=allAffectation);

//		SNPPos GetTotalType (SNPPos SNP, IndCategory ic, GenotypeType type, int gender=everyGender, int affectation=allAffectation) {	
//	    	setMarked(ic, gender, affectation); return genotypeSample->GetTotalType (SNP, type, Marked);};

		SNPPos GetTotalHomozygous1 (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->GetTotalHomozygous1(SNP, Marked);};

		SNPPos GetTotalHomozygous2 (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation){ setMarked(ic, gender, affectation); return genotypeSample->GetTotalHomozygous2(SNP, Marked);};

		SNPPos GetTotalHeterozygous (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation){ setMarked(ic, gender, affectation); return genotypeSample->GetTotalHeterozygous(SNP, Marked);};

		SNPPos GetTotalMissing (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation){ setMarked(ic, gender, affectation); return genotypeSample->getTotalMissing(SNP, Marked);};

  IndPos getTotalMissingGenotypes (IndCategory ic, int gender=everyGender, int affectation=allAffectation){ setMarked(ic, gender, affectation); return genotypeSample->getTotalMissingGenotypes(Marked);};

		SNPPos GetTotalNonMissing (SNPPos SNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation){ setMarked(ic, gender, affectation); return genotypeSample->getTotalNonMissing(SNP, Marked);};

//		SNPPos getPairwiseGenotype (PairedGenotype pg, SNPPos FirstSNP, SNPPos LastSNP, IndCategory ic, int gender=everyGender, int affectation=allAffectation){ setMarked(ic, gender, affectation); return genotypeSample->getPairwiseGenotype(pg, FirstSNP, LastSNP, Marked);};

//		SNPPos GetDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, int gender=everyGender, int affectation=allAffectation){ setMarked(ic, gender, affectation); return genotypeSample->getDoubleHeterozygous(FirstSNP, LastSNP, i, j, Marked);};

//		SNPPos GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, bool phase, int gender=everyGender, int affectation=allAffectation, AlleleOrderType alleleOrderType=LeftRight){ setMarked(ic, gender, affectation); return genotypeSample->GetUnsolvedDoubleHeterozygous(FirstSNP, LastSNP, i, j, alleleOrderType, Marked);};

    		SNPPos* getAlleleFrequencies(allele alleleType, IndCategory ic,  int gender=everyGender, int affectation=allAffectation) {setMarked(ic, gender, affectation);
		return genotypeSample->getAlleleFrequencies(alleleType, Marked);};

		//void ComputeHaps (hprobs probs, SNPPos SNP1, SNPPos SNP2, LDType mode, bool Semi, unsigned short int Bayes);
/*
		double GetHap (SNPPos FirstSNP, SNPPos LastSNP, IndCategory ic, allele allele1, allele allele2, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->GetHap(FirstSNP, LastSNP, allele1, allele2, transmission, Marked);};

		double GetnAB(SNPPos SNP1, SNPPos SNP2, IndCategory ic, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->GetnAB(SNP1, SNP2, transmission, Marked);};

		double GetnAb(SNPPos SNP1, SNPPos SNP2, IndCategory ic, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->GetnAb(SNP1, SNP2, transmission, Marked);};

		double GetnaB(SNPPos SNP1, SNPPos SNP2, IndCategory ic, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->GetnaB(SNP1, SNP2, transmission, Marked);};
		
		double Getnab(SNPPos SNP1, SNPPos SNP2, IndCategory ic, Transmission transmission, int gender=everyGender, int affectation=allAffectation) { setMarked(ic, gender, affectation); return genotypeSample->Getnab(SNP1, SNP2, transmission, Marked);};
*/
        //        GenomaSample* copyElementsWithPositionsIn(intSet* positions, bool inThis=true);

IndPos getTotalMarked();		
GenomaSample* permute();

void setAffectationRandomly ();

GenomaSample* setTransmissionRandomly (SNPPos firstSNP=0, SNPPos nextLastSNP=0);

//HeteroListPair<long long int, double>* getHapCounts (const SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation,Transmission transmission, AlleleOrderType alleleOrderMode, int phaseMethod, MultidimensionalTable<double>* hapFreqs=NULL);

//  void SNPSampling (Container<vector,SNPPos> *Sampling);


};  // End of class GenomaSample

ostream& operator<<(ostream& out, GenomaSample& genomaSample)
       {
PhenotypeSample::iterator p=genomaSample.phenotypeSample->getFirst();
GenotypeSample::iterator g=genomaSample.genotypeSample->getFirst();

while (p!=genomaSample.phenotypeSample->end())
{
out << *genomaSample.phenotypeSample->getElement(p) << genomaSample.genotypeSample->outputSeparator  << *genomaSample.genotypeSample->getElement(g);
++p;
++g;
}
       

  return out;
  }

};  // Fin del Namespace

#endif

/* Fin Fichero: GenomaSample.h */
