/* File: Genotype.cpp */


#ifndef __Genotype_cpp__
#define __Genotype_cpp__




//using namespace UTILS;


namespace BIOS {

/*________________________________________________________________________________________*/

Genotype* Genotype::fromString (string source)
{
try
{
 //cout << "source is " << source << "\n";
	Genotype* targetGenotype=NULL; 
	Container<vector<Diplotype*>, Diplotype*> *DiplotypeList=GenotypeSample::readDiplotype(source.c_str(), source.length()+1);
  if (DiplotypeList==NULL) throw NullValue("Genotype* Genotype::fromString (string source)");
	SNPPos cont=0, position, TotalSNPs=DiplotypeList->size();
	targetGenotype= new Genotype(TotalSNPs);
		Container<vector<Diplotype*>, Diplotype*>::iterator p=DiplotypeList->getFirst();
	while (p!=DiplotypeList->end())
	{
		targetGenotype->SetDiplotype(DiplotypeList->getElement(p), cont);
		p=DiplotypeList->getNext(p);
		cont++;
	};
zap(DiplotypeList);
return targetGenotype;
}
catch (BasicException& be){be.addMessage("\ncalled from  Genotype* Genotype::fromString (string source)"); throw;};
 };

/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/
/*
void Genotype::copyDiplotypeArray (Diplotype ** DiplotypeArraySource)
{
try
{
if (this->DiplotypeArray!=NULL) throw BadFormat("void Genotype::copy (Diplotype ** DiplotypeArraySource)");
if (DiplotypeArraySource==NULL) return; 
 if ((this->DiplotypeArray=new Diplotype* [TotalSNPs])==NULL)
	throw NoMemory("Genotype::copy");
for (SNPPos i=0;i<TotalSNPs;i++)
 this->DiplotypeArray[i]=new Diplotype(*DiplotypeArraySource[i]);
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::copy"); throw;}
}


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

Genotype::Genotype()
{
this->DiplotypeArray=NULL;
this->TotalSNPs=0;
}
/*____________________________________________________________ */

Genotype::Genotype(SNPPos TotalS)
{
this->TotalSNPs=TotalS;
try
{
 if ((this->DiplotypeArray=new Diplotype* [TotalSNPs])==NULL)
	throw NoMemory("Genotype::Genotype(SNPPos TotalS)");
 for (int i=0; i<TotalSNPs; i++) this->DiplotypeArray[i]=NULL;//new Diplotype((allele)1, (allele)1);//NULL;
 
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::Genotype"); throw;}
}
/*____________________________________________________________ */

void Genotype::changePhase()
{
for (int i=0; i<TotalSNPs; i++)
 ChangeAlleles(i);
}
/*____________________________________________________________ */

Genotype::Genotype(const Genotype & Source, Container<set<SNPPos>, SNPPos> *sampling)
{
this->DiplotypeArray=NULL;
if (sampling==NULL)
{
this->TotalSNPs=Source.TotalSNPs;
if (Source.DiplotypeArray!=NULL) 
{
// if ((
this->DiplotypeArray=new Diplotype* [this->TotalSNPs]; //)//==NULL)
//	throw NoMemory("Genotype::copy");
for (SNPPos i=0;i<this->TotalSNPs;i++)
if (Source.DiplotypeArray[i]==NULL)
throw NullValue("Genotype::Genotype(const Genotype & Source, Container<set<SNPPos>, SNPPos> *sampling)");
else this->DiplotypeArray[i]=new Diplotype(*Source.DiplotypeArray[i]);
}

}
else
{
this->TotalSNPs=sampling->size();

 if ((this->DiplotypeArray=new Diplotype* [this->TotalSNPs])==NULL)
	throw NoMemory();

int i=0;
for (Container<set<SNPPos>, SNPPos>::iterator p=sampling->getFirst();p!=sampling->end(); p++)
{
if (sampling->getElement(p) >= Source.TotalSNPs)
throw OutOfRange<int>(Source.TotalSNPs,"Genotype(const Genotype & Source, Container<set<SNPPos>, SNPPos> *sampling)");
 this->DiplotypeArray[i]=new Diplotype(*Source.DiplotypeArray[sampling->getElement(p)]);
i++; 
}
 }
}
/*____________________________________________________________ */

Genotype* Genotype::clone()
{
return new Genotype(*this);
}

/*____________________________________________________________ */
/*
Genotype& Genotype::operator=(const Genotype & Source)
{
  if (this!=&Source)  
  {
  TotalSNPs=Source.TotalSNPs;
  zaparr(DiplotypeArray);
  copyDiplotypeArray (Source.DiplotypeArray);
  } 
  return *this;
}
/*____________________________________________________________ */

Genotype::~Genotype()
{
if (this->DiplotypeArray!=NULL)
{
//cout <<"hhhere\n";
for (int i=0; i<TotalSNPs; i++)
zap (this->DiplotypeArray[i]);

delete [] this->DiplotypeArray;
}
this->DiplotypeArray=NULL;
//cout <<"genotype will be erased\n"; 
//cout <<"total nnos is:" << TotalSNPs <<"\n";
//zaparr (this->DiplotypeArray, TotalSNPs);
}
/*_____________________________________________________*/

	  
Genotype* Genotype::filter (const int *positions, int length)
{
Genotype* result=new Genotype(length);
for (int i=0; i<length;i++)
{
if (positions[i]<0 || positions[i]>=TotalSNPs)
 throw OutOfBounds(positions[i], TotalSNPs, "Genotype::filter (int *positions, int length)");
result->DiplotypeArray[i]=this->DiplotypeArray[positions[i]]->clone();
}
return result;
}
/*____________________________________________________________ */

SNPPos Genotype::hasMajorMajor (allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2)      
{
return (D1.getLeftAllele()==MajorAllele1 && D2.getLeftAllele()==MajorAllele2) 
		|| (D1.getRightAllele()==MajorAllele1 && D2.getRightAllele()==MajorAllele2); 
}
/*____________________________________________________________ */

SNPPos Genotype::isMajorMajor (allele MajorAllele1, allele MajorAllele2, Diplotype D1, Diplotype D2, bool left)      
{
return (left && D1.getLeftAllele()==MajorAllele1 && D2.getLeftAllele()==MajorAllele2) 
  || (!left && D1.getRightAllele()==MajorAllele1 && D2.getRightAllele()==MajorAllele2); 
}
/*____________________________________________________________ */

SNPPos Genotype::isAlleleAllele (allele allele1, allele allele2, Diplotype D1, Diplotype D2, bool left)      
{
return (left && D1.getLeftAllele()==allele1 && D2.getLeftAllele()==allele2) 
  || (!left && D1.getRightAllele()==allele1 && D2.getRightAllele()==allele2); 
}

/*____________________________________________________________ */

SNPPos Genotype::hasAlleleAllele (allele allele1, allele allele2, Diplotype D1, Diplotype D2)      
{
return (D1.getLeftAllele()==allele1 && D2.getLeftAllele()==allele2) 
  || (D1.getRightAllele()==allele1 && D2.getRightAllele()==allele2); 
}

/*____________________________________________________________ */

SNPPos Genotype::GetTotalSNPs()
{
return	this->TotalSNPs;
}
/*____________________________________________________________ */

SNPPos Genotype::GetTotalHeterozygousPos()
{
SNPPos total=0;
Diplotype *D;
for (SNPPos i=0;i<TotalSNPs;i++)
{
 D=getDiplotype(i);
 if (D->isHeterozygous())
  total++;
}
return total;
}

/*____________________________________________________________ */

void Genotype::OrderMajorFirst(allele * * allAlleles)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions
try
{
if (DiplotypeArray==NULL)
 throw NullValue("Genotype::OrderMajorFirst(allele * * allAlleles)");
for (SNPPos i=0; i<TotalSNPs;i++)
// cout << DiplotypeArray[i].print(); //
DiplotypeArray[i]->OrderMajorFirst(allAlleles[i][0]);
; //cout << "\n";
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::copy"); throw;}
}
/*____________________________________________________________ */

bool Genotype::isMissing (SNPPos SNP)
{
return getDiplotype(SNP)->isAMissingSNP();
}
/*____________________________________________________________ */

bool Genotype::isHeterozygous(SNPPos SNP)
{
return getDiplotype(SNP)->isHeterozygous();
}
/*____________________________________________________________ */

bool Genotype::isHomozygous(SNPPos SNP)
{
return getDiplotype(SNP)->isHomozygous();
}
/*____________________________________________________________ */

void Genotype::OrderRandomly(allele ** allAlleles)
{
	// for those heterozygous positions, rewrite alleles randomly

for (SNPPos i=0; i<TotalSNPs;i++)
 DiplotypeArray[i]->OrderRandomly(allAlleles[i][0]);

}
/*____________________________________________________________ */

void Genotype::ChangeAlleles(SNPPos SNP)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions
 DiplotypeArray[SNP]->changeAlleles();
}
/*____________________________________________________________ */

void Genotype::markAlleles(SNPPos SNP)
{
	// for those heterozygous positions, rewrite first MajorAllele, second Minor Allele.
	// NOT implemented: if only one allele is missing, write it in the second positions

 DiplotypeArray[SNP]->markAlleles();

}
/*____________________________________________________________ */

bool Genotype::IsMarked(SNPPos SNP)
{

 return DiplotypeArray[SNP]->IsMarked();

}
/*__________________________________________________________*/

void Genotype::CheckRangeSNP(SNPPos SNP)
{
if (this->TotalSNPs==0) throw ZeroValue("void Genotype::CheckRangeSNP(SNPPos SNP)");
if (SNP>=TotalSNPs || SNP<0) throw OverflowedSNP(SNP, TotalSNPs, " Genotype::CheckRangeSNP");
}
/*__________________________________________________________*/

Diplotype* Genotype::getDiplotype(SNPPos SNP)
{
try
{
CheckRangeSNP(SNP);
if (DiplotypeArray==NULL) throw NullValue("Genotype::getDiplotype(SNPPos SNP)");
return DiplotypeArray[SNP];
}
catch (OverflowedSNP & os) {os.addMessage("\ncalled from Genotype::getDiplotype"); throw;}
}
/*__________________________________________________________*/

void Genotype::SetAlleles(allele Left, allele Right, SNPPos SNP)
{
try
{
CheckRangeSNP(SNP);
DiplotypeArray[SNP]->setLeftAllele(Left);
DiplotypeArray[SNP]->setRightAllele(Right);
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::SetAlleles"); throw;}
}
/*__________________________________________________________*/

void Genotype::SetDiplotype(Diplotype* Dip, SNPPos SNP)
{
try
{
CheckRangeSNP(SNP);
if (this->DiplotypeArray==NULL)
throw NullValue("Genotype::SetDiplotype(Diplotype* Dip, SNPPos SNP)");
this->DiplotypeArray[SNP]=new Diplotype(*Dip);
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::SetDiplotype"); os.PrintMessage(); throw;}
}
/*_____________________________________________________________*/

bool Genotype::HaveTheSameHomoPos(Genotype OtherGenotype, SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles)
{
// 
if (TotalPos!=sizeof(Pos) || TotalPos>TotalSNPs)
{
	cerr << "in HaveTheSameHomoPos";
	exit(0);
};

SNPPos i=0;
Diplotype* OtherDip;
while (i<TotalPos)
{
 OtherDip=OtherGenotype.getDiplotype(Pos[i]);
 if (*DiplotypeArray[Pos[i]]!= *OtherDip)      
 return false;
 i++;
}
return true;
}
/*_____________________________________________________________*/

long long int Genotype::getGenotypeCounts (const SNPPos Pos[], SNPPos TotalPos, allele** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, AlleleOrderType alleleOrderMode, bool onlyHetero, bool includeMissing) 
// It returns the genotype position in the current genotype. If any genotype is missing and !includeMissing, it will return -1 
// If onlyHetero && IsHomozygous(), it will return -1
{
try
{
int* res=getGenotypeCountsArray(Pos, TotalPos, allAlleles, totalAlleles, tableGenotypes, alleleOrderMode, onlyHetero, includeMissing);
long long int result;
//cout <<"taqblegen:" << *tableGenotypes <<"\n";
//for (int i=0; i<TotalPos; i++)
//cout <<"res is: " << res[i] <<"\n";
if (res!=NULL) result=tableGenotypes->getPos(res); else result=-1;
//if (result<0) throw OutOfRange<long long int>(result, "Genotype::getGenotypeCounts, genotypes are too long"); 
//cout <<"dddd\n";
zaparr(res);
return result;
}
catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::getGenotypeCounts"); throw;}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from Genotype::getGenotypeCounts"); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from Genotype::getGenotypeCounts"); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from Genotype::getGenotypeCounts"); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from Genotype::getGenotypeCounts"); throw;}
};  

/*_____________________________________________________________*/

int*  Genotype::getGenotypeCountsArray(const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles, AmbiguousArray* tableGenotypes, AlleleOrderType alleleOrderMode, bool onlyHetero, bool includeMissing)  
// It returns the genotype positions for the current genotype. If genotype at any position is missing and !includeMissing, it will return NULL
{
try
{
if (1==0)
if (includeMissing) 
{
cout << "Missing values cannot be handle so far\n";
throw NonImplemented();
}
SNPPos pos1=0, pos2=0, cont=0, i=0;
Diplotype *D;
int allPos1, allPos2, *positions=new int[TotalPos];

bool isHomo=true;
if (onlyHetero)
{
for (int i=0; i<TotalPos; i++)
{
D=getDiplotype(Pos[i]);
if (D->isHeterozygous())
isHomo=false;
}
if (isHomo)
{
zaparr(positions);
return NULL;
}
}

for (int i=0; i<TotalPos; i++)
{
D=getDiplotype(Pos[i]);
if (!includeMissing && D->isAMissingSNP()) 
{
zaparr(positions);
return NULL;
}
else//positions[i]=getTotalGenotypes(totalAlleles[Pos[i]]);
{
if (Pos[i]<0 || Pos[i]>=TotalSNPs) throw OutOfBounds(Pos[i], TotalSNPs, "Genotype::getGenotypeCountsArray");
allPos1=MAXINT;
allPos2=MAXINT;
for (int j=0; j<totalAlleles[Pos[i]]; j++)
{
//cout << "\ntotalalleles at pos:" << Pos[i] <<": " << totalAlleles[Pos[i]] <<" val is:" << allAlleles[Pos[i]][j] <<" while actual left is: " << D->getLeftAllele() << " and actual right is: " << D->getRightAllele();
if (allAlleles[Pos[i]][j]==(D->getLeftAllele())) allPos1=j;
else if ((int)allAlleles[Pos[i]][j]==abs((int)D->getLeftAllele())) allPos1=-j;
if (allAlleles[Pos[i]][j]==(D->getRightAllele())) allPos2=j;
else if ((int)allAlleles[Pos[i]][j]==abs((int)D->getRightAllele())) allPos2=-j;
}
if (allPos1==MAXINT) 
{
cout <<"vals at SNP pos " << Pos[i] <<" are:\n";
for (int j=0; j<totalAlleles[Pos[i]]; j++)
cout <<allAlleles[Pos[i]][j] << " ";
throw OutOfBounds ((int)D->getLeftAllele(),totalAlleles[Pos[i]], "1. Genotype::getGenotypeCountsArray...");
}
if (allPos2==MAXINT) 
{
cout <<"vals at SNP pos " << Pos[i] <<" are:\n";
for (int j=0; j<totalAlleles[Pos[i]]; j++)
cout <<allAlleles[Pos[i]][j] << " ";
throw OutOfBounds ((int)D->getRightAllele(),totalAlleles[Pos[i]], "2. Genotype::getGenotypeCountsArray...");
}
if (alleleOrderMode==LeftRight) {allPos1=abs(allPos1); allPos2=abs(allPos2); };
positions[i]=tableGenotypes->getAmbiguousPosition(allPos1, allPos2, i);
//cout << " pos at: " << i << ": " << positions[i] <<", ";
}
//cout <<"\nals are:" << allPos1 << " and " << allPos2;
//cout << "\n pos at :" << i <<": " << positions[i];
}
return positions; 
}
catch (NonImplemented & ni){ni.addMessage("\ncalled from Genotype::getGenotypeCountsArray"); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from Genotype::getGenotypeCountsArray..."); throw;}
catch (ORLLI & e) 
{
//cout << "\ntotalalleles at pos:" << Pos[i] <<": " << totalAlleles[Pos[i]] <<" val is:" << allAlleles[Pos[i]][j] <<" while actual left is: " << D->getLeftAllele() << " and actual right is: " << D->getRightAllele();
e.addMessage("\ncalled from Genotype::getGenotypeCountsArray..."); 
throw;
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::getGenotypeCountsArray"); throw;}
}

/*_____________________________________________________________*/

void Genotype::CountGenotypes(MultidimensionalTable<double>* Genotypes, const SNPPos Pos[], SNPPos TotalPos, allele ** allAlleles, int* totalAlleles,  AmbiguousArray* tableGenotypes) 
// Haps is a multidimensionalTable with the TotalPos dimensions and 10 values each dimension (considering multiallelic SNPs)
{
SNPPos pos1=0, pos2=0, cont=0;
bool missing=false;
bool FoundHetero=false;
//SNPPos TotalSNPs=GetTotalSNPs();
SNPPos i=0;
Diplotype *D;
int allPos1, allPos2;
int *positions=new int[TotalPos];
for (int i=0; i<TotalPos; i++)
{
D=getDiplotype(Pos[i]);
if (D->isAMissingSNP()) missing=true;
else//positions[i]=getTotalGenotypes(totalAlleles[Pos[i]]);
{
for (int j=0; j<totalAlleles[Pos[i]]; j++)
{
if (allAlleles[Pos[i]][j]==D->getLeftAllele()) allPos1=j;
if (allAlleles[Pos[i]][j]==D->getRightAllele()) allPos2=j;
};
positions[i]=tableGenotypes->getAmbiguousPosition(allPos1, allPos2, Pos[i]);
}
}
if (!missing) Genotypes->addValue(positions, 1);
zaparr(positions);
};  

/*____________________________________________________________ */

string Genotype::print(SNPPos first, SNPPos last, bool markUnphased)
{
SNPPos L=last;
if (L==-1) L=TotalSNPs-1;
string result=string("");
     if (DiplotypeArray==NULL) {cout << "null diplotype vector";exit(0);}

for (SNPPos i=first;i<=L;i++)
{
 result=result+printSNP(i, markUnphased);
}
return result;

}
/*____________________________________________________________ */

string Genotype::printSNP(SNPPos snp, bool markUnphased)
{
char *l;
	 if ((l=new char [5])==NULL)
	throw NoMemory();
sprintf(l, "%d %d ", DiplotypeArray[snp]->getLeftAllele(), DiplotypeArray[snp]->getRightAllele());
 string s=string(l);
 zaparr(l);
return s;
}
/*____________________________________________________________ */

string Genotype::print(HaplotypeType h)
{
char *l;
	 if ((l=new char [TotalSNPs*5])==NULL)
	throw NoMemory();
	
strcpy(l, "\0");
for (SNPPos i=0;i<TotalSNPs;i++)
 strcat(l, print(i, h).c_str());
 string s=string(l);
 zaparr(l);
return s;
}

/*___________________________________________________*/

bool Genotype::IsHomozygous1Homozygous1 (SNPPos position, SNPPos position2, allele allele1, allele allele2)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->isHomozygous1(allele1) && D2->isHomozygous1(allele2);
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsHomozygous1Homozygous1"); throw;}
};
/*___________________________________________________*/

bool Genotype::IsHomozygousHomozygous (SNPPos position, SNPPos position2)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->isHomozygous() && D2->isHomozygous();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsHomozygousHomozygous"); throw;}
};
/*__
};
/*___________________________________________________*/

bool Genotype::IsHomozygous1Heterozygous (SNPPos position, SNPPos position2, allele oneAllele)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->isHomozygous1(oneAllele) && D2->isHeterozygous();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsHomozygous1Heterozygous"); throw;}
};
/*__
}
/*___________________________________________________*/

bool Genotype::IsHeterozygousHomozygous1 (SNPPos position, SNPPos position2, allele oneAllele)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->isHeterozygous() && D2->isHomozygous1(oneAllele);
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsHeterozygousHomozygous1"); throw;}
};
/*__
};

/*___________________________________________________*/

bool Genotype::IsHomozygousHeterozygous (const SNPPos position, SNPPos position2)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D2->isHeterozygous() && D->isHomozygous();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsHomozygousHeterozygous"); throw;}
};
/*___________________________________________________*/

bool Genotype::IsHeterozygousHomozygous (const SNPPos position, SNPPos position2)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->isHeterozygous() && D2->isHomozygous();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsHeterozygousHomozygous"); throw;}
};

/*___________________________________________________*/

bool Genotype::IsHeterozygousHeterozygous (const SNPPos position, SNPPos position2)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->isHeterozygous() && D2->isHeterozygous();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsHeterozygousHeterozygous"); throw;}
};
/*___________________________________________________*/
/*
bool Genotype::IsHeterozygousHeterozygous (const SNPPos position, SNPPos position2, MultiallelicHetero i, MultiallelicHetero j, allele* alleles1, allele* alleles2, int totalAlleles1, int totalAlleles2)      
{
CheckRangeSNP(position, "IsHetHet");
CheckRangeSNP(position2, "IsHetHet2");

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->isHeterozygous(i, alleles1, totalAlleles1) && D2->isHeterozygous(j, alleles2, totalAlleles2);
};


/*___________________________________________________*/

bool Genotype::IsMissingMissing (const SNPPos position, SNPPos position2)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->isAMissingSNP() && D2->isAMissingSNP();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsMissingMissing"); throw;}

};

/*___________________________________________________*/

bool Genotype::IsNotMissingNotMissing (const SNPPos position, SNPPos position2)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->isANonMissingSNP() && D2->isANonMissingSNP();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsNotMissingNotMissing"); throw;}


};

/*___________________________________________________*/

bool Genotype::IsHomozygous1Missing (const SNPPos position, SNPPos position2, allele oneAllele)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->isHomozygous1(oneAllele) && D2->isAMissingSNP();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsHomozygous1Missing"); throw;}
};
/*___________________________________________________*/

bool Genotype::IsMissingHomozygous1 (const SNPPos position, SNPPos position2, allele oneAllele)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->isAMissingSNP() && D2->isHomozygous1(oneAllele);
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsMissingHomozygous1"); throw;}

};
/*___________________________________________________*/

bool Genotype::IsHeterozygousMissing (const SNPPos position, SNPPos position2)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype *D=DiplotypeArray[position];
Diplotype *D2=DiplotypeArray[position2];

return D->isHeterozygous() && D2->isAMissingSNP();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsHeterozygousMissing"); throw;}

};
/*___________________________________________________*/

bool Genotype::IsMissingHeterozygous (const SNPPos position, SNPPos position2)      
{
try
{
CheckRangeSNP(position);
CheckRangeSNP(position2);

Diplotype* D=DiplotypeArray[position];
Diplotype* D2=DiplotypeArray[position2];

return D->isAMissingSNP() && D2->isHeterozygous();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsMissingHeterozygous"); throw;}

};
/*___________________________________________________*/

allele Genotype::getLeftAllele (const SNPPos position)      
{
try
{
CheckRangeSNP(position);
return DiplotypeArray[position]->getLeftAllele();
}
catch (BasicException& be){be.addMessage("\ncalled from allele Genotype::getLeftAllele (const SNPPos position)      "); throw;};};
/*___________________________________________________*/

allele Genotype::getRightAllele (const SNPPos position)      
{
try
{
CheckRangeSNP(position);
return DiplotypeArray[position]->getRightAllele();
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::getRightAllele"); throw;}
};
/*___________________________________________________*/

bool Genotype::IsPhaseKnown (const SNPPos SNP1, const SNPPos SNP2, AlleleOrderType alleleOrderMode)      
{
SNPPos pos[2];
pos[0]=SNP1;
pos[1]=SNP2;
return IsPhaseKnown(pos, 2, alleleOrderMode);
}
/*___________________________________________________*/

bool Genotype::hasMissingSNPs (const SNPPos *pos, SNPPos totalPos)      
{
try
{
SNPPos i=0;
Diplotype *D;
while (i<totalPos)
{
CheckRangeSNP(pos[i]);
D=getDiplotype(pos[i]);
if (D->isAMissingSNP()) return true;
i++;
}
return false;
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::hasMissingSNPs"); throw;}

}
/*___________________________________________________*/

bool Genotype::IsPhaseKnown (const SNPPos *pos, SNPPos totalPos, AlleleOrderType alleleOrderType)      
{
try
{
if (alleleOrderType==LeftRight) return true;
bool KnownHap=true;
bool FoundHetero=false;
SNPPos i=0;
Diplotype *D;
while (KnownHap==true && i<totalPos)
{
CheckRangeSNP(pos[i]);
D=getDiplotype(pos[i]);
if (D->isAMissingSNP()) return false;
if (D->isHeterozygous() && FoundHetero==true) return false;
if (D->isHeterozygous() && FoundHetero==false) FoundHetero=true;
i++;
}
return true;
}
 catch (OverflowedSNP & os) {
		 os.addMessage("\ncalled from Genotype::IsPhaseKnown"); throw;}
}

/*___________________________________________________*/
/*
double Genotype::GetHap (SNPPos SNP1, SNPPos SNP2, allele allele1, allele allele2, allele ** allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType alleleOrderMode)      
{
CheckRangeSNP(SNP1, "GetHap");
CheckRangeSNP(SNP2, "GetHap2");
BidimensionalTable<int>* table=new BidimensionalTable<int>(totalAlleles[SNP1], totalAlleles[SNP2]);
int al1, al2;
for (int i=0; i<4; i++)
{
if (allAlleles[SNP1][i]==allele1) al1=i;
if (allAlleles[SNP2][i]==allele2) al2=i;
}
int totalPos=2;
int pos[2];
pos[0]=SNP1;
pos[1]=SNP2;
double result=0;
int* position;
longLongList* res=getHapCounts(pos, totalPos, allAlleles, totalAlleles, transmission, alleleOrderMode);
for (int i=0; i<res->size(); i++)
if (res->getElement(i)!=-1) 
{
position=table->getPositions(res->getElement(i));
if (res->size()<=2)
if (position[0]==al1 && position[1]==al2) result++; 
else if (position[0]==al1 && position[1]==al2) result=result+2*((double)1/(double)res->size()); 

zaparr(position);
}
zap(table);
zap(res);
return result;
};

/*___________________________________________________*/
/*
double Genotype::GetAB (SNPPos SNP1, SNPPos SNP2, allele* *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)      
{
	CheckRangeSNP(SNP1, "GetAB");
	CheckRangeSNP(SNP2, "GetAB2");

	return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][0], allAlleles, totalAlleles, transmission, AlleleOrderMode);
}
/*___________________________________________________*/
/*
double Genotype::GetAb (SNPPos SNP1, SNPPos SNP2, allele * *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)      
{
	CheckRangeSNP(SNP1, "GetAb");

	CheckRangeSNP(SNP2, "GetAb2");

	return GetHap(SNP1, SNP2, allAlleles[SNP1][0], allAlleles[SNP2][1], allAlleles, totalAlleles, transmission, AlleleOrderMode);
}/*___________________________________________________*/
/*
double Genotype::GetaB (SNPPos SNP1, SNPPos SNP2, allele * *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)      
{
CheckRangeSNP(SNP1, "GetaB");

CheckRangeSNP(SNP2, "GetaB2");

return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][0], allAlleles, totalAlleles, transmission, AlleleOrderMode);
}/*___________________________________________________*/
/*
double Genotype::Getab (SNPPos SNP1, SNPPos SNP2, allele * *allAlleles, int* totalAlleles, Transmission transmission, AlleleOrderType AlleleOrderMode)      
{
	CheckRangeSNP(SNP1, "Getab");

	CheckRangeSNP(SNP2, "Getab2");

	return GetHap(SNP1, SNP2, allAlleles[SNP1][1], allAlleles[SNP2][1], allAlleles, totalAlleles, transmission, AlleleOrderMode);
}

/*____________________________________________________________ */

Diplotype** Genotype::GetGenotype ()
{
	return DiplotypeArray;
}
/*____________________________________________________________ */

Haplotype* Genotype::getLeftHaplotype ()
{
	return getHaplotype(true);
}
/*____________________________________________________________ */

Haplotype* Genotype::getRightHaplotype ()
{
	return getHaplotype(false);
}
/*____________________________________________________________ */

Haplotype* Genotype::getHaplotype (bool left)
{
try
{
Haplotype* result=new Haplotype(TotalSNPs);
for (int i=0; i<TotalSNPs; i++)
if (left) result->alleleArray[i]=(base)getLeftAllele(i);
else result->alleleArray[i]=(base)getRightAllele(i);
	return result;
	}
	catch (BasicException& be){be.addMessage("\ncalled from Haplotype* Genotype::getHaplotype (bool left) "); throw;};
}
/*___________________________________________________*/

bool Genotype::CanBeSolved (SNPPos SNP1, SNPPos SNP2, AlleleOrderType alleleOrderMode)      
{
	return IsPhaseKnown(SNP1, SNP2, alleleOrderMode);
}

/*___________________________________________________*/

SNPPos Genotype::getFirstHeterozygous ()      
{
	SNPPos SNP=0;
	while (SNP<TotalSNPs)
	{
		if (getDiplotype(SNP)->isHeterozygous ())
			return SNP;
		 SNP++;
	}
	return SNP;
}

/*___________________________________________________*/


ostream& operator<<(ostream& out, Genotype& genotype)
       {
     if (genotype.DiplotypeArray==NULL) out << "null diplotype vector";

int last=genotype.TotalSNPs;
if (genotype.DiplotypeArray!=NULL)
for (SNPPos i=0;i<last;i++)
{
 out << *genotype.DiplotypeArray[i];
 if (i<(last-1)) out  <<" "; else out <<"\n";
}
return out;
}
/*___________________________________________________*/

};  // End of Namespace

#endif

/* End of file: Genotype.h */




