/* File: Haplotype.h */


#ifndef __Haplotype_h__
#define __Haplotype_h__

//using namespace UTILS;


namespace BIOS {


/************************/
/* SNP'S Haplotype DEFINITION */
/************************/


/**
        @memo Haplotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/

 
class Haplotype {


private:
    /** @name Implementation of class Haplotype
        @memo Private part.
    */

	

 //  char* line;
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */




		/* PUBLIC FUNCTIONS (INTERFACE) */

public:

base* alleleArray;

	SNPPos totalSNPs;

      /** @name Operations on Haplotype 
        @memo Operations on a Haplotype 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */
Haplotype();

Haplotype(base* source, SNPPos TotalSNPs);
	
Haplotype(SNPPos TotalSNPs);

//Haplotype (const Haplotype& Source);

Haplotype* filter(int *positions, int length);

Haplotype(const Haplotype & Source);

void checkRangeSNP(SNPPos SNP);

void checkBase(SNPPos SNP);
      /**
	 @memo Destructor
	 @doc
           Deallocate memory used by snps.
           Time complexity O(1).

      */
~Haplotype ();

      /**
         @memo Assignation
         @param g Haplotype to copy.
         @return Reference to the receptor Haplotype.
	 @doc
           Copy the Haplotype in the receptor Haplotype.
           Time complexity O(1).

      */
//Haplotype& operator=(const Haplotype& g);


Haplotype* clone(){return new Haplotype(*this);};

      /**
         @memo Is equal
         @param g: Haplotype to compare with.
	 @return
           Return true if all the Haplotype is the same, false otherwise.
         @doc Time complexity O(1).

      */
bool operator==(Haplotype & g);//{cout <<"Not implemented yet"; exit(0);};;
;
      /**
         @memo Is different
         @param g, position: Haplotype to compare with.
	 @return
           Return true if the SNP is different, false otherwise.
         @doc Time complexity O(1).

      */
bool operator!=(Haplotype & g);

SNPPos size();
   


base* getHaplotypeArray ();



bool isMissing(SNPPos position);
	  

bool IsMarked(SNPPos SNP);

 
 	  /**
         @memo Increase the counter of the total number of known haplotypes between two positions.
         @param comb: pointer to a 5-integer array: 1: 11, 2:12, 3: 21, 4: 22
         @param IndHaplotype: individual whose haplotype is going to be checked
         @param FirstSNP, LastSNP: the two loci
     */

void setHaplotypeArray (base * alleleArray, SNPPos size);

void setAllele(base base, SNPPos SNP);

string printSNP(SNPPos SNP, bool markUnphased=false);


double getDistance(Haplotype* other);


base& operator[] (int position);

base getAllele(SNPPos SNP);


		bool  operator>(const Haplotype & ge);

		bool  operator<(const Haplotype & ge);

static Haplotype* fromString(string s);

};  // End of class Haplotype

ostream& operator<<(ostream& out, Haplotype& haplotype)
{
try
{
for (int i=0; i<haplotype.size();i++)
{
haplotype.checkBase(i);
out << UnconvertAllele((allele)haplotype.alleleArray[i]);
}
}
catch (BasicException& be){be.addMessage("operator<<(ostream& out, Haplotype& haplotype)"); throw;}
return out;
}
 

};  // End of Namespace

#endif

/* End of file: Haplotype.h */




