/* File: ImportFormat.h */


#ifndef __ImportFormat_h__
#define __ImportFormat_h__


#include <string>






namespace BIOS {

/*____________________________________________________________ */

void ImportFromPHASE (char *filename, char* filename2, unsigned int size, SNPPos TotalSNPs);




/*____________________________________________________________ */

void ImportFromSNPHAP (char *filename, char* filename2, unsigned int Size, SNPPos TotalSNPs);

void ImportFromHTYPER (char *filename, char *filename2, unsigned int Size, SNPPos TotalSNPs, FormatType Algorithm);

void ImportFromMSAMPLE (char *filename, char *filename2, bool fixedNumberOfSNPs=true, long int nsites=1) ;

void ImportFromCOSI (char *filename, char *filename2, SNPPos TotalSNPs) ;
void ImportFromHAP (char *filename, char *filename2, SNPPos TotalSNPs) ;

void ImportFromML (const char *filename, char *filename2, SNPPos TotalSNPs) ;
void ImportFromMLC (char *filename, const char *filename2, SNPPos TotalSNPs) ;

void ImportFromPED (char *filename, char *filename2, SNPPos TotalSNPs) ;

void ImportFromHUDSON (char *filename);

void ImportFromWTCCC (char *filename, char *filename2);

};  // Fin del Namespace

#endif
/* Fin Fichero: ImportFormat.h */
