/* File: MultimarkerMeasure.h */

#ifndef __MultimarkerMeasure_h__
#define __MultimarkerMeasure_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
	template <class T> class MultimarkerMeasure {


public:

    /** @name Declaration of class MultimarkerMeasure
        @memo Private part.
    */

	 
AmbiguousArray *tableGenotypes;


SNPPos totalPos;
BayesType  Bayes;
float alphaBayes;
float distance;


	   double** SNPAbsFreqs;

   double** SNPFreqs;


       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */

    double GetnxyKnown(bool IsMajor1, bool IsMajor2);


	void CheckFrequency (double f, bool fa);


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:

int* totalAlleles;

allele** allAlleles;

bool tdt;


			double totalGenotypes;

   HeteroListPair<long long int, double>* genotypeFreqs;//, * haplotypeCounts, *haplotypeCountsU, *mm;


longLongList* genotypeCountsFather,* genotypeCountsMother;

//  MultidimensionalTable<double>* genotypeAbsFreqsTab;

void setGenotypeTable();

//void setGenotypeAbsFreqs();

      /** @name Operations on MultimarkerMeasure 
        @memo Operations on a MultimarkerMeasure 
    */
	MultimarkerMeasure(SNPPos Pos[], SNPPos totalPos, T * samp, int gender=everyGender, int affectation=allAffectation, BayesType  Bay=MLE, float alphaBayes=0, float distance=0.0, bool tdt=false);

	
 MultimarkerMeasure(MultimarkerMeasure& source);
 MultimarkerMeasure();

	void set(SNPPos Pos[], SNPPos totalPos, T * samp, int gender=everyGender, int affectation=allAffectation, BayesType  Bay=MLE, float alphaBayes=0.0, float distance=0.0, bool tdt=false);

	MultimarkerMeasure(T * samp);

MultimarkerMeasure<T>* convertToKnownGenotypes(MultidimensionalTable<double>* haplotypeFreqsTab, MultidimensionalTable<double>* haplotypeFreqsTabU);

 void empty();


	~MultimarkerMeasure()
	{
empty();
	};

void setGenotypeFreqs ();


longLongList* permuteInParent(bool father);


double getTotalKnown();

void setSNPFreqs();

//IndPos getHapFreq(int* pos);

//IndPos getHapFreq(int pos);

   //     int GetAllelePair();

//	int getTotalDifferentHaplotypes();

static void addBayes(HeteroListPair<long long int, double>* list, MultidimensionalEmptyTable<int>* table, double totalElements, BayesType Bayes, float alpha, float distance);


 MultidimensionalTable<double>* getGenotypeAbsFreqs();


	//IndPos SetBootstrapFrequenciesOld(double *DPrimeList, unsigned long int size);

	IndPos SetBootstrapFrequencies(double* AbsDPrimeList, unsigned long int size);

	IndPos SetBootstrapFrequenciesFast(double* AbsDPrimeList, unsigned long int size);

longLongList* updatePermutationsInChildren(longLongList* genotypeCountsFather, longLongList* genotypeCountsMother);

//	void GetSampleFrequencies(IndPos & bnAB, IndPos & bnAb,IndPos & bnaB,IndPos & bnab);

	 MultimarkerMeasure* clone();


	 void set(T* sample, int gender, int affectation, int* pos);

	 void setCounters(T* sample, int gender, int affectation, int* pos);


void setAlleles(T* sample, int* pos);

virtual void addBayes();

void setTotalGenotypes();


// BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans);



//bool isSNP(SNPPos i);

//BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans);

virtual MultimarkerMeasure<T> * getPermutation ();

 ostream& print (ostream& out) {out << *this; return out;};

//CPT* getCPT(bool disease0-sex1);

};  // End of class MultimarkerMeasure

template <class T> ostream& operator<<(ostream& out, MultimarkerMeasure<T>& pm)
       {
if (pm.genotypeCountsFather!=NULL)
cout <<"\nfather counts: " << *pm.genotypeCountsFather;
if (pm.genotypeCountsMother!=NULL)
cout <<"\nmother counts: " << *pm.genotypeCountsMother;
cout << "\ngentype freqs:" << *pm.genotypeFreqs;
cout << "\ngentype freqs:" << *pm.genotypeFreqs;
cout <<"\ntotal alleles:\n";
for (int i=0; i<pm.totalPos; i++)
 cout <<"pos " << i <<": " << pm.totalAlleles[i] <<"\n";

  // out << *pm.haplotypeCounts;
// out << pm.GetnA() <<", " << pm.GetnB()  <<", " << pm.GetTotalKnown() <<", " << pm.GetTotalUnKnown()  <<", " << pm.GetnAB() <<"\n";

return out;
};



};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




