/* File: PairGenotype.h */


#ifndef __PairSNPGenotype_cpp__
#define __PairSNPGenotype_cpp__



namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the First, one for the Second. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/




/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

PairSNPGenotype::PairSNPGenotype ()
{
}
/*____________________________________________________________ */

PairSNPGenotype::PairSNPGenotype (PairSNPGenotype * Source)
{
firstGenotype=Source->firstGenotype;
secondGenotype=Source->secondGenotype;
}
/*____________________________________________________________ */

PairSNPGenotype::PairSNPGenotype (Diplotype Source1, Diplotype Source2)
{
firstGenotype=Source1;
secondGenotype=Source2;
}

/*____________________________________________________________ */

Diplotype PairSNPGenotype::getFirstGenotype ()
{
	return firstGenotype;
}
/*____________________________________________________________ */

Diplotype PairSNPGenotype::getSecondGenotype ()
{
	return secondGenotype;
}
/*___________________________________________________*/

bool PairSNPGenotype::IsHomozygous1Homozygous1 (allele  MajorAllele)      
{
return firstGenotype.isHomozygous1(MajorAllele) && secondGenotype.isHomozygous1(MajorAllele);
};
/*___________________________________________________*/

bool PairSNPGenotype::IsHomozygous2Homozygous2 (allele  MajorAllele)      
{
return firstGenotype.isHomozygous2(MajorAllele) && secondGenotype.isHomozygous2(MajorAllele);
};
/*___________________________________________________*/

bool PairSNPGenotype::IsHomozygous1Homozygous2 (allele  MajorAllele)      
{
return 
(firstGenotype.isHomozygous1(MajorAllele) && secondGenotype.isHomozygous2(MajorAllele))
||
(firstGenotype.isHomozygous2(MajorAllele) && secondGenotype.isHomozygous1(MajorAllele));
};
/*___________________________________________________*/

bool PairSNPGenotype::IsHomozygous1Heterozygous (allele  MajorAllele)      
{
return 
(firstGenotype.isHomozygous1(MajorAllele) && secondGenotype.isHeterozygous(MajorAllele))
||
(firstGenotype.isHeterozygous(MajorAllele) && secondGenotype.isHomozygous1(MajorAllele));
};
/*___________________________________________________*/

bool PairSNPGenotype::IsHomozygous2Heterozygous (allele  MajorAllele)      
{
return 
(firstGenotype.isHomozygous2(MajorAllele) && secondGenotype.isHeterozygous(MajorAllele))
||
(firstGenotype.isHeterozygous(MajorAllele) && secondGenotype.isHomozygous2(MajorAllele));
};

/*___________________________________________________*/

bool PairSNPGenotype::IsHomozygousHeterozygous (allele  MajorAllele)      
{
return IsHomozygous1Heterozygous(MajorAllele)
		|| IsHomozygous2Heterozygous(MajorAllele);
};
/*___________________________________________________*/

bool PairSNPGenotype::IsHeterozygousHeterozygous (allele  MajorAllele)      
{
return firstGenotype.isHeterozygous(MajorAllele) && secondGenotype.isHeterozygous(MajorAllele);
};


/*___________________________________________________*/

bool PairSNPGenotype::IsMissingMissing (allele  MajorAllele)      
{
return firstGenotype.isAMissingSNP() && secondGenotype.isAMissingSNP();
};


/*___________________________________________________*/

bool PairSNPGenotype::IsHomozygous1Missing (allele  MajorAllele)      
{
return (firstGenotype.isHomozygous1(MajorAllele) && secondGenotype.isAMissingSNP())
||
   (firstGenotype.isAMissingSNP() && secondGenotype.isHomozygous1(MajorAllele));
};

/*___________________________________________________*/

bool PairSNPGenotype::IsHomozygous2Missing (allele  MajorAllele)      
{
return (firstGenotype.isHomozygous2(MajorAllele) && secondGenotype.isAMissingSNP())
||
   (firstGenotype.isAMissingSNP() && secondGenotype.isHomozygous2(MajorAllele));
};
/*___________________________________________________*/

bool PairSNPGenotype::IsHeterozygousMissing (allele  MajorAllele)      
{
return (firstGenotype.isHeterozygous(MajorAllele) && secondGenotype.isAMissingSNP())
||
   (firstGenotype.isAMissingSNP() && secondGenotype.isHeterozygous(MajorAllele));
};


};  // End of Namespace

#endif

/* End of file: PairGenotype.h */




