/* File: positions.cpp */

#ifndef __Positions_cpp__
#define __Positions_cpp__





#include "Positions.h"



namespace BIOS {




/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/




///////////////////
//// public ////////
///////////////////
/*____________________________________________________________ */

void Positions::CheckFilename(char* filename)
{

if (HasThisExtension(filename, "pou", 3)==false)
{
	cout <<"File pos is required";
	exit (0);
}
//	cout <<"file:" << filename;

}

/*____________________________________________________________ */

double Positions::GetDistance(SNPPos SNP, SNPPos SNP2)
{
	return GetDistance(getNode(SNP), getNode(SNP2));
}
/*____________________________________________________________ */

double Positions::GetDistance(Positions::iterator p1, Positions::iterator p2)
{
	return fabs(getPosition(p1)-getPosition(p2));
}
/*____________________________________________________________ */

unsigned long int Positions::GetTotalSNPs(SNPPos IniPos, float width)
{
return GetTotalSNPs(getNode(IniPos), width);
}
/*____________________________________________________________ */

unsigned long int Positions::GetTotalSNPs(Positions::iterator IniPos, float width)
{
//if extreme is before the Width, returns the last position
  iterator i=IniPos;
//cout <<"ddd\n";
  

  try {

double InitialPos=(getElement(IniPos))->pos;
  unsigned long int c=0;
  if (i==this->end())
     throw NullValue();


while ((i!=this->end()) && ((((getElement(i))->pos)-InitialPos)<width))
{
 ++i;
// if (i!=NULL)
 c++;

}
return c;
}
  catch (NullValue nv) {
    nv.PrintMessage(" Positions::GetTotalSNPs");
 }
}
/*____________________________________________________________ */

bool Positions::IsEndReached(Positions::iterator IniPos, float width)
{
//if extreme is before the Width, returns the last position
  iterator i=IniPos;
  double InitialPos=getElement(IniPos)->pos;
  unsigned long int c=0;
  try {
  if (i==this->end())
     throw NullValue();


while ((i!=this->end()) && (((getElement(i)->pos)-InitialPos)<width))
{
 ++i;
 if (i!=this->end())
 c++;

}

  
  }
  catch (NullValue nv) {
    nv.PrintMessage(" Positions::IsEndReached");
 }
  
 if (i==this->end()) return true;
 else return false;
}
/*____________________________________________________________ */

void Positions::PosSampling (doubleList  *pos)
{
	Positions* sample2;
	sample2=new Positions();
        PosS *newpos;
	doubleList::iterator p=pos->getFirst();
	iterator p2=getFirst();

	while (p!=pos->end())
	{
	 p2=GetPointerWithPos(pos->getElement(p));
	 if (p2!=end())
	 {
     newpos=getElement(p2);
	 sample2->insertElement(newpos);
	 }
	 p=pos->getNext(p);
	}
    *this=*sample2;
}
/*____________________________________________________________ */

Positions::iterator Positions::MoveToPos(iterator InitialPos, float Pos)
{
//if extreme is before the Pos, returns the last position
  iterator i=InitialPos;


  try {
  if (i==this->end())
     throw NullValue();


while ((i!=this->end()) && (((getElement(i)->pos)-(getElement(InitialPos)->pos))<Pos))
{
 ++i;
}

  
  }
  catch (NullValue nv) {
    nv.PrintMessage(" Positions::MoveToPos");
 }
  
 
  return i;
}
/*____________________________________________________________ */

Positions::iterator Positions::GetPointerWithPos(float Pos)
{
//if extreme is before the Pos, returns the last position
  iterator i=getFirst();

  try {
  if (i==this->end())
     throw NullValue();


while ((i!=this->end()))
{
 if (getElement(i)->pos==Pos)
	 return i;
 else ++i;
}

  
  }
  catch (NullValue nv) {
    nv.PrintMessage(" Positions::MoveToPos");
 }
  
 
  return i;
}
};  // Fin del Namespace

#endif

/* Fin Fichero: Positions.h */
