/* File: GenotypeSample.h */


#ifndef __RepeatedGenotypeSample_h__
#define __RepeatedGenotypeSample_h__

//#include <string.h>
//#include <cstdio>

//#include "Exceptions.h"
//#include "RepeatedPositions.h"
//#include "UnorderedRepeatedGenotypeSample.h"



using namespace std;

namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
	class RepeatedGenotypeSample: public GenotypeSample  {

/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */
      /**
         @memo Destroy the vector of SNP genotypes for an individual
	 @doc
           release memory for this vector.

      */




		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:


	  RepeatedGenotypeSample (char * filename, bool ExistPhenotype);


};  // End of class GenotypeSample



/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/

//////////// privates /////////////

/////////// protected /////////////



///////////////////
//// public ////////
///////////////////


/*____________________________________________________________ */

RepeatedGenotypeSample::RepeatedGenotypeSample (char * filename, bool  ExistPhen=true)
{
//MajorAllele=NULL;

ExistPhenotype=ExistPhen;

if (HasThisExtension(filename, "geo", 3)==false)
{
	cout <<"File geo is required";
	exit (0);
}

cout << "Reading genotypes ...\n";


getInfo(filename, "\t, \n");


cout << "Genotype reading has finished ...\n";


}



};  // End of Namespace

#endif

/* End of file: RepeatedGenotypeSample.h */





