#ifndef __SNP_cpp__
#define __SNP_cpp__

#include "SNP.h"


//using namespace UTILS;
//using namespace TAD;


namespace BIOS {



/*-------------------------------------*/
const char* PrintPhaseTypes()
{
	return (" IsPhased=0, KeepLeftRight=1, ToOrder=2, ResolveFromTU=3. dHAP=4, ResolveFromPhasedChild=5, ResolvePhaseFromFile=6, NR=7");
		/*
	for (int i=0;i<sizeof(PhaseType);i++)
	 sprintf(output,"%s, %d", output, i);
	return(output);
	*/
}
/*____________________________________________________________ */

int getPosUnknownHaplotypes (int allelePos1, int allelePos2, int var, AmbiguousArray* genotypeTable)
{
return genotypeTable->getUnknownPos(allelePos1, allelePos2, var);
};

/*____________________________________________________________ */

bool isMissing(allele a)
{
return a==NA || a==UNA;
};

/*____________________________________________________________ */

int getAllelePos (int genotypePos, int var, bool first, AmbiguousArray* genotypeTable) throw (OutOfRange<int>)
{
// it returns the allele at first. For ambiguous positions, the allele could be switched
try
{
if (genotypeTable->isAKnownPosition(genotypePos, var))
{ 
return genotypeTable->getKnownValue(genotypePos, var, first);
}
else 
{
return genotypeTable->inferValue(genotypePos, var, first);
}
}
catch (ORLLI & e) {e.addMessage("\n called from BIOS::getAllelePos"); throw; }
catch (OutOfBounds& ob){ob.addMessage("\ncalled from BIOS::getAllelePos"); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from BIOS::getAllelePos"); throw;}
};
/*____________________________________________________________ */
/*
int getPosGenotype (int al1, int al2, int var, AmbiguousArray* genotypeTable)
{
return genotypeTable->getAmbiguousPos(al1, al2, var); 
}
/*____________________________________________________________ */

int getPosGenotype (int al1, int al2, int totalAlleles)
{
// it returns the code for a "known genotype" (used for compatibility with phased and unphased conversions
return AmbiguousArray::getAmbiguousPos(al1, al2, totalAlleles); 
}

/*____________________________________________________________ */

int getTotalUnknownHaplotypes (int totalAlleles)  throw (MultiAllelic)
{
// it returns the total number of genotypes composed by unknown haplotypes
return AmbiguousArray::getTotalUnknownPos(totalAlleles); 
}
/*____________________________________________________________ */

int getTotalGenotypes (int totalAlleles) throw (MultiAllelic)
{
// it considers also genotypes with phase known from external information (as family trios)
return AmbiguousArray::getTotalPos(totalAlleles);
}

/*____________________________________________________________ */
/*
bool isAKnownHaplotype (int hapPos, int var,AmbiguousArray* genotypeTable)
{
return genotypeTable->isAKnownPosition(hapPos, var);
}


/*____________________________________________________________ */

bool isAKnownHaplotype (int hapPos, int totalAlleles)
{
return AmbiguousArray::isAKnownPos(hapPos,  totalAlleles);
}


/*____________________________________________________________ */

bool IsACorrectAllele (char value)
{
return value=='A' || value=='C' || value=='G' || value=='T' || value=='N' || value=='?' || (value>='0' && value<='4');
}

/*____________________________________________________________ */

allele ConvertAllele (const char* value) throw (NonSNP)
{
int val=0;
char pos;
bool Marked=false;
if (value[0]=='-') 
{
Marked=true;
pos=value[1];
}
else pos=value[0];

switch (pos)
{
case '0':
case 'N':
case '?': val=5; break;
case '1':
case 'A': val=1; break;
case '2':
case 'C': val=2; break;
case '3':
case 'G': val=3; break;
case '4':
case 'T': val=4; break;
default: throw NonSNP(value, "allele BIOS::ConvertAllele (const char* value)"); break;
}

//catch (NonSNP NS) {NS.PrintMessage(string("in BIOS::ConvertAllele")+string(value)).c_str();}

if (Marked) val=-val;
//zaparr(valuec);
return ((allele)val);
}
/*____________________________________________________________ */

char* UnconvertAllele (allele a)
{

char *p;

int ind=0;
vali[1]='\0';

	if ((int)a<0) 
	{
	 vali[0]='-';
	 ind=1; 
	}
	else strcpy(vali,"\0");

	if (abs((int)a)==5)  vali[ind]= '?';
	else if (abs((int)a)==1) vali[ind]='A';
	else if (abs((int)a)==2) vali[ind]='C';
	else if (abs((int)a)==3) vali[ind]='G';
	else if (abs((int)a)==4) vali[ind]='T';
	else 
		throw NonSNP(tos(a).c_str(), "char* BIOS::UnconvertAllele (allele a)");
strcat(vali,"\0");


//sprintf(val, "%d", (int)a);
	p=vali;


	return p;
}

/*____________________________________________________________ */

SNPPos getTotalSNPs(char* filegou)
{
char filePos[256];
changeExtension(filegou, filePos, "pou");
stringList* pos=new stringList(filePos);
SNPPos total=pos->size();
zap(pos);
return total;
}
/*____________________________________________________________ */

double AddBayesAllele(double Total, BayesType Bayes, float distance, float alpha)
{

 switch (Bayes)
 {
 case MLE: break;
 case UBalpha: 
 case BDistanceSymmetrical:
      Total=Total+alpha/(float)2; break;
 case equilibrium: break;
 case BDistanceUniform: Total=Total+(alpha/(float)2)*(1-exp(-distance/(float)100000)); break;
 case BDistanceMarginal: Total=Total+(alpha/(float)2)*(1-exp(-distance/(float)100000)); break;
 }

 return Total;
}
/*____________________________________________________________ */

double AddBayesMultimarkerHap(double Total, BayesType Bayes, float distance, float alpha, double totalHaplotypes)
{
 switch (Bayes)
 {
 case MLE: break;
 case UBalpha: Total=Total+(alpha/(float)totalHaplotypes); break;
 case equilibrium: break;
 case BDistanceUniform: Total=Total+(alpha/totalHaplotypes)*(1-exp(-distance/(float)100000)); break;
 }
 return Total;
}
/*____________________________________________________________ */

double AddBayesHap(double Total, BayesType Bayes, float distance, unsigned short int hap, double MLfA, double MLfB, float alpha, int totalHaplotypes)
{
 switch (Bayes)
 {
 case MLE: break;
 case UBalpha: Total=Total+(alpha/(float)totalHaplotypes); break;
 case equilibrium: break;
 case BDistanceSymmetrical: 
  switch (hap)
  {
   case 0:
   case 3:Total=Total+(alpha/(float)totalHaplotypes)*(1-exp(-distance/(float)100000)); break;
   case 1:
   case 2:Total=Total+(alpha/(float)totalHaplotypes)*(1-exp(-distance/(float)100000)); break;
  }
  break;
 case BDistanceUniform: Total=Total+(alpha/(float)totalHaplotypes)*(1-exp(-distance/(float)100000)); break;

 case BDistanceMarginal: 
  switch (hap)
  {
   case 0: Total=Total+alpha*MLfA*MLfB*(1-exp(-distance/(float)100000)); break;
   case 1: Total=Total+alpha*MLfA*(1-MLfB)*(1-exp(-distance/(float)100000)); break;
   case 2: Total=Total+alpha*(1-MLfA)*MLfB*(1-exp(-distance/(float)100000)); break;
   case 3: Total=Total+alpha*(1-MLfA)*(1-MLfB)*(1-exp(-distance/(float)100000)); break;
 }
  break;

 }
 return Total;
}
/*____________________________________________________________ */

double AddBayesGen(double Total, BayesType Bayes, float distance, float alpha, int totalGenotypes)
{
 switch (Bayes)
 {
 case MLE: break;
 case UBalpha: Total=Total+(alpha/(float)totalGenotypes); break;
 case equilibrium: break;
 case BDistanceUniform: Total=Total+(alpha/(float)totalGenotypes)*(1-exp(-distance/(float)100000)); break;
 }
 return Total;
}
/*___________________________________________________________*/

FormatType GetFormatType (char* Algorithm)
{
try
{
FormatType Alg=MAKEPED;
 if (strncmp(Algorithm, "PHASE",5)==0)
	  Alg=PHASE; // Phase

	  if (strcmp(Algorithm, "HAP\0")==0)
	  Alg=HAP; // HAP

	 if (strcmp(Algorithm, "SNPHAP\0")==0)
	  Alg=SNPHAP; // SNPHAP
	 
	 if (strcmp(Algorithm, "HTYPER\0")==0)
	  Alg=HTYPER; // HTYPER
	 
	 if (strcmp(Algorithm, "PLEM\0")==0)
	  Alg=PLEM; // PLEM
	 
	 if (strcmp(Algorithm, "PHASERECOMB\0")==0)
	  Alg=PHASERECOMB; // PHASERECOMB
	 
	 if (strcmp(Algorithm, "NR1\0")==0)
	  Alg=NR1; // NR1
	   
          if (strcmp(Algorithm, "ML\0")==0)
          Alg=ML; // ML
          if (strcmp(Algorithm, "MLC\0")==0)
          Alg=MLC; // MLC
          if (strcmp(Algorithm, "MLHAP\0")==0)
          Alg=MLHAP; // ML
          if (strcmp(Algorithm, "MLCHAP\0")==0)
          Alg=MLCHAP; // MLC
	   
	  if (strcmp(Algorithm, "MS\0")==0)
	  Alg=MS; // MS
	   
	  if (strcmp(Algorithm, "COSI\0")==0)
	  Alg=COSI; // COSI

   if (strcmp(Algorithm, "PED\0")==0)
   Alg=PED; // COSI

   if (strcmp(Algorithm, "WTCCC\0")==0)
   Alg=WTCCC; // COSI

   if (strcmp(Algorithm, "IHAP\0")==0)
   Alg=IHAP; // IHAP (as in MS)

if (Alg==MAKEPED)  throw IncorrectAlgorithm(Algorithm);
return Alg;
}
catch (IncorrectAlgorithm ia){ia.PrintMessage();};
}

} // end namespace

#endif

/* End of file: genotype.h */
